/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.bandana;

import com.atlassian.bamboo.bandana.BambooBandanaContext;
import com.atlassian.bamboo.bandana.BandanaItem;
import com.atlassian.bamboo.bandana.BandanaItemDao;
import com.atlassian.bamboo.persister.xstream.XStreamManager;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaPersister;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BandanaPersisterImpl
implements BandanaPersister {
    private final XStreamManager xStreamManager;
    private final BandanaItemDao bandanaItemDao;

    public BandanaPersisterImpl(XStreamManager xStreamManager, BandanaItemDao bandanaItemDao) {
        this.xStreamManager = xStreamManager;
        this.bandanaItemDao = bandanaItemDao;
    }

    @Nullable
    public Object retrieve(@NotNull BandanaContext bandanaContext, @NotNull String key) {
        BambooBandanaContext context = (BambooBandanaContext)bandanaContext;
        BandanaItem bandanaItem = this.bandanaItemDao.getBandanaItem(context, key);
        if (bandanaItem == null) {
            return null;
        }
        return this.getObjectFromValue(context, bandanaItem);
    }

    @NotNull
    public Map<String, Object> retrieve(@NotNull BandanaContext bandanaContext) {
        BambooBandanaContext context = (BambooBandanaContext)bandanaContext;
        Collection<BandanaItem> bandanaItems = this.bandanaItemDao.findBandanaItems(context);
        HashMap<String, Object> bandanaItemsMap = new HashMap<String, Object>();
        for (BandanaItem bandanaItem : bandanaItems) {
            bandanaItemsMap.put(bandanaItem.getKey(), this.getObjectFromValue(context, bandanaItem));
        }
        return bandanaItemsMap;
    }

    public void store(BandanaContext bandanaContext, String key, Object o) {
        this.bandanaItemDao.saveOrUpdate((BambooBandanaContext)bandanaContext, key, this.xStreamManager.toXML(o));
    }

    public void flushCaches() {
    }

    public void remove(BandanaContext bandanaContext) {
        this.bandanaItemDao.removeAllFromContext((BambooBandanaContext)bandanaContext);
    }

    public void remove(BandanaContext bandanaContext, String key) {
        this.bandanaItemDao.remove((BambooBandanaContext)bandanaContext, key);
    }

    @NotNull
    public Iterable<String> retrieveKeys(BandanaContext bandanaContext) {
        return this.bandanaItemDao.findBandanaKeys((BambooBandanaContext)bandanaContext);
    }

    private Object getObjectFromValue(@NotNull BambooBandanaContext context, @NotNull BandanaItem bandanaItem) {
        if (context.getPluginKey() != null) {
            return this.xStreamManager.fromXML(context.getPluginKey(), bandanaItem.getSerializedData());
        }
        return this.xStreamManager.fromXML(bandanaItem.getSerializedData());
    }
}

