/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.bandana;

import com.atlassian.bamboo.bandana.BambooBandanaPersister;
import com.atlassian.bamboo.bandana.BambooCachingBandanaPersister;
import com.atlassian.bamboo.bandana.BandanaItemDao;
import com.atlassian.bamboo.bandana.BandanaPersisterImpl;
import com.atlassian.bamboo.persister.xstream.XStreamManager;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaPersister;
import io.atlassian.util.concurrent.Lazy;
import java.util.Map;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;

public class DefaultBandanaPersister
implements BambooBandanaPersister {
    private static final Logger log = Logger.getLogger(DefaultBandanaPersister.class);
    @org.springframework.context.annotation.Lazy
    @Inject
    @Qualifier(value="xStreamManagerForBandana")
    XStreamManager xStreamManager;
    private final BandanaItemDao bandanaItemDao;
    private final Supplier<BandanaPersister> cachingPersister = Lazy.supplier((Supplier)new Supplier<BandanaPersister>(){

        @Override
        public BandanaPersister get() {
            BandanaPersisterImpl nonCachedPersister = new BandanaPersisterImpl(DefaultBandanaPersister.this.xStreamManager, DefaultBandanaPersister.this.bandanaItemDao);
            return new BambooCachingBandanaPersister(nonCachedPersister);
        }
    });

    public DefaultBandanaPersister(BandanaItemDao bandanaItemDao) {
        this.bandanaItemDao = bandanaItemDao;
    }

    @Nullable
    public Object retrieve(BandanaContext context, String key) {
        return this.cachingPersister.get().retrieve(context, key);
    }

    @NotNull
    public Map<String, Object> retrieve(BandanaContext context) {
        return this.cachingPersister.get().retrieve(context);
    }

    @NotNull
    public Iterable<String> retrieveKeys(BandanaContext context) {
        return this.cachingPersister.get().retrieveKeys(context);
    }

    public void store(BandanaContext context, String key, Object value) {
        this.cachingPersister.get().store(context, key, value);
    }

    public void flushCaches() {
        this.cachingPersister.get().flushCaches();
    }

    public void remove(BandanaContext context) {
        this.cachingPersister.get().remove(context);
    }

    public void remove(BandanaContext context, String key) {
        this.cachingPersister.get().remove(context, key);
    }
}

