/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.bandana;

import com.atlassian.bamboo.bandana.BambooBandanaContext;
import com.atlassian.bamboo.bandana.BambooBandanaContextImpl;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.plugin.Plugin;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanAwareBandanaContext
extends BambooBandanaContextImpl
implements Comparable<PlanAwareBandanaContext> {
    private static final Logger log = Logger.getLogger(PlanAwareBandanaContext.class);
    public static final PlanAwareBandanaContext GLOBAL_CONTEXT = new PlanAwareBandanaContext(0L, 0L, null);

    private PlanAwareBandanaContext(long chainId, long planId, @Nullable String pluginKey) {
        this(planId > 0L ? GLOBAL_CONTEXT : null, chainId, planId, pluginKey);
    }

    public PlanAwareBandanaContext(@Nullable BambooBandanaContext parentContext, long chainId, long planId, @Nullable String pluginKey) {
        super(parentContext, chainId, planId, pluginKey);
    }

    @Deprecated
    public static PlanAwareBandanaContext forPlugin(long planId, @NotNull Plugin plugin) {
        return new PlanAwareBandanaContext(planId, planId, ((Plugin)Preconditions.checkNotNull((Object)plugin, (Object)"plugin")).getKey());
    }

    public static PlanAwareBandanaContext forChainId(long chainId) {
        return new PlanAwareBandanaContext(chainId, chainId, null);
    }

    public static PlanAwareBandanaContext forPlugin(long chainId, long planId, @NotNull Plugin plugin) {
        return new PlanAwareBandanaContext(chainId, planId, ((Plugin)Preconditions.checkNotNull((Object)plugin, (Object)"plugin")).getKey());
    }

    public static PlanAwareBandanaContext forPlugin(@NotNull BambooBandanaContext parentContext, @NotNull String pluginKey) {
        return new PlanAwareBandanaContext(parentContext, parentContext.getChainId(), parentContext.getPlanId(), pluginKey);
    }

    public static PlanAwareBandanaContext forJob(@NotNull ImmutableJob job) {
        if (job.hasMaster()) {
            return new PlanAwareBandanaContext(PlanAwareBandanaContext.forJob((ImmutableJob)Preconditions.checkNotNull((Object)job.getMaster(), (Object)"master should not be null for non-master plan")), job.getParent().getId(), job.getMasterId(), null);
        }
        return new PlanAwareBandanaContext(job.getParent().getId(), job.getId(), null);
    }

    public static PlanAwareBandanaContext forPlan(@NotNull ImmutablePlan plan) {
        ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)plan, ImmutableJob.class);
        if (job != null) {
            return PlanAwareBandanaContext.forJob(job);
        }
        if (plan.hasMaster()) {
            return new PlanAwareBandanaContext(PlanAwareBandanaContext.forPlan((ImmutablePlan)Preconditions.checkNotNull((Object)plan.getMaster(), (Object)"master should not be null for non-master plan")), plan.getId(), plan.getId(), null);
        }
        return new PlanAwareBandanaContext(plan.getId(), plan.getId(), null);
    }

    @Override
    public int compareTo(PlanAwareBandanaContext other) {
        return new CompareToBuilder().append(this.getPlanId(), other.getPlanId()).append(this.getChainId(), other.getChainId()).append((Object)this.getPluginKey(), (Object)other.getPluginKey()).toComparison();
    }
}

