/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import org.apache.commons.configuration.ConversionException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class BuildConfigurationValidationUtils {
    private static final Logger log = Logger.getLogger(BuildConfigurationValidationUtils.class);

    public static void validatePostiveInteger(String paramKey, String positiveIntegerText, String notIntegerText, BuildConfiguration buildConfiguration, ErrorCollection errorCollection) {
        BuildConfigurationValidationUtils.validatePostiveInteger(paramKey, positiveIntegerText, null, null, notIntegerText, buildConfiguration, errorCollection);
    }

    public static void validatePostiveInteger(String paramKey, String positiveIntegerText, @Nullable Integer maxValue, String maxValueText, String notIntegerText, BuildConfiguration buildConfiguration, ErrorCollection errorCollection) {
        try {
            int value = buildConfiguration.getInt(paramKey);
            if (value < 0) {
                errorCollection.addError(paramKey, positiveIntegerText);
            }
            if (maxValue != null && value > maxValue) {
                errorCollection.addError(paramKey, maxValueText);
            }
        }
        catch (ConversionException e) {
            errorCollection.addError(paramKey, notIntegerText);
        }
    }
}

