/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDetectionAction;
import com.atlassian.bamboo.build.BuildDetectionActionFactory;
import com.atlassian.bamboo.build.BuildDetectionResult;
import com.atlassian.bamboo.build.BuildDetectionResultImpl;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.BuildNumberGeneratorService;
import com.atlassian.bamboo.build.DelayedChangeDetectionAction;
import com.atlassian.bamboo.build.context.BuildContextBuilderFactory;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.plan.PlanExecutionConfig;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.branch.BranchIntegrationService;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.trigger.PlanTrigger;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryService;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.variables.ResultsSummaryVariableAccessor;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.v2.trigger.ChangeDetectionManager;
import com.atlassian.bamboo.v2.trigger.ContinuedBuildDetectionAction;
import com.atlassian.bamboo.v2.trigger.DependentBuildDetectionAction;
import com.atlassian.bamboo.v2.trigger.ManualBuildDetectionAction;
import com.atlassian.bamboo.v2.trigger.PluginTriggerBuildDetectionAction;
import com.atlassian.bamboo.v2.trigger.ScheduledBuildDetectionAction;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildDetectionActionFactoryImpl
implements BuildDetectionActionFactory {
    private static final Logger log = Logger.getLogger(BuildDetectionActionFactoryImpl.class);
    private final BuildNumberGeneratorService buildNumberGenerator;
    private final ChangeDetectionManager changeDetectionManager;
    private final TriggerManager triggerManager;
    private final ErrorUpdateHandler errorUpdateHandler;
    private final BuildLoggerManager buildLoggerManager;
    private final VariableDefinitionManager variableDefinitionManager;
    private final PlanVcsRevisionHistoryService planVcsRevisionHistoryService;
    private final ResultsSummaryManager resultsSummaryManager;
    private final BranchIntegrationService branchIntegrationService;
    private final BuildContextBuilderFactory buildContextBuilderFactory;
    private final ResultsSummaryVariableAccessor resultsSummaryVariableAccessor;
    private final CustomVariableContext customVariableContext;
    private final VcsRepositoryManager vcsRepositoryManager;

    public BuildDetectionActionFactoryImpl(BuildNumberGeneratorService buildNumberGenerator, ChangeDetectionManager changeDetectionManager, TriggerManager triggerManager, ErrorUpdateHandler errorUpdateHandler, BuildLoggerManager buildLoggerManager, VariableDefinitionManager variableDefinitionManager, PlanVcsRevisionHistoryService planVcsRevisionHistoryService, ResultsSummaryManager resultsSummaryManager, BranchIntegrationService branchIntegrationService, BuildContextBuilderFactory buildContextBuilderFactory, ResultsSummaryVariableAccessor resultsSummaryVariableAccessor, CustomVariableContext customVariableContext, VcsRepositoryManager vcsRepositoryManager) {
        this.buildNumberGenerator = buildNumberGenerator;
        this.changeDetectionManager = changeDetectionManager;
        this.triggerManager = triggerManager;
        this.errorUpdateHandler = errorUpdateHandler;
        this.buildLoggerManager = buildLoggerManager;
        this.variableDefinitionManager = variableDefinitionManager;
        this.planVcsRevisionHistoryService = planVcsRevisionHistoryService;
        this.resultsSummaryManager = resultsSummaryManager;
        this.branchIntegrationService = branchIntegrationService;
        this.buildContextBuilderFactory = buildContextBuilderFactory;
        this.resultsSummaryVariableAccessor = resultsSummaryVariableAccessor;
        this.customVariableContext = customVariableContext;
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    @NotNull
    public BuildDetectionAction createManualBuildDetectionAction(@NotNull ImmutableChain chain, @NotNull User user, @NotNull Map<String, String> params, @NotNull Map<String, String> variables) {
        return this.createManualBuildDetectionAction(chain, user, null, params, variables);
    }

    @NotNull
    public BuildDetectionAction createManualBuildDetectionAction(@NotNull ImmutableChain chain, @NotNull User user, @Nullable PlanExecutionConfig planExecutionConfig, @NotNull Map<String, String> params, @NotNull Map<String, String> variables) {
        return this.createManualBuildDetectionAction(chain, user, planExecutionConfig, null, null, params, variables);
    }

    @NotNull
    public BuildDetectionAction createManualBuildDetectionAction(@NotNull ImmutableChain chain, @NotNull User user, @NotNull TriggerReason triggerReason, @Nullable PlanTrigger planTrigger, @Nullable PlanExecutionConfig planExecutionConfig, @NotNull Map<String, String> params, @NotNull Map<String, String> variables) {
        return this.createManualBuildDetectionAction(chain, user, planExecutionConfig, triggerReason, planTrigger, params, variables);
    }

    @NotNull
    public BuildDetectionAction createManualBuildDetectionAction(@NotNull ImmutableChain chain, @NotNull User user, @Nullable PlanExecutionConfig planExecutionConfig, @Nullable TriggerReason triggerReason, @Nullable PlanTrigger planTrigger, @NotNull Map<String, String> params, @NotNull Map<String, String> variables) {
        if (planExecutionConfig == null || planExecutionConfig.getPlanExecutionType() == PlanExecutionConfig.PlanExecutionType.ENFORCE_MANUAL_AS_AUTOMATIC || planExecutionConfig.getPlanExecutionType() == PlanExecutionConfig.PlanExecutionType.REGULAR) {
            return new ManualBuildDetectionAction(chain, user, planExecutionConfig, params, variables, this.buildNumberGenerator, this.changeDetectionManager, this.triggerManager, this.errorUpdateHandler, this.variableDefinitionManager, this.buildContextBuilderFactory);
        }
        if (planTrigger != null && triggerReason != null) {
            variables.putAll(planTrigger.getVariablesForContinuedBuild(triggerReason));
        }
        return new ContinuedBuildDetectionAction(chain, planExecutionConfig, user, triggerReason, params, variables, this.errorUpdateHandler, this.resultsSummaryManager, this.triggerManager, this.branchIntegrationService, this.buildContextBuilderFactory, this.resultsSummaryVariableAccessor, this.vcsRepositoryManager);
    }

    @NotNull
    public BuildDetectionAction createBuildDetectionActionForPluginBuildTrigger(@NotNull ImmutableChain chain, @Nullable PlanExecutionConfig planExecutionConfig, @NotNull TriggerReason triggerReason, @NotNull PlanTrigger buildTrigger, @NotNull Map<String, String> params, @NotNull Map<String, String> variables) {
        return new PluginTriggerBuildDetectionAction(this.planVcsRevisionHistoryService, this.buildNumberGenerator, this.variableDefinitionManager, this.buildContextBuilderFactory, chain, planExecutionConfig, triggerReason, buildTrigger, params, variables);
    }

    @NotNull
    public BuildDetectionAction createScheduledBuildDetectionAction(@NotNull ImmutableChain chain, @NotNull Map<String, String> triggerConditionsConfiguration) {
        return new ScheduledBuildDetectionAction(this.changeDetectionManager, this.triggerManager, this.buildNumberGenerator, this.buildLoggerManager, chain, triggerConditionsConfiguration, (Map<String, String>)ImmutableMap.of(), this.buildContextBuilderFactory);
    }

    @NotNull
    public BuildDetectionAction createScheduledBuildDetectionAction(@NotNull ImmutableChain chain, @NotNull Map<String, String> triggerConditionsConfiguration, @NotNull Map<String, String> triggerConfiguration) {
        return new ScheduledBuildDetectionAction(this.changeDetectionManager, this.triggerManager, this.buildNumberGenerator, this.buildLoggerManager, chain, triggerConditionsConfiguration, triggerConfiguration, this.buildContextBuilderFactory);
    }

    @NotNull
    public BuildDetectionAction createInitialBuildDetectionAction(@NotNull ImmutableChain chain) {
        return new InitialBuildDetectionAction(chain);
    }

    @NotNull
    public BuildDetectionAction createDependentBuildDetectionAction(@NotNull ImmutableChain chain, @NotNull ImmutableChain parentChain, @NotNull BuildContext completedBuildContext) {
        return new DependentBuildDetectionAction(chain, parentChain, completedBuildContext, this.errorUpdateHandler, this.triggerManager, this.changeDetectionManager, this.buildNumberGenerator, this.buildLoggerManager, this.planVcsRevisionHistoryService, this.buildContextBuilderFactory, this.customVariableContext, this.vcsRepositoryManager);
    }

    private class InitialBuildDetectionAction
    implements DelayedChangeDetectionAction {
        protected final ImmutableChain chain;

        public InitialBuildDetectionAction(ImmutableChain chain) {
            this.chain = chain;
        }

        @NotNull
        public BuildDetectionResult generateResultWithoutChanges() {
            BuildDefinition buildDefinition = this.chain.getBuildDefinition();
            BuildContext buildContext = null;
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            TriggerReason triggerReason = BuildDetectionActionFactoryImpl.this.triggerManager.getTriggerReason("com.atlassian.bamboo.plugin.system.triggerReason:InitialBuildTriggerReason", Collections.emptyMap());
            try {
                buildContext = BuildDetectionActionFactoryImpl.this.buildContextBuilderFactory.createBuilder().plan((ImmutablePlan)this.chain).buildNumber(BuildDetectionActionFactoryImpl.this.buildNumberGenerator.generateBuildNumber((PlanIdentifier)this.chain)).triggerReason(triggerReason).buildDefinition(buildDefinition).build();
            }
            catch (Exception e) {
                String message = "Error encountered while triggering initial build: " + e.getMessage();
                errorCollection.addErrorMessage(message);
                log.error((Object)this.chain.getBuildLogger().addBuildLogEntry(message), (Throwable)e);
                BuildDetectionActionFactoryImpl.this.errorUpdateHandler.recordError((Key)this.chain.getPlanKey(), message, (Throwable)e);
            }
            return new BuildDetectionResultImpl((ErrorCollection)errorCollection, buildContext);
        }

        public BuildChanges performDelayedChangeDetection(BuildContext buildContext) throws RepositoryException {
            return BuildDetectionActionFactoryImpl.this.changeDetectionManager.collectAllChangesSinceLastBuild(this.chain, null, null);
        }
    }
}

