/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildStatusHelper {
    private static final Logger log = Logger.getLogger(BuildStatusHelper.class);
    private final ResultsSummaryManager resultsSummaryManager;
    private final ImmutablePlan plan;
    private final PlanKey planKey;
    private final int buildNumber;
    private final ResultsSummary currentBuildResult;
    private ResultsSummary failingSince;
    private ResultsSummary succeedingSince;
    private ResultsSummary previousSuccessfulBuild;
    private ResultsSummary fixedInBuild;
    private ResultsSummary fixesBuild;

    public BuildStatusHelper(@Nullable ImmutablePlan plan, @NotNull PlanKey planKey, @NotNull ResultsSummary currentBuildResult, @NotNull ResultsSummaryManager resultsSummaryManager) {
        this.plan = plan;
        this.planKey = planKey;
        this.buildNumber = currentBuildResult.getBuildNumber();
        this.currentBuildResult = currentBuildResult;
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public BuildStatusHelper(@Nullable ImmutableBuildable buildable, @NotNull PlanKey planKey, int buildNumber, @NotNull ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
        this.plan = buildable;
        this.planKey = planKey;
        this.buildNumber = buildNumber;
        this.currentBuildResult = resultsSummaryManager.getResultsSummary(PlanKeys.getPlanResultKey((PlanKey)planKey, (int)buildNumber), BuildResultsSummary.class);
    }

    @Nullable
    public ResultsSummary getFixedInBuild() {
        if (this.currentBuildResult != null && this.fixedInBuild == null && BuildState.SUCCESS != this.currentBuildResult.getBuildState()) {
            this.fixedInBuild = this.resultsSummaryManager.findFirstSuccessfulBuildResultAfter(PlanKeys.getPlanResultKey((PlanKey)this.planKey, (int)this.buildNumber));
        }
        return this.fixedInBuild;
    }

    @Nullable
    public ResultsSummary getPreviousSuccessfulBuild() {
        if (this.previousSuccessfulBuild == null) {
            this.previousSuccessfulBuild = this.resultsSummaryManager.findLastSuccessfulBuildResultBefore(PlanKeys.getPlanResultKey((PlanKey)this.planKey, (int)this.buildNumber));
        }
        return this.previousSuccessfulBuild;
    }

    @Nullable
    public ResultsSummary getFailingSinceBuild() {
        if (this.failingSince == null && this.currentBuildResult != null && BuildState.FAILED == this.currentBuildResult.getBuildState()) {
            ResultsSummary lastSuccessfulResultsSummary = this.resultsSummaryManager.findLastSuccessfulBuildResultBefore(PlanKeys.getPlanResultKey((PlanKey)this.planKey, (int)this.buildNumber));
            this.failingSince = lastSuccessfulResultsSummary != null ? this.resultsSummaryManager.findFirstFailedBuildResultAfter(this.planKey.getKey(), lastSuccessfulResultsSummary.getBuildNumber()) : this.resultsSummaryManager.findFirstFailedBuildResultAfter(this.planKey.getKey(), 0);
        }
        return this.failingSince;
    }

    @Nullable
    public ResultsSummary getFixesBuild() {
        ResultsSummary lastSuccessful;
        if (this.fixesBuild == null && this.currentBuildResult != null && BuildState.SUCCESS == this.currentBuildResult.getBuildState() && (lastSuccessful = this.resultsSummaryManager.findLastSuccessfulBuildResultBefore(PlanKeys.getPlanResultKey((PlanKey)this.planKey, (int)this.buildNumber))) != null) {
            this.fixesBuild = this.resultsSummaryManager.findFirstFailedBuildResultBetween(this.planKey, lastSuccessful.getBuildNumber(), this.buildNumber);
        }
        return this.fixesBuild;
    }

    public int getPrecedingConsecutiveFailuresCount() {
        ResultsSummary failingSinceBuild = this.getFailingSinceBuild();
        if (failingSinceBuild != null) {
            return this.getCountOfPrecedingResultsInState(failingSinceBuild.getBuildNumber(), BuildState.FAILED);
        }
        return 0;
    }

    @Nullable
    public ResultsSummary getSucceedingSinceBuild() {
        if (this.succeedingSince == null && this.currentBuildResult != null && BuildState.SUCCESS == this.currentBuildResult.getBuildState()) {
            ResultsSummary lastFailingBuild = this.resultsSummaryManager.findLastFailingBuildResultBefore(this.planKey, this.buildNumber);
            PlanResultKey lastFailingResultKey = PlanKeys.getPlanResultKey((PlanKey)this.planKey, (int)(lastFailingBuild != null ? lastFailingBuild.getBuildNumber() : 0));
            this.succeedingSince = this.resultsSummaryManager.findFirstSuccessfulBuildResultAfter(lastFailingResultKey);
        }
        return this.succeedingSince;
    }

    public int getCountSucceedingSince() {
        ResultsSummary succeedingSinceBuild = this.getSucceedingSinceBuild();
        if (succeedingSinceBuild != null) {
            return this.buildNumber - succeedingSinceBuild.getBuildNumber() + 1;
        }
        return 0;
    }

    @NotNull
    public ImmutablePlan getBuild() {
        return this.plan;
    }

    @Nullable
    public ResultsSummary getFirstBuildInSequence() {
        ResultsSummary failingSinceBuild = this.getFailingSinceBuild();
        if (failingSinceBuild != null) {
            return failingSinceBuild;
        }
        return this.getFixesBuild();
    }

    public int getCountOfPrecedingResultsInState(int lowerBuildNumber, BuildState buildState) {
        return this.resultsSummaryManager.countResultsWithState(this.planKey, lowerBuildNumber, this.buildNumber - 1, buildState);
    }
}

