/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.logger.AdminErrorHandler;
import com.atlassian.bamboo.plan.PlanManager;
import com.opensymphony.xwork2.TextProvider;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class BuildSuspensionCheckBean {
    private static final Logger log = Logger.getLogger(BuildSuspensionCheckBean.class);
    public static final String BUILDING_SUSPENDED_ERROR_KEY = "buildingSuspendedError";
    private final TextProvider textProvider;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final AdminErrorHandler adminErrorHandler;
    private final BambooLicenseManager bambooLicenseManager;
    private final PlanManager planManager;

    public BuildSuspensionCheckBean(TextProvider textProvider, AdministrationConfigurationAccessor administrationConfigurationAccessor, AdminErrorHandler adminErrorHandler, BambooLicenseManager bambooLicenseManager, PlanManager planManager) {
        this.textProvider = textProvider;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.adminErrorHandler = adminErrorHandler;
        this.bambooLicenseManager = bambooLicenseManager;
        this.planManager = planManager;
    }

    public boolean isSuspended() {
        boolean suspended;
        boolean bl = suspended = this.bambooLicenseManager.getAllowedNumberOfPlans() != -1 && this.planManager.getPlanCount() > this.bambooLicenseManager.getAllowedNumberOfPlans();
        if (suspended) {
            String baseUrl = this.administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl();
            if (this.adminErrorHandler.getError(BUILDING_SUSPENDED_ERROR_KEY) == null) {
                this.adminErrorHandler.recordError(BUILDING_SUSPENDED_ERROR_KEY, this.textProvider.getText("build.plan.limit.reached.buildingSuspended", Arrays.asList(baseUrl + "/admin/updateLicense!doDefault.action")));
            }
        } else if (this.adminErrorHandler.getError(BUILDING_SUSPENDED_ERROR_KEY) != null) {
            this.adminErrorHandler.removeError(BUILDING_SUSPENDED_ERROR_KEY);
        }
        return suspended;
    }
}

