/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.persister.XStreamObjectPersister;
import com.atlassian.bamboo.persister.xstream.XStreamFactory;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.XStreamCurrentlyBuildingPersisterImpl;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.timing.OutOfBandBuildTimingPoints;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import io.atlassian.util.concurrent.atomic.AtomicReference;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public class CurrentlyBuildingContainer {
    private static final Logger log = Logger.getLogger(CurrentlyBuildingContainer.class);
    private static final String BUILD_IN_PROGRESS_STATE_DIRECTORY = "build-in-progress";
    private final StateReference stateReference = new StateReference();
    private final EventPublisher eventPublisher;
    private final XStreamObjectPersister<ResultKey, CurrentlyBuilding> buildInProgressPersister;
    private final AgentManager agentManager;

    public CurrentlyBuildingContainer(AgentManager agentManager, EventPublisher eventPublisher, XStreamFactory xStreamFactory) {
        this.eventPublisher = eventPublisher;
        this.agentManager = agentManager;
        File buildInProgressStateDirectory = new File(SystemDirectory.getServerStateDirectory(), BUILD_IN_PROGRESS_STATE_DIRECTORY);
        this.buildInProgressPersister = new XStreamCurrentlyBuildingPersisterImpl(xStreamFactory.createCompactXStream(), BambooFileUtils.createDirectorySupplier(buildInProgressStateDirectory));
    }

    @PostConstruct
    private void registerListener() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    private void unregisterListener() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onAgentAssignedTimingPoint(@NotNull OutOfBandBuildTimingPoints.OutOfBandAgentAssigned event) {
        this.startBuildingOnAgent(event.getPlanResultKey(), event.getAgentId());
    }

    public List<CurrentlyBuilding> getCurrentlyBuildingByKey(Key key) {
        log.debug((Object)("getCurrentlyBuildingByKey called for '" + key + "'"));
        return ((State)this.stateReference.get()).byPlan.get((Object)key);
    }

    public int numberOfCurrentlyBuildingForKey(Key key) {
        log.debug((Object)("numberOfCurrentlyBuildingForKey called for '" + key + "'"));
        return this.getCurrentlyBuildingByKey(key).size();
    }

    @NotNull
    public Iterable<CurrentlyBuilding> getCurrentlyExecuting() {
        return ((State)this.stateReference.get()).byAgentId.values().stream().filter(currentlyBuilding -> !currentlyBuilding.isCurrentlyQueuedOnly()).collect(Collectors.toList());
    }

    @Nullable
    public CurrentlyBuilding getCurrentlyBuildingByResultKey(@NotNull ResultKey resultKey) {
        log.debug((Object)("getCurrentlyBuildingByResultKey called for '" + resultKey + "'"));
        return ((State)this.stateReference.get()).byBuildResult.get(resultKey);
    }

    @Nullable
    public CurrentlyBuilding getCurrentlyBuilding(long agentId) {
        log.debug((Object)("getCurrentlyBuilding called for agent '" + agentId + "'"));
        return ((State)this.stateReference.get()).byAgentId.get(agentId);
    }

    @NotNull
    public CurrentlyBuilding setCurrentlyBuilding(@NotNull BuildContext buildContext, @NotNull CurrentlyBuilding currentlyBuilding, Collection<BuildAgent> executableAgents, Collection<ElasticImageConfiguration> executableImages) {
        log.debug((Object)("setCurrentlyBuilding called for '" + buildContext.getPlanResultKey() + "'"));
        CurrentlyBuilding building = this.stateReference.getOrSet(buildContext.getResultKey(), currentlyBuilding);
        this.saveState(building, false);
        return building;
    }

    @NotNull
    CurrentlyBuilding startBuildingOnAgent(@NotNull PlanResultKey planResultKey, long agentId) {
        log.info((Object)("startBuildingOnAgent called for [" + planResultKey + "], agent " + agentId));
        CurrentlyBuilding currentlyBuilding = this.getCurrentlyBuildingByResultKey((ResultKey)planResultKey);
        Preconditions.checkState((currentlyBuilding != null ? 1 : 0) != 0, (String)"startBuildingOnAgent cannot be called on a terminated build or before 'currently building' has been set. Called for %s on agent %s", (Object[])new Object[]{planResultKey, agentId});
        this.stateReference.update(state -> ((State)state).buildOnAgent(agentId, currentlyBuilding));
        currentlyBuilding.setBuildAgentId(Long.valueOf(agentId));
        this.saveState(currentlyBuilding, true);
        return currentlyBuilding;
    }

    @Nullable
    public CurrentlyBuilding removeCurrentlyBuilding(@NotNull ResultKey resultKey) {
        log.info((Object)("removeCurrentlyBuilding called for [" + resultKey + "]"));
        CurrentlyBuilding existing = ((State)this.stateReference.get()).get(resultKey);
        if (existing == null) {
            log.info((Object)("removeCurrentlyBuilding called for [" + resultKey + "] but the plan did not exist in CBC"));
            return null;
        }
        this.stateReference.update(state -> {
            log.debug((Object)("removeCurrentlyBuilding called for [" + resultKey + "] and state removed"));
            return ((State)state).remove(resultKey);
        });
        this.removeSavedState(resultKey);
        return existing;
    }

    public Set<ResultKey> restoreState(Set<PlanResultKey> pendingBuildKeys) {
        HashSet<ResultKey> result = new HashSet<ResultKey>();
        for (Pair pair : this.buildInProgressPersister.loadAndRemoveAll()) {
            ResultKey resultKey = (ResultKey)pair.getFirst();
            CurrentlyBuilding cb = (CurrentlyBuilding)pair.getSecond();
            if (!pendingBuildKeys.contains(resultKey) || !this.isResultPossibleToRecover(resultKey, cb)) continue;
            this.stateReference.getOrSet(resultKey, cb);
            this.saveState(cb, true);
            result.add(resultKey);
        }
        return result;
    }

    private boolean isResultPossibleToRecover(ResultKey resultKey, CurrentlyBuilding currentlyBuilding) {
        Long agentId = currentlyBuilding.getBuildAgentId();
        if (agentId == null) {
            log.info((Object)("Restored " + resultKey + " without an assigned agent"));
            return true;
        }
        log.info((Object)("Restored " + resultKey + " running on agent " + agentId));
        return this.agentManager.updateAgentStatusIfResultReturnPossibleAfterServerRestart(agentId.longValue(), resultKey, resultKey.toString(), -1L);
    }

    protected void saveState(CurrentlyBuilding currentlyBuilding, boolean saveEvenIfFileExists) {
        if (SystemProperty.PERSIST_RUNTIME_STATE.getTypedValue()) {
            this.buildInProgressPersister.save((Object)currentlyBuilding, saveEvenIfFileExists);
        }
    }

    private void removeSavedState(ResultKey resultKey) {
        if (SystemProperty.PERSIST_RUNTIME_STATE.getTypedValue()) {
            this.buildInProgressPersister.remove((Key)resultKey);
        }
    }

    static class StateReference
    extends AtomicReference<State> {
        StateReference() {
            super((Object)new State());
        }

        @NotNull
        CurrentlyBuilding getOrSet(ResultKey resultKey, CurrentlyBuilding currentlyBuilding) {
            State newState;
            State currentState;
            boolean hasntChanged;
            do {
                CurrentlyBuilding alreadyBuilding;
                if ((alreadyBuilding = (currentState = (State)this.get()).get(resultKey)) != null) {
                    return alreadyBuilding;
                }
                newState = currentState.create(resultKey, currentlyBuilding);
            } while (!(hasntChanged = currentState == this.get()) || !this.compareAndSet(currentState, newState));
            return currentlyBuilding;
        }
    }

    private static final class State {
        final Map<ResultKey, CurrentlyBuilding> byBuildResult;
        final Map<Long, CurrentlyBuilding> byAgentId;
        final ListMultimap<Key, CurrentlyBuilding> byPlan;

        private State() {
            this.byBuildResult = Collections.emptyMap();
            this.byAgentId = Collections.emptyMap();
            ArrayListMultimap byPlan = ArrayListMultimap.create();
            this.byPlan = Multimaps.unmodifiableListMultimap((ListMultimap)byPlan);
        }

        private State(Map<ResultKey, CurrentlyBuilding> byBuildResult, Map<Long, CurrentlyBuilding> byAgentId, ListMultimap<Key, CurrentlyBuilding> byPlan) {
            this.byBuildResult = ImmutableMap.copyOf(byBuildResult);
            this.byAgentId = ImmutableMap.copyOf(byAgentId);
            this.byPlan = ImmutableListMultimap.copyOf(byPlan);
        }

        @Nullable
        private CurrentlyBuilding get(@NotNull ResultKey resultKey) {
            return this.byBuildResult.get(resultKey);
        }

        private State create(@NotNull ResultKey resultKey, @NotNull CurrentlyBuilding building) {
            Map<Long, CurrentlyBuilding> byAgentId;
            HashMap<ResultKey, CurrentlyBuilding> byBuildResult = new HashMap<ResultKey, CurrentlyBuilding>(this.byBuildResult);
            byBuildResult.put(resultKey, building);
            Long agentId = building.getBuildAgentId();
            if (agentId != null) {
                byAgentId = new HashMap<Long, CurrentlyBuilding>(this.byAgentId);
                byAgentId.put(agentId, building);
            } else {
                byAgentId = this.byAgentId;
            }
            ArrayListMultimap byPlan = ArrayListMultimap.create(this.byPlan);
            byPlan.put((Object)resultKey.getEntityKey(), (Object)building);
            log.debug((Object)("State created for '" + resultKey + "' for agent id '" + agentId + "'"));
            return new State(byBuildResult, byAgentId, (ListMultimap<Key, CurrentlyBuilding>)byPlan);
        }

        private State buildOnAgent(long agentId, @NotNull CurrentlyBuilding building) {
            HashMap<Long, CurrentlyBuilding> byAgentId = new HashMap<Long, CurrentlyBuilding>(this.byAgentId);
            CurrentlyBuilding previousBuild = byAgentId.put(agentId, building);
            if (previousBuild != null) {
                log.info((Object)("Agent " + agentId + " finished building " + previousBuild.getBuildIdentifier().getPlanResultKey() + ", but the build is still processed by the server. Detaching it from the agent"));
                previousBuild.setBuildAgentId(null);
            }
            log.debug((Object)("Build agent '" + agentId + "' set for '" + building.getBuildIdentifier().getPlanResultKey() + "'"));
            return new State(this.byBuildResult, byAgentId, this.byPlan);
        }

        private State remove(@NotNull ResultKey resultKey) {
            CurrentlyBuilding cbDirectlyByBuildResult = this.byBuildResult.get(resultKey);
            if (cbDirectlyByBuildResult == null) {
                return this;
            }
            HashMap<ResultKey, CurrentlyBuilding> byBuildResultClone = new HashMap<ResultKey, CurrentlyBuilding>(this.byBuildResult);
            byBuildResultClone.remove(resultKey);
            HashMap<Long, CurrentlyBuilding> byAgentIdClone = new HashMap<Long, CurrentlyBuilding>(this.byAgentId);
            Long agentIdByBuildResult = cbDirectlyByBuildResult.getBuildAgentId();
            if (agentIdByBuildResult != null) {
                CurrentlyBuilding cbIndirectlyByBuildResult = (CurrentlyBuilding)byAgentIdClone.get(agentIdByBuildResult);
                if (cbDirectlyByBuildResult.equals(cbIndirectlyByBuildResult)) {
                    byAgentIdClone.remove(agentIdByBuildResult);
                } else {
                    log.error((Object)("An incorrect mapping between agent (" + agentIdByBuildResult + ") and build (" + resultKey + ") has been detected."));
                }
            }
            ArrayListMultimap byPlan = ArrayListMultimap.create(this.byPlan);
            byPlan.remove((Object)resultKey.getEntityKey(), (Object)cbDirectlyByBuildResult);
            return new State(byBuildResultClone, byAgentIdClone, (ListMultimap<Key, CurrentlyBuilding>)byPlan);
        }
    }
}

