/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.LimitedConcurrencyCaller;
import com.atlassian.bamboo.build.LimitedConcurrencyCallerImpl;
import com.atlassian.config.ApplicationConfiguration;
import org.apache.commons.lang3.math.NumberUtils;

public class DatabaseConnectionPoolLimitedConcurrencyFactory {
    private final ApplicationConfiguration applicationConfiguration;
    private final int defaultMaxThreadsNumber;
    private final boolean autoDetect;

    public DatabaseConnectionPoolLimitedConcurrencyFactory(ApplicationConfiguration applicationConfiguration, int defaultMaxThreadsNumber, boolean autoDetect) {
        this.applicationConfiguration = applicationConfiguration;
        this.defaultMaxThreadsNumber = defaultMaxThreadsNumber;
        this.autoDetect = autoDetect;
    }

    public LimitedConcurrencyCaller createInstance() {
        return new LimitedConcurrencyCallerImpl(this.getAllowedThreadNumber());
    }

    private int getAllowedThreadNumber() {
        if (!this.autoDetect) {
            return this.defaultMaxThreadsNumber;
        }
        String currentPoolSizeProperty = (String)this.applicationConfiguration.getProperty((Object)"hibernate.c3p0.max_size");
        if (currentPoolSizeProperty == null) {
            return this.defaultMaxThreadsNumber;
        }
        int currentPoolSize = NumberUtils.toInt((String)currentPoolSizeProperty);
        if (currentPoolSize == 0) {
            return this.defaultMaxThreadsNumber;
        }
        return currentPoolSize / 2;
    }
}

