/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.docker.DockerPipelineConfiguration;
import com.atlassian.bamboo.build.docker.DockerPipelineConfigurationImpl;
import com.atlassian.bamboo.collections.message.FinalArrayList;
import com.atlassian.bamboo.collections.message.FinalHashMap;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfiguration;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfigurationImpl;
import com.atlassian.bamboo.plan.branch.BranchMonitoringConfiguration;
import com.atlassian.bamboo.plan.branch.BranchMonitoringConfigurationImpl;
import com.atlassian.bamboo.plan.branch.BranchSpecificConfiguration;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.utils.BambooInterners;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultBuildDefinition
implements BuildDefinition {
    protected Boolean cleanWorkingDirectory;
    protected transient BranchMonitoringConfiguration branchMonitoringConfiguration;
    protected BranchIntegrationConfiguration branchIntegrationConfiguration;
    protected BranchSpecificConfiguration branchSpecificConfiguration;
    protected DockerPipelineConfiguration dockerPipelineConfiguration;
    protected FinalHashMap<String, String> customConfiguration = new FinalHashMap();
    protected transient Map<String, Object> configObjects = new HashMap<String, Object>();
    protected transient List<TaskDefinition> taskDefinitions = new ArrayList<TaskDefinition>();
    protected FinalArrayList<TriggerDefinition> triggerDefinitions;
    protected Long repositoryDefiningWorkingDir;
    private boolean merged;

    public DefaultBuildDefinition(boolean merged) {
        this.merged = merged;
    }

    public DefaultBuildDefinition(@NotNull BuildDefinition other) {
        this.cleanWorkingDirectory = other.isCleanWorkingDirectory();
        this.branchMonitoringConfiguration = other.getBranchMonitoringConfiguration();
        this.branchIntegrationConfiguration = other.getBranchIntegrationConfiguration();
        this.branchSpecificConfiguration = other.getBranchSpecificConfiguration();
        this.dockerPipelineConfiguration = other.getDockerPipelineConfiguration();
        this.repositoryDefiningWorkingDir = other.getRepositoryIdDefiningWorkingDir();
        this.customConfiguration = new FinalHashMap(other.getCustomConfiguration());
        this.configObjects = new HashMap<String, Object>(other.getConfigObjects());
        this.taskDefinitions = new ArrayList<TaskDefinition>(other.getTaskDefinitions());
        this.triggerDefinitions = other.getTriggerDefinitions() != null ? new FinalArrayList((Collection)other.getTriggerDefinitions()) : null;
        this.merged = other.isMerged();
    }

    @Nullable
    public List<TriggerDefinition> getTriggerDefinitions() {
        if (!this.isValidValue(this.triggerDefinitions)) {
            this.triggerDefinitions = new FinalArrayList();
        }
        return this.triggerDefinitions == null ? null : Collections.unmodifiableList(this.triggerDefinitions);
    }

    public void setTriggerDefinitions(@Nullable List<TriggerDefinition> triggerDefinitions) {
        this.triggerDefinitions = FinalArrayList.nullOrCopy(triggerDefinitions);
    }

    @NotNull
    public BranchMonitoringConfiguration getBranchMonitoringConfiguration() {
        if (!this.isValidValue(this.branchMonitoringConfiguration)) {
            this.branchMonitoringConfiguration = new BranchMonitoringConfigurationImpl();
        }
        return this.branchMonitoringConfiguration;
    }

    public void setBranchMonitoringConfiguration(@Nullable BranchMonitoringConfiguration branchMonitoringConfiguration) {
        this.branchMonitoringConfiguration = branchMonitoringConfiguration;
    }

    @NotNull
    public BranchIntegrationConfiguration getBranchIntegrationConfiguration() {
        if (!this.isValidValue(this.branchIntegrationConfiguration)) {
            this.branchIntegrationConfiguration = new BranchIntegrationConfigurationImpl();
        }
        return this.branchIntegrationConfiguration;
    }

    public void setBranchIntegrationConfiguration(@Nullable BranchIntegrationConfiguration branchIntegrationConfiguration) {
        this.branchIntegrationConfiguration = branchIntegrationConfiguration;
    }

    @NotNull
    public Map<String, String> getCustomConfiguration() {
        return this.customConfiguration;
    }

    public void setCustomConfiguration(@NotNull Map<String, String> customConfiguration) {
        this.customConfiguration = new FinalHashMap(BambooInterners.intern(customConfiguration));
    }

    @NotNull
    public Map<String, Object> getConfigObjects() {
        return this.configObjects;
    }

    public void setConfigObjects(@NotNull Map<String, Object> configObjects) {
        this.configObjects = configObjects;
    }

    @NotNull
    public List<TaskDefinition> getTaskDefinitions() {
        return this.taskDefinitions;
    }

    public void setTaskDefinitions(@NotNull List<TaskDefinition> taskConfigs) {
        this.taskDefinitions = taskConfigs;
    }

    @NotNull
    public Boolean isCleanWorkingDirectory() {
        return this.isValidValue(this.cleanWorkingDirectory) ? this.cleanWorkingDirectory : Boolean.FALSE;
    }

    public void setCleanWorkingDirectory(boolean cleanWorkingDirectory) {
        this.cleanWorkingDirectory = cleanWorkingDirectory;
    }

    @NotNull
    public Long getRepositoryIdDefiningWorkingDir() {
        return this.isValidValue(this.repositoryDefiningWorkingDir) ? this.repositoryDefiningWorkingDir : Long.valueOf(-1L);
    }

    public void setRepositoryIdDefiningWorkingDir(long repositoryDefiningWorkingDir) {
        this.repositoryDefiningWorkingDir = repositoryDefiningWorkingDir;
    }

    @NotNull
    public BranchSpecificConfiguration getBranchSpecificConfiguration() {
        if (!this.isValidValue(this.branchSpecificConfiguration)) {
            this.branchSpecificConfiguration = new BranchSpecificConfiguration();
        }
        return this.branchSpecificConfiguration;
    }

    public void setBranchSpecificConfiguration(BranchSpecificConfiguration branchSpecificConfiguration) {
        this.branchSpecificConfiguration = branchSpecificConfiguration;
    }

    @NotNull
    public DockerPipelineConfiguration getDockerPipelineConfiguration() {
        if (!this.isValidValue(this.dockerPipelineConfiguration)) {
            this.dockerPipelineConfiguration = new DockerPipelineConfigurationImpl();
        }
        return this.dockerPipelineConfiguration;
    }

    public void setDockerPipelineConfiguration(@NotNull DockerPipelineConfiguration dockerPipelineConfiguration) {
        this.dockerPipelineConfiguration = dockerPipelineConfiguration;
    }

    public boolean isMerged() {
        return this.merged;
    }

    public void setMerged(boolean value) {
        this.merged = value;
    }

    public boolean isValidValue(@Nullable Object validValue) {
        return validValue != null;
    }
}

