/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.schedule.PlanScheduler;
import com.atlassian.bamboo.schedule.PlanSchedulerCallback;
import com.atlassian.bamboo.serialization.ServerSideOnly;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ServerSideOnly
@ThreadSafe
public class DefaultBuildDefinitionManager
implements BuildDefinitionManager {
    private static final Logger log = Logger.getLogger(DefaultBuildDefinitionManager.class);
    private final BuildDefinitionManager target;
    private final PlanScheduler planScheduler;

    public DefaultBuildDefinitionManager(@NotNull BuildDefinitionManager target, @NotNull PlanScheduler planScheduler) {
        this.target = target;
        this.planScheduler = planScheduler;
    }

    @NotNull
    public BuildDefinition getUnmergedBuildDefinition(@NotNull PlanKey planKey) {
        return this.target.getUnmergedBuildDefinition(planKey);
    }

    @NotNull
    public BuildDefinition getBuildDefinition(@NotNull PlanKey planKey) {
        return this.target.getBuildDefinition(planKey);
    }

    @NotNull
    public BuildDefinition getBuildDefinition(@NotNull Plan plan) {
        return this.target.getBuildDefinition(plan);
    }

    public void savePlanAndDefinition(Plan plan) {
        this.target.savePlanAndDefinition(plan);
    }

    public void savePlanAndDefinition(Plan plan, final BuildConfiguration newBuildConfiguration) {
        this.planScheduler.executeWithoutPlanSchedules(new PlanSchedulerCallback(plan){

            protected void run(Plan plan) {
                DefaultBuildDefinitionManager.this.target.savePlanAndDefinition(plan, newBuildConfiguration);
            }
        });
    }

    public void savePlanAndDefinition(Plan plan, BuildDefinition newBuildDefinition) {
        this.planScheduler.executeWithoutPlanSchedules((PlanSchedulerCallback)new SaveBuildAndDefinitionCallback(plan, newBuildDefinition));
    }

    public void savePlanAndDefinition(Plan plan, BuildDefinition newBuildDefinition, boolean withQuartzJobsRestart) {
        SaveBuildAndDefinitionCallback callback = new SaveBuildAndDefinitionCallback(plan, newBuildDefinition);
        if (withQuartzJobsRestart) {
            this.planScheduler.executeWithoutPlanSchedules((PlanSchedulerCallback)callback);
        } else {
            callback.run();
        }
    }

    private class SaveBuildAndDefinitionCallback
    extends PlanSchedulerCallback {
        private final BuildDefinition newBuildDefinition;

        public SaveBuildAndDefinitionCallback(@NotNull Plan plan, BuildDefinition newBuildDefinition) {
            super(plan);
            this.newBuildDefinition = newBuildDefinition;
        }

        protected void run(Plan plan) {
            DefaultBuildDefinitionManager.this.target.savePlanAndDefinition(plan, this.newBuildDefinition);
        }
    }
}

