/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionForBuild;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.build.DefaultBuildDefinition;
import com.atlassian.bamboo.build.DefaultBuildDefinitionForBuild;
import com.atlassian.bamboo.build.DefaultBuildDefinitionManager;
import com.atlassian.bamboo.build.PartialBuildDefinition;
import com.atlassian.bamboo.build.PartialBuildDefinitionImpl;
import com.atlassian.bamboo.fieldvalue.BuildDefinitionConverter;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.module.ext.CustomBuildDefinitionGenerator;
import com.atlassian.bamboo.serialization.ServerSideOnly;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ServerSideOnly
@Internal
public class DefaultBuildDefinitionManagerTx
implements BuildDefinitionManager {
    private static final Logger log = Logger.getLogger(DefaultBuildDefinitionManager.class);
    private final BuildDefinitionConverter buildDefinitionConverter;
    private final PlanManager planManager;
    private final PluginAccessor pluginAccessor;

    public DefaultBuildDefinitionManagerTx(@NotNull BuildDefinitionConverter buildDefinitionConverter, @NotNull PlanManager planManager, @NotNull PluginAccessor pluginAccessor) {
        this.buildDefinitionConverter = buildDefinitionConverter;
        this.planManager = planManager;
        this.pluginAccessor = pluginAccessor;
    }

    @NotNull
    public BuildDefinition getUnmergedBuildDefinition(@NotNull PlanKey planKey) {
        Preconditions.checkNotNull((Object)planKey, (Object)"Cannot return definition for a build without key set.");
        Plan plan = this.getNotNullPlanByKey(planKey);
        return this.fillBuildDefinition(new PartialBuildDefinitionImpl(), plan);
    }

    @NotNull
    public BuildDefinition getBuildDefinition(@NotNull PlanKey planKey) {
        Preconditions.checkNotNull((Object)planKey, (Object)"Cannot return definition for a build without key set.");
        Plan plan = this.getNotNullPlanByKey(planKey);
        return this.getBuildDefinition(plan);
    }

    @NotNull
    public BuildDefinition getBuildDefinition(@NotNull Plan plan) {
        Plan masterPlan = (Plan)plan.getMaster();
        return masterPlan == null ? this.fillBuildDefinition(new DefaultBuildDefinition(false), plan) : this.fillBuildDefinition(new DefaultBuildDefinition(true), masterPlan, plan);
    }

    @NotNull
    private BuildDefinition fillBuildDefinition(@NotNull BuildDefinition buildDefinition, Plan ... plans) {
        buildDefinition.setMerged(plans.length > 1);
        for (Plan plan : plans) {
            BuildDefinitionForBuild buildDefinitionXml = plan.getBuildDefinitionXml();
            if (buildDefinitionXml == null || buildDefinitionXml.getXmlData() == null) continue;
            log.debug((Object)("Getting Build Configuration for '" + plan.getKey() + "'."));
            BuildConfiguration buildConfiguration = new BuildConfiguration(buildDefinitionXml.getXmlData());
            this.buildDefinitionConverter.copyConfigurationToDefinition((HierarchicalConfiguration)buildConfiguration, buildDefinition);
            List generators = this.pluginAccessor.getEnabledModulesByClass(CustomBuildDefinitionGenerator.class);
            if (generators == null) continue;
            for (CustomBuildDefinitionGenerator generator : generators) {
                generator.populateBuildDefinition((ImmutablePlan)plan, buildDefinition.getConfigObjects(), buildDefinition);
            }
        }
        return buildDefinition;
    }

    public void savePlanAndDefinition(Plan plan) {
        this.planManager.savePlan(plan);
    }

    public void savePlanAndDefinition(Plan plan, BuildConfiguration newBuildConfiguration) {
        BuildDefinitionForBuild currentBuildDefinitionXml = this.getNonNullBuildDefinitionXml(plan, newBuildConfiguration.isMerged());
        String newXmlData = newBuildConfiguration.asXml();
        if (!newXmlData.equals(currentBuildDefinitionXml.getXmlData())) {
            BuildDefinition oldDefinition = plan.getBuildDefinition();
            BuildDefinition buildDefinition = this.buildDefinitionConverter.copyConfigurationToDefinition((HierarchicalConfiguration)newBuildConfiguration, oldDefinition);
            currentBuildDefinitionXml.setXmlData(ConfigUtils.asXmlString((XMLConfiguration)this.buildDefinitionConverter.fromObject((PartialBuildDefinition)buildDefinition)));
        }
        this.planManager.savePlan(plan);
    }

    public void savePlanAndDefinition(Plan plan, BuildDefinition newBuildDefinition) {
        BuildDefinitionForBuild currentBuildDefinitionXml = this.getNonNullBuildDefinitionXml(plan, newBuildDefinition.isMerged());
        XMLConfiguration newBuildDefinitionXml = this.buildDefinitionConverter.fromObject((PartialBuildDefinition)newBuildDefinition);
        String newXmlData = ConfigUtils.asXmlString((XMLConfiguration)newBuildDefinitionXml);
        if (!newXmlData.equals(currentBuildDefinitionXml.getXmlData())) {
            currentBuildDefinitionXml.setXmlData(newXmlData);
        }
        this.planManager.savePlan(plan);
    }

    public void savePlanAndDefinition(Plan plan, BuildDefinition newBuildDefinition, boolean withQuartzJobsRestart) {
        this.savePlanAndDefinition(plan, newBuildDefinition);
    }

    @NotNull
    Plan getNotNullPlanByKey(PlanKey planKey) {
        Plan plan = this.planManager.getPlanByKey(planKey);
        if (plan == null) {
            throw new BuildDefinitionManager.BuildDefinitionNotFoundException("No plan exists for " + planKey);
        }
        return plan;
    }

    @NotNull
    private BuildDefinitionForBuild getNonNullBuildDefinitionXml(@NotNull Plan plan, boolean isMerged) {
        BuildDefinitionForBuild buildDefinitionXml = plan.getBuildDefinitionXml();
        if (buildDefinitionXml == null) {
            buildDefinitionXml = new DefaultBuildDefinitionForBuild(isMerged);
            plan.setBuildDefinitionXml(buildDefinitionXml);
        }
        return buildDefinitionXml;
    }
}

