/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.author.AuthorCreatorService;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.CurrentlyBuildingContainer;
import com.atlassian.bamboo.build.monitoring.BuildStopDelayedJob;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.event.BuildFinishedEvent;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.PlanStatePersisterService;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultSummaryHelper;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.serialization.ServerSideOnly;
import com.atlassian.bamboo.util.BambooDateUtils;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.utils.DebugUtils;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildIdentifier;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.CurrentlyBuildingImpl;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.events.BuildTriggeredEvent;
import com.atlassian.bamboo.v2.build.timing.BuildTimingPoint;
import com.atlassian.bamboo.v2.build.timing.BuildTimingPoints;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.springframework.context.annotation.Lazy;

@ServerSideOnly
public class DefaultBuildExecutionManager
implements BuildExecutionManager {
    private static final Logger log = Logger.getLogger(DefaultBuildExecutionManager.class);
    private AuthorCreatorService authorCreatorService;
    private BuildLoggerManager buildLoggerManager;
    @Lazy
    @Inject
    private CurrentlyBuildingContainer currentlyBuildingContainer;
    private EventPublisher eventPublisher;
    private CachedPlanManager cachedPlanManager;
    private PlanStatePersisterService planStatePersisterService;
    private ResultsSummaryManager resultsSummaryManager;
    private final Scheduler scheduler;

    public DefaultBuildExecutionManager(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @PostConstruct
    private void postConstruct() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    private void preDestroy() {
        this.eventPublisher.unregister((Object)this);
    }

    public void execute(@NotNull BuildContext buildContext) {
        this.authorCreatorService.createMissingAuthors(buildContext);
        this.currentlyBuildingContainer.setCurrentlyBuilding(buildContext, this.newCurrentlyBuilding(buildContext), Collections.emptyList(), Collections.emptyList());
        this.eventPublisher.publish((Object)new BuildTriggeredEvent(this, buildContext));
    }

    @NotNull
    public List<CurrentlyBuilding> getCurrentlyExecutingBuilds() {
        return Lists.newLinkedList(this.currentlyBuildingContainer.getCurrentlyExecuting());
    }

    @NotNull
    public Iterable<CurrentlyBuilding> getCurrentlyExecuting() {
        return this.currentlyBuildingContainer.getCurrentlyExecuting();
    }

    @NotNull
    public List<CurrentlyBuilding> getCurrentlyExecutingBuilds(String planKey) {
        return Lists.newLinkedList(this.getCurrentlyExecuting(PlanKeys.getPlanKey((String)planKey)));
    }

    public Iterable<CurrentlyBuilding> getCurrentlyExecuting(PlanKey planKey) {
        return BambooIterables.stream(this.currentlyBuildingContainer.getCurrentlyExecuting()).filter(executing -> executing.getBuildIdentifier().getPlanResultKey().getPlanKey().equals((Object)planKey)).collect(Collectors.toList());
    }

    @NotNull
    public List<CurrentlyBuilding> getCurrentlyBuilding(@NotNull String planKey) {
        return this.currentlyBuildingContainer.getCurrentlyBuildingByKey((Key)PlanKeys.getPlanKey((String)planKey));
    }

    @NotNull
    public List<CurrentlyBuilding> getCurrentlyBuilding(@NotNull Key key) {
        return this.currentlyBuildingContainer.getCurrentlyBuildingByKey(key);
    }

    @Nullable
    public CurrentlyBuilding getCurrentlyBuildingByBuildResultKey(@NotNull String buildResultKey) {
        return this.currentlyBuildingContainer.getCurrentlyBuildingByResultKey((ResultKey)PlanKeys.getPlanResultKey((String)buildResultKey));
    }

    @Nullable
    public CurrentlyBuilding getCurrentlyBuildingByPlanResultKey(@NotNull ResultKey resultKey) {
        return this.currentlyBuildingContainer.getCurrentlyBuildingByResultKey(resultKey);
    }

    @Nullable
    public CurrentlyBuilding getCurrentlyBuildingByBuildResult(@NotNull BuildIdentifier buildIdentifier) {
        return this.currentlyBuildingContainer.getCurrentlyBuildingByResultKey((ResultKey)buildIdentifier.getPlanResultKey());
    }

    public void setCurrentlyBuilding(@NotNull BuildContext buildContext, @NotNull Collection<BuildAgent> executableAgents, @NotNull Collection<ElasticImageConfiguration> executableImages) {
        CurrentlyBuilding currentlyBuilding = this.currentlyBuildingContainer.getCurrentlyBuildingByResultKey((ResultKey)buildContext.getPlanResultKey());
        if (currentlyBuilding == null) {
            currentlyBuilding = this.newCurrentlyBuilding(buildContext);
        }
        this.currentlyBuildingContainer.setCurrentlyBuilding(buildContext, currentlyBuilding, executableAgents, executableImages);
    }

    private CurrentlyBuilding newCurrentlyBuilding(BuildContext buildContext) {
        PlanKey buildPlanKey = buildContext.getPlanResultKey().getPlanKey();
        ImmutableBuildable buildable = (ImmutableBuildable)this.cachedPlanManager.getPlanByKey(buildPlanKey, ImmutableBuildable.class);
        Preconditions.checkNotNull((Object)buildable, (Object)("Unable to find [" + buildPlanKey + ']'));
        return new CurrentlyBuildingImpl((BuildIdentifier)buildContext, buildContext.getBuildChanges(), buildContext.getTriggerReason(), buildable.getAverageBuildDuration());
    }

    @Nullable
    public CurrentlyBuilding getBuildRunningOnAgent(@NotNull Long buildAgentId) {
        return this.currentlyBuildingContainer.getCurrentlyBuilding(buildAgentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void finishBuildInternal(@NotNull PlanResultKey planResultKey, @Nullable BuildContext buildContext, boolean needsStateCleanup, boolean updateFollowingBuilds) {
        BuildState buildState;
        LifeCycleState lifeCycleState;
        block8: {
            boolean needToSetNotBuild;
            CurrentlyBuilding removedCb = this.removeCurrentlyBuilding((ResultKey)planResultKey);
            if (removedCb == null) {
                log.info((Object)("Did not remove " + planResultKey + " from CBC"));
            }
            log.debug((Object)"Unschedulling stopped job");
            this.unscheduleStopBuildJob(planResultKey);
            lifeCycleState = LifeCycleState.NOT_BUILT;
            buildState = BuildState.UNKNOWN;
            ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(planResultKey);
            Preconditions.checkState((boolean)(resultsSummary instanceof BuildResultsSummary), (Object)"This method is not supposed to operate on chain results");
            try {
                if (resultsSummary != null) {
                    if (removedCb != null && needsStateCleanup) {
                        log.debug((Object)"Updating cancellation details");
                        ResultSummaryHelper.updateCancellationDetails(resultsSummary, removedCb.getBuildCancelledDetails());
                        this.resultsSummaryManager.saveResultSummary(resultsSummary);
                    }
                    lifeCycleState = resultsSummary.getLifeCycleState();
                    buildState = resultsSummary.getBuildState();
                }
                if (!needsStateCleanup) break block8;
            }
            catch (Throwable throwable) {
                if (needsStateCleanup) {
                    boolean needToSetNotBuild2;
                    log.debug((Object)"Cleaning up state");
                    boolean bl = needToSetNotBuild2 = lifeCycleState == LifeCycleState.NOT_BUILT || removedCb == null && !LifeCycleState.isFinalized((LifeCycleState)lifeCycleState) || LifeCycleState.isWaiting((LifeCycleState)lifeCycleState);
                    if (resultsSummary != null && needToSetNotBuild2) {
                        log.debug((Object)"Saving not build build result");
                        buildState = BuildState.UNKNOWN;
                        lifeCycleState = LifeCycleState.NOT_BUILT;
                        this.planStatePersisterService.saveNotBuiltBuildResult(planResultKey, updateFollowingBuilds);
                    }
                }
                log.debug((Object)"Publishing build finished event");
                this.eventPublisher.publish((Object)new BuildFinishedEvent(this, planResultKey, buildState, lifeCycleState, buildContext));
                log.debug((Object)"Removing build logger");
                this.buildLoggerManager.removeBuildLogger(planResultKey);
                throw throwable;
            }
            log.debug((Object)"Cleaning up state");
            boolean bl = needToSetNotBuild = lifeCycleState == LifeCycleState.NOT_BUILT || removedCb == null && !LifeCycleState.isFinalized((LifeCycleState)lifeCycleState) || LifeCycleState.isWaiting((LifeCycleState)lifeCycleState);
            if (resultsSummary != null && needToSetNotBuild) {
                log.debug((Object)"Saving not build build result");
                buildState = BuildState.UNKNOWN;
                lifeCycleState = LifeCycleState.NOT_BUILT;
                this.planStatePersisterService.saveNotBuiltBuildResult(planResultKey, updateFollowingBuilds);
            }
        }
        log.debug((Object)"Publishing build finished event");
        this.eventPublisher.publish((Object)new BuildFinishedEvent(this, planResultKey, buildState, lifeCycleState, buildContext));
        log.debug((Object)"Removing build logger");
        this.buildLoggerManager.removeBuildLogger(planResultKey);
    }

    public void finishBuildWithCleanState(@NotNull PlanResultKey planResultKey, @NotNull BuildContext buildContext) {
        this.finishBuildInternal(planResultKey, buildContext, false, false);
    }

    public void finishBuild(@NotNull PlanResultKey planResultKey, boolean updateFollowingBuilds) {
        this.finishBuildInternal(planResultKey, null, true, updateFollowingBuilds);
    }

    public void finishBuildNewTx(@NotNull PlanResultKey planResultKey, boolean updateFollowingBuilds) {
        this.finishBuild(planResultKey, updateFollowingBuilds);
    }

    private void unscheduleStopBuildJob(PlanResultKey planResultKey) {
        String groupName = BuildStopDelayedJob.getJobGroupName();
        try {
            JobKey jobKey = new JobKey(BuildStopDelayedJob.getJobName(planResultKey), groupName);
            this.scheduler.deleteJob(jobKey);
        }
        catch (SchedulerException e) {
            log.error((Object)("Unable to delete scheduled job: " + groupName));
        }
    }

    public CurrentlyBuilding removeCurrentlyBuilding(@NotNull String planKey) {
        return this.currentlyBuildingContainer.removeCurrentlyBuilding((ResultKey)PlanKeys.getPlanResultKey((String)planKey));
    }

    @Nullable
    public CurrentlyBuilding removeCurrentlyBuilding(@NotNull ResultKey resultKey) {
        return this.currentlyBuildingContainer.removeCurrentlyBuilding(resultKey);
    }

    @EventListener
    public void onQueuedTimingPoint(@NotNull BuildTimingPoints.Queued event) {
        DebugUtils.logTimingPoint("onQueuedTimingPoint", (BuildTimingPoint)event, log);
        PlanResultKey resultKey = event.getPlanResultKey();
        BuildContext buildContext = event.getBuildContext();
        CurrentlyBuilding currentlyBuilding = this.getCurrentlyBuildingByPlanResultKey((ResultKey)resultKey);
        if (currentlyBuilding != null) {
            CurrentBuildResult currentBuildResult = buildContext.getBuildResult();
            if (LifeCycleState.isExpectedStateTransition((LifeCycleState)currentBuildResult.getLifeCycleState(), (LifeCycleState)LifeCycleState.QUEUED)) {
                currentBuildResult.setLifeCycleState(LifeCycleState.QUEUED);
            }
            currentBuildResult.getCustomBuildData().put("buildTimeStamp", BambooDateUtils.toIsoTimestampString((Date)currentlyBuilding.getQueueTime()));
            this.resultsSummaryManager.updateLifeCycleState((BuildIdentifier)buildContext, currentBuildResult.getLifeCycleState(), currentBuildResult.getBuildState());
        } else {
            log.error((Object)("Plan " + resultKey + " onQueuedTimingPoint but plan not detected to have begun."));
        }
    }

    @EventListener
    public void onVcsSyncStartedTimingPoint(@NotNull BuildTimingPoints.VcsSyncStarted event) {
        DebugUtils.logTimingPoint("onVcsSyncStartedTimingPoint", (BuildTimingPoint)event, log);
        PlanResultKey resultKey = event.getPlanResultKey();
        CurrentlyBuilding currentlyBuilding = this.getCurrentlyBuildingByPlanResultKey((ResultKey)resultKey);
        if (currentlyBuilding != null) {
            currentlyBuilding.setVcsUpdateTime(new Date());
            this.resultsSummaryManager.updateLifeCycleState(currentlyBuilding.getBuildIdentifier(), LifeCycleState.IN_PROGRESS, BuildState.UNKNOWN);
            this.currentlyBuildingContainer.saveState(currentlyBuilding, true);
        } else {
            log.error((Object)("Plan " + resultKey + " onVcsSyncStartedTimingPoint but plan not detected to have begun."));
        }
    }

    @EventListener
    public void onExecutionStartedTimingPoint(@NotNull BuildTimingPoints.ExecutionStarted event) {
        DebugUtils.logTimingPoint("onExecutionStartedTimingPoint", (BuildTimingPoint)event, log);
        PlanResultKey resultKey = event.getPlanResultKey();
        CurrentlyBuilding currentlyBuilding = this.getCurrentlyBuildingByPlanResultKey((ResultKey)resultKey);
        if (currentlyBuilding != null) {
            currentlyBuilding.startTimer();
            this.resultsSummaryManager.updateLifeCycleState(currentlyBuilding.getBuildIdentifier(), LifeCycleState.IN_PROGRESS, BuildState.UNKNOWN);
            this.currentlyBuildingContainer.saveState(currentlyBuilding, true);
        } else {
            log.error((Object)("Plan " + resultKey + " onExecutionStartedTimingPoint but plan not detected to have begun."));
        }
    }

    @EventListener
    public void onExecutionCancelledTimingPoint(@NotNull BuildTimingPoints.ExecutionCancelled event) {
        DebugUtils.logTimingPoint("onExecutionCancelledTimingPoint", (BuildTimingPoint)event, log);
        if (event.isBuildActuallyCancelled()) {
            this.unscheduleStopBuildJob(event.getPlanResultKey());
        }
    }

    @EventListener
    public void onExecutionFinishedTimingPoint(@NotNull BuildTimingPoints.ExecutionFinished event) {
        DebugUtils.logTimingPoint("onExecutionFinishedTimingPoint", (BuildTimingPoint)event, log);
        PlanResultKey resultKey = event.getPlanResultKey();
        CurrentlyBuilding currentlyBuilding = this.getCurrentlyBuildingByPlanResultKey((ResultKey)resultKey);
        if (currentlyBuilding != null) {
            currentlyBuilding.stopTimer();
        } else {
            log.error((Object)("Plan " + resultKey + " timer being stopped but plan not detected to have begun."));
        }
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }

    public void setAuthorCreatorService(AuthorCreatorService authorCreatorService) {
        this.authorCreatorService = authorCreatorService;
    }

    public void setPlanStatePersisterService(PlanStatePersisterService planStatePersisterService) {
        this.planStatePersisterService = planStatePersisterService;
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }
}

