/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.JobStatusHelper;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.plan.AbstractPlan;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanType;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscription;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryManager;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSetImpl;
import java.util.List;
import javax.persistence.Entity;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class DefaultJob
extends AbstractPlan
implements Job,
Buildable {
    private static final Logger log = Logger.getLogger(DefaultJob.class);
    public static final int NUMBER_OF_RESULTS = 10;
    private Job master;
    private ChainStage chainStage;
    private String name;
    private ArtifactDefinitionManager artifactDefinitionManager;
    private ArtifactSubscriptionManager artifactSubscriptionManager;
    private BuildResultsSummaryManager buildResultsSummaryManager;
    private RequirementSet requirementSet;
    private JobStatusHelper jobStatusHelper;

    @NotNull
    public List<TaskDefinition> getTaskDefinitions() {
        return this.getBuildDefinition().getTaskDefinitions();
    }

    @NotNull
    public PlanType getPlanType() {
        return PlanType.JOB;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.name == null) {
            this.name = this.getParent().getName() + " - " + this.getBuildName();
        }
        return this.name;
    }

    @NotNull
    public Chain getParent() {
        return this.chainStage.getChain();
    }

    @NotNull
    public ChainStage getStage() {
        return this.chainStage;
    }

    public void setStage(@Nullable ChainStage chainStage) {
        this.chainStage = chainStage;
    }

    public Job getMaster() {
        return this.master;
    }

    public void setMaster(Plan master) {
        if (master != null) {
            Job job = (Job)Narrow.to((Object)master, Job.class);
            if (job == null) {
                throw new IllegalArgumentException("Job can not have a master " + master.getPlanKey() + " of type " + master.getClass());
            }
            this.master = job;
        } else {
            this.master = null;
        }
    }

    public boolean isActive() {
        return this.jobStatusHelper.isActive();
    }

    @NotNull
    public String getCurrentStatus() {
        return this.jobStatusHelper.getCurrentStatus();
    }

    public boolean isExecuting() {
        return this.jobStatusHelper.isExecuting();
    }

    @NotNull
    public List<ArtifactDefinition> getArtifactDefinitions() {
        return this.getMaster() == null ? this.artifactDefinitionManager.findArtifactDefinitionsByPlan((ImmutablePlan)this) : this.artifactDefinitionManager.findArtifactDefinitionsByPlan((ImmutablePlan)this.getMaster());
    }

    @NotNull
    public List<ArtifactSubscription> getArtifactSubscriptions() {
        return this.getMaster() == null ? this.artifactSubscriptionManager.findSubscriptionsOfPlan((PlanIdentifier)this) : this.artifactSubscriptionManager.findSubscriptionsOfPlan((PlanIdentifier)this.getMaster());
    }

    public long getAverageBuildDuration() {
        return this.buildResultsSummaryManager.getAverageBuildTime((ImmutableBuildable)this, 10);
    }

    @NotNull
    public RequirementSet getRequirementSet() {
        if (this.requirementSet == null) {
            this.requirementSet = new RequirementSetImpl();
        }
        return this.requirementSet;
    }

    public void setRequirementSet(RequirementSet requirementSet) {
        this.requirementSet = requirementSet;
    }

    @NotNull
    public RequirementSet getEffectiveRequirementSet() {
        return this.hasMaster() ? this.getMaster().getRequirementSet() : this.getRequirementSet();
    }

    public void setBuildResultsSummaryManager(BuildResultsSummaryManager buildResultsSummaryManager) {
        this.buildResultsSummaryManager = buildResultsSummaryManager;
    }

    public BuildResultsSummaryManager getBuildResultsSummaryManager() {
        return this.buildResultsSummaryManager;
    }

    public void setBuildExecutionManager(BuildExecutionManager buildExecutionManager) {
        this.jobStatusHelper = new JobStatusHelper((ImmutableJob)this, buildExecutionManager);
    }

    public void setArtifactDefinitionManager(ArtifactDefinitionManager artifactDefinitionManager) {
        this.artifactDefinitionManager = artifactDefinitionManager;
    }

    public void setArtifactSubscriptionManager(ArtifactSubscriptionManager artifactSubscriptionManager) {
        this.artifactSubscriptionManager = artifactSubscriptionManager;
    }
}

