/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JobStatusHelper {
    private final BuildExecutionManager buildExecutionManager;
    private final ImmutableJob job;

    public JobStatusHelper(ImmutableJob job, BuildExecutionManager buildExecutionManager) {
        this.job = job;
        this.buildExecutionManager = buildExecutionManager;
    }

    public boolean isActive() {
        return !this.buildExecutionManager.getCurrentlyBuilding((Key)this.job.getPlanKey()).isEmpty() || this.job.getParent().isActive();
    }

    @NotNull
    public String getCurrentStatus() {
        if (!this.buildExecutionManager.getCurrentlyBuilding((Key)this.job.getPlanKey()).isEmpty()) {
            return "current";
        }
        ImmutableResultsSummary latestSummary = this.job.getLatestResultsSummary();
        if (latestSummary != null) {
            if (latestSummary.isSuccessful()) {
                return "success";
            }
            if (latestSummary.isFailed()) {
                return "fail";
            }
            return "notRun";
        }
        return "none";
    }

    public boolean isExecuting() {
        List currentlyBuildingList = this.buildExecutionManager.getCurrentlyBuilding((Key)this.job.getPlanKey());
        for (CurrentlyBuilding currentlyBuilding : currentlyBuildingList) {
            if (currentlyBuilding.isCurrentlyQueuedOnly()) continue;
            return true;
        }
        return false;
    }
}

