/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.LimitedConcurrencyCaller;
import java.util.concurrent.Semaphore;

public class LimitedConcurrencyCallerImpl
implements LimitedConcurrencyCaller {
    private final Semaphore semaphore;

    public LimitedConcurrencyCallerImpl(int numberOfThreads) {
        this.semaphore = new Semaphore(numberOfThreads);
    }

    @Override
    public <T, E extends Exception> T execute(LimitedConcurrencyCaller.Callable<T, E> callable) throws E {
        this.semaphore.acquireUninterruptibly();
        try {
            T t = callable.call();
            return t;
        }
        finally {
            this.semaphore.release();
        }
    }
}

