/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.JiraIssueResultsManager;
import com.atlassian.bamboo.build.PlanKeyHitCollector;
import com.atlassian.bamboo.index.AbstractDocumentHitCollector;
import com.atlassian.bamboo.index.IndexUtils;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanType;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.search.IndexedBuildResultsSearcher;
import com.atlassian.bamboo.resultsummary.search.LuceneQueryBuilder;
import com.atlassian.bamboo.utils.BambooFunctions;
import com.atlassian.bamboo.utils.collection.PartialList;
import com.atlassian.bonnie.LuceneUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LuceneBasedJiraIssueResultsManagerImpl
implements JiraIssueResultsManager {
    private static final Logger log = Logger.getLogger(LuceneBasedJiraIssueResultsManagerImpl.class);
    private IndexedBuildResultsSearcher indexedBuildResultsSearcher;
    private ResultsSummaryManager resultsSummaryManager;
    private static final List<String> CHAIN_PLAN_TYPES = Lists.newArrayList((Iterable)Iterables.transform((Iterable)PlanType.getChainPlanTypes(), BambooFunctions.getEnumName()));

    @NotNull
    public PartialList<ResultsSummary> findBuildResultsByJiraIssueKey(@Nullable List<String> issueKeys, int maxResults) {
        return this.indexedBuildResultsSearcher.search((Query)this.createResultsQuery("jiraIssueKey", issueKeys), maxResults);
    }

    public int getNumberOfRelatedBuildsByIssueKey(@Nullable List<String> issueKeys) {
        return this.indexedBuildResultsSearcher.count((Query)this.createResultsQuery("jiraIssueKey", issueKeys));
    }

    @NotNull
    public PartialList<? extends ResultsSummary> findBuildResultsByProjectKey(@NotNull String projectKey, int maxResults) {
        return this.findBuildResultsByProjectKeys((List<String>)ImmutableList.of((Object)projectKey), maxResults);
    }

    @NotNull
    public PartialList<? extends ResultsSummary> findBuildResultsByProjectKeys(@NotNull List<String> projectKeys, int maxResults) {
        return this.indexedBuildResultsSearcher.search((Query)this.createResultsQuery("jiraProjectKey", projectKeys), maxResults);
    }

    @NotNull
    public Collection<String> findPlanKeysByJiraProjectKey(@NotNull String projectKey) {
        return this.findPlanKeysByJiraProjectKeys((List<String>)ImmutableList.of((Object)projectKey));
    }

    @NotNull
    public Collection<String> findPlanKeysByJiraProjectKeys(@NotNull List<String> projectKeys) {
        return this.getPlanKeys((Query)this.createResultsQuery("jiraProjectKey", projectKeys));
    }

    @NotNull
    public Collection<String> findPlanKeysByIssueKeys(@NotNull List<String> issueKeys) {
        Query issueKeyQuery = LuceneUtils.buildSingleFieldMultiValueTermQuery((String)"jiraIssueKey", issueKeys, (boolean)false);
        return this.getPlanKeys((Query)this.makeChainQuery(issueKeyQuery));
    }

    private BooleanQuery makeChainQuery(Query issueKeyQuery) {
        Query topLevelPlanQuery = LuceneUtils.buildSingleFieldMultiValueTermQuery((String)"planType", CHAIN_PLAN_TYPES, (boolean)false);
        return IndexUtils.buildConjunctionQuery(topLevelPlanQuery, issueKeyQuery, LuceneQueryBuilder.onlyFinishedBuildsQuery());
    }

    private Collection<String> getPlanKeys(Query issueKeyQuery) {
        PlanKeyHitCollector planKeyHitCollector = new PlanKeyHitCollector();
        this.indexedBuildResultsSearcher.search(issueKeyQuery, (AbstractDocumentHitCollector)planKeyHitCollector);
        return planKeyHitCollector.getPlanKeys();
    }

    private BooleanQuery createResultsQuery(String fieldName, List<String> values) {
        Query issueKeyQuery = LuceneUtils.buildSingleFieldMultiValueTermQuery((String)fieldName, values, (boolean)false);
        return this.makeChainQuery(issueKeyQuery);
    }

    @NotNull
    public List<LinkedJiraIssue> findJiraIssuesForBuildResults(@NotNull List<ResultsSummary> buildResults) {
        return this.resultsSummaryManager.findJiraIssuesForResults(buildResults);
    }

    @Deprecated
    @NotNull
    public List<LinkedJiraIssue> findJiraIssuesForBuild(@NotNull ImmutablePlan plan) {
        return this.findJiraIssuesForPlanKey(plan.getPlanKey());
    }

    @NotNull
    public List<LinkedJiraIssue> findJiraIssuesForPlanKey(@NotNull PlanKey planKey) {
        return this.resultsSummaryManager.findJiraIssuesForPlanKey(planKey);
    }

    public void setIndexedBuildResultsSearcher(IndexedBuildResultsSearcher indexedBuildResultsSearcher) {
        this.indexedBuildResultsSearcher = indexedBuildResultsSearcher;
    }

    public void setBuildResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

