/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.MutablePlanBranchPullRequest;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.branch.ChainBranchImpl;
import com.atlassian.bamboo.plan.pullrequest.MutableVcsPullRequest;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequestImpl;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="PLAN_BRANCH_PULL_REQUEST", uniqueConstraints={@UniqueConstraint(columnNames={"VCS_PULL_REQUEST_ID", "CHAIN_BRANCH_ID"}, name="PLAN_BRANCH_PR_UNQ")})
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class PlanBranchPullRequestEntity
implements MutablePlanBranchPullRequest {
    @Id
    @Column(name="PLAN_BRANCH_PULL_REQUEST_ID")
    @GeneratedValue(generator="ImportAwareGenerator")
    private long id;
    @ManyToOne(targetEntity=ChainBranchImpl.class)
    @JoinColumn(name="CHAIN_BRANCH_ID", nullable=false)
    private ChainBranch chainBranch;
    @ManyToOne(targetEntity=VcsPullRequestImpl.class)
    @JoinColumn(name="VCS_PULL_REQUEST_ID", nullable=false)
    private MutableVcsPullRequest vcsPullRequest;

    public PlanBranchPullRequestEntity() {
    }

    public PlanBranchPullRequestEntity(@NotNull ChainBranch chainBranch, @NotNull MutableVcsPullRequest vcsPullRequest) {
        this.chainBranch = chainBranch;
        this.vcsPullRequest = vcsPullRequest;
    }

    public PlanBranchPullRequestEntity(@NotNull MutablePlanBranchPullRequest planBranchPullRequest) {
        this(planBranchPullRequest.getChainBranch(), planBranchPullRequest.getVcsPullRequest());
        this.setId(planBranchPullRequest.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlanBranchPullRequestEntity)) {
            return false;
        }
        PlanBranchPullRequestEntity that = (PlanBranchPullRequestEntity)o;
        return this.getId() == that.getId() && Objects.equals(this.getChainBranch(), that.getChainBranch()) && Objects.equals(this.getVcsPullRequest(), that.getVcsPullRequest());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getChainBranch(), this.getVcsPullRequest());
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @NotNull
    public ChainBranch getChainBranch() {
        return this.chainBranch;
    }

    public void setChainBranch(@NotNull ChainBranch chainBranch) {
        this.chainBranch = chainBranch;
    }

    @NotNull
    public MutableVcsPullRequest getVcsPullRequest() {
        return this.vcsPullRequest;
    }

    public void setVcsPullRequest(@NotNull MutableVcsPullRequest vcsPullRequest) {
        this.vcsPullRequest = vcsPullRequest;
    }
}

