/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.MutablePlanBranchPullRequest;
import com.atlassian.bamboo.build.PlanBranchPullRequest;
import com.atlassian.bamboo.build.PlanBranchPullRequestDao;
import com.atlassian.bamboo.build.PlanBranchPullRequestImpl;
import com.atlassian.bamboo.build.PlanBranchPullRequestService;
import com.atlassian.bamboo.event.analytics.ChainBranchCreatedAnalyticsEvent;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.pullrequest.MutableVcsPullRequest;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequest;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequestDao;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequestImpl;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class PlanBranchPullRequestServiceImpl
implements PlanBranchPullRequestService {
    private final CachedPlanManager cachedPlanManager;
    private final EventPublisher eventPublisher;
    private final PlanBranchPullRequestDao planBranchPullRequestDao;
    private final PlanManager planManager;
    private final VcsPullRequestDao vcsPullRequestDao;

    @Inject
    public PlanBranchPullRequestServiceImpl(CachedPlanManager cachedPlanManager, EventPublisher eventPublisher, PlanBranchPullRequestDao planBranchPullRequestDao, PlanManager planManager, VcsPullRequestDao vcsPullRequestDao) {
        this.cachedPlanManager = cachedPlanManager;
        this.eventPublisher = eventPublisher;
        this.planBranchPullRequestDao = planBranchPullRequestDao;
        this.planManager = planManager;
        this.vcsPullRequestDao = vcsPullRequestDao;
    }

    @NotNull
    public Optional<PlanBranchPullRequest> findForChainBranch(long branchId) {
        return this.planBranchPullRequestDao.findForChainBranch(branchId).map(this::toImmutableEntity);
    }

    @NotNull
    public Optional<PlanBranchPullRequest> findForChainBranch(@NotNull PlanKey branchKey) {
        return this.planBranchPullRequestDao.findForChainBranch(branchKey).map(this::toImmutableEntity);
    }

    @NotNull
    public Optional<PlanBranchPullRequest> findForChainAndPullRequest(long chainId, long pullRequestId) {
        return this.planBranchPullRequestDao.findForChainAndPullRequest(chainId, pullRequestId).map(this::toImmutableEntity);
    }

    @NotNull
    public Optional<PlanBranchPullRequest> findForChainAndPullRequest(@NotNull PlanKey chainKey, long pullRequestId) {
        return this.planBranchPullRequestDao.findForChainAndPullRequest(chainKey, pullRequestId).map(this::toImmutableEntity);
    }

    @NotNull
    public List<PlanBranchPullRequest> findForPullRequest(long pullRequestId) {
        return this.planBranchPullRequestDao.findForPullRequest(pullRequestId).stream().map(this::toImmutableEntity).collect(Collectors.toList());
    }

    @NotNull
    public PlanBranchPullRequest create(@NotNull PlanKey branchKey, long pullRequestId) {
        ChainBranch chainBranch = (ChainBranch)this.planManager.getPlanByKeyIfOfType(branchKey, ChainBranch.class);
        Preconditions.checkArgument((chainBranch != null ? 1 : 0) != 0, (Object)String.format("Chain branch with key %s could not be found", branchKey));
        MutableVcsPullRequest vcsPullRequest = this.vcsPullRequestDao.findById(pullRequestId);
        Preconditions.checkArgument((vcsPullRequest != null ? 1 : 0) != 0, (Object)String.format("Pull request with ID %d could not be found", pullRequestId));
        return this.create(chainBranch, vcsPullRequest);
    }

    @NotNull
    public PlanBranchPullRequest create(@NotNull ChainBranch chainBranch, @NotNull MutableVcsPullRequest vcsPullRequest) {
        MutablePlanBranchPullRequest planBranchPullRequest = this.planBranchPullRequestDao.create(chainBranch, vcsPullRequest);
        this.eventPublisher.publish((Object)ChainBranchCreatedAnalyticsEvent.byPullRequestDetection());
        return new PlanBranchPullRequestImpl((PlanBranchPullRequest)planBranchPullRequest);
    }

    public boolean deleteForChainBranch(long branchId) {
        return this.planBranchPullRequestDao.deleteForChainBranch(branchId);
    }

    public boolean deleteForChainBranch(@NotNull PlanKey branchKey) {
        return this.planBranchPullRequestDao.deleteForChainBranch(branchKey);
    }

    public int deleteForVcsPullRequest(long pullRequestId) {
        return this.planBranchPullRequestDao.deleteForVcsPullRequest(pullRequestId);
    }

    @NotNull
    private PlanBranchPullRequest toImmutableEntity(@NotNull MutablePlanBranchPullRequest entity) {
        return new PlanBranchPullRequestImpl(entity.getId(), this.toImmutableEntity(entity.getChainBranch()), this.toImmutableEntity(entity.getVcsPullRequest()));
    }

    @NotNull
    private ImmutableChainBranch toImmutableEntity(@NotNull ChainBranch chainBranch) {
        ImmutableChainBranch immutableChainBranch = (ImmutableChainBranch)this.cachedPlanManager.getPlanByKeyIfOfType(chainBranch.getPlanKey(), ImmutableChainBranch.class);
        Preconditions.checkState((immutableChainBranch != null ? 1 : 0) != 0, (Object)("Plan branch with key " + chainBranch.getPlanKey() + " could not be found"));
        return immutableChainBranch;
    }

    @NotNull
    private VcsPullRequest toImmutableEntity(@NotNull MutableVcsPullRequest vcsPullRequest) {
        return new VcsPullRequestImpl((VcsPullRequest)vcsPullRequest);
    }
}

