/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.PlanDependency;
import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.plan.Plan;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="PLAN_DEPENDENCIES")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class PlanDependencyImpl
extends BambooEntityObject
implements PlanDependency,
Comparable<PlanDependencyImpl> {
    private static final Logger log = Logger.getLogger(PlanDependencyImpl.class);
    private Plan childPlan;
    private Plan parentPlan;
    private String dependencyType;

    public PlanDependencyImpl() {
    }

    public PlanDependencyImpl(Plan parentPlan, Plan childPlan) {
        this("atlassian.dependency.default", parentPlan, childPlan);
    }

    public PlanDependencyImpl(String dependencyType, Plan parentPlan, Plan childPlan) {
        this.dependencyType = dependencyType;
        this.childPlan = childPlan;
        this.parentPlan = parentPlan;
    }

    @Nullable
    public Plan getChildPlan() {
        return this.childPlan;
    }

    public void setChildPlan(Plan childPlan) {
        this.childPlan = childPlan;
    }

    @Nullable
    public Plan getParentPlan() {
        return this.parentPlan;
    }

    public void setParentPlan(Plan parentPlan) {
        this.parentPlan = parentPlan;
    }

    public boolean isEditable() {
        return "atlassian.dependency.default".equals(this.getDependencyType());
    }

    public String getDependencyType() {
        return this.dependencyType;
    }

    public void setDependencyType(String key) {
        this.dependencyType = key;
    }

    public int hashCode() {
        return new HashCodeBuilder(427, 23).append((Object)this.parentPlan).append((Object)this.childPlan).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PlanDependencyImpl)) {
            return false;
        }
        PlanDependencyImpl rhs = (PlanDependencyImpl)o;
        return new EqualsBuilder().append((Object)this.parentPlan, (Object)rhs.parentPlan).append((Object)this.childPlan, (Object)rhs.childPlan).isEquals();
    }

    @Override
    public int compareTo(PlanDependencyImpl o) {
        return new CompareToBuilder().append((Object)this.parentPlan, (Object)o.getParentPlan()).append((Object)this.childPlan, (Object)o.getChildPlan()).toComparison();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Plan Dependency parent: ");
        if (this.parentPlan != null) {
            builder.append(this.parentPlan.getKey());
        } else {
            builder.append("null");
        }
        builder.append(" child: ");
        if (this.childPlan != null) {
            builder.append(this.childPlan.getKey());
        } else {
            builder.append("null");
        }
        builder.append(" type:");
        builder.append(this.getDependencyType());
        return builder.toString();
    }
}

