/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.build.artifact.ArtifactHandler;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerConfigProvider;
import com.atlassian.bamboo.build.artifact.ArtifactHandlingUtils;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlersService;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plugin.InitablePluginModule;
import com.atlassian.bamboo.plugin.descriptor.ArtifactHandlerModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.ArtifactHandlerModuleDescriptorImpl;
import com.google.common.collect.Sets;
import io.atlassian.util.concurrent.Lazy;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractArtifactHandler
implements ArtifactHandler,
InitablePluginModule<ArtifactHandlerModuleDescriptor> {
    protected static final Set<AgentType> ALL_AGENT_TYPES = Sets.newHashSet((Object[])AgentType.values());
    protected static final Set<AgentType> LOCAL_AGENTS = Sets.newHashSet((Object[])new AgentType[]{AgentType.LOCAL});
    public static final Set<AgentType> NON_LOCAL_AGENTS = Sets.difference(ALL_AGENT_TYPES, LOCAL_AGENTS);
    private final Set<AgentType> supportedAgents;
    private ArtifactHandlerModuleDescriptor moduleDescriptor;

    public AbstractArtifactHandler(Set<AgentType> supportedAgents) {
        this.supportedAgents = supportedAgents;
    }

    public void init(@NotNull ArtifactHandlerModuleDescriptor moduleDescriptor) {
        this.moduleDescriptor = moduleDescriptor;
    }

    public boolean canHandleArtifact(ArtifactDefinitionContext artifact, Map<String, String> artifactHandlersConfiguration) {
        return BooleanUtils.toBoolean((String)this.getConfigValue(artifactHandlersConfiguration, ArtifactHandlerModuleDescriptorImpl.SHARED_NON_SHARED_ONOFF_OPTION_NAME.get(artifact.isSharedArtifact())));
    }

    @NotNull
    public Map<String, String> getDefaultConfiguration() {
        return ArtifactHandlerModuleDescriptorImpl.SHARED_NON_SHARED_ONOFF_OPTION_NAME.values().stream().collect(Collectors.toMap(this::getConfigurationKey, o -> Boolean.TRUE.toString()));
    }

    @Nullable
    protected String getConfigValue(Map<String, String> artifactHandlersConfiguration, String key) {
        boolean isGlobalConfigUsed;
        String configurationKey = this.getConfigurationKey(key);
        String value = artifactHandlersConfiguration.get(configurationKey);
        if (value != null) {
            return value;
        }
        boolean bl = isGlobalConfigUsed = !ArtifactHandlingUtils.isCustomArtifactHandlingConfigured(artifactHandlersConfiguration);
        if (isGlobalConfigUsed && ArtifactHandlingUtils.isDefaultArtifactHandler(this.moduleDescriptor.getCompleteKey())) {
            return MapUtils.getString(this.getDefaultConfiguration(), (Object)configurationKey);
        }
        return null;
    }

    protected String getConfigurationKey(String key) {
        return ArtifactHandlingUtils.getConfigKey(this.moduleDescriptor.getConfigurationPrefix(), key);
    }

    @NotNull
    public Set<AgentType> getSupportedAgents() {
        return this.supportedAgents;
    }

    @NotNull
    public ArtifactHandlerModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @NotNull
    public static ArtifactHandlerConfigProvider configProvider(@NotNull Map<String, String> artifactHandlerConfiguration) {
        return AbstractArtifactHandler.configProvider(() -> artifactHandlerConfiguration);
    }

    @NotNull
    public static ArtifactHandlerConfigProvider configProvider(@NotNull ArtifactHandlersService artifactHandlersService) {
        return AbstractArtifactHandler.configProvider(Lazy.supplier(() -> ((ArtifactHandlersService)artifactHandlersService).getRuntimeConfiguration()));
    }

    @NotNull
    private static ArtifactHandlerConfigProvider configProvider(@NotNull Supplier<Map<String, String>> artifactHandlerConfigurationSupplier) {
        return artifactHandlerConfigurationSupplier::get;
    }

    public long getMaxUnarchivedFilesPerArtifact(@NotNull Map<String, String> artifactHandlersConfiguration) {
        return Long.MAX_VALUE;
    }
}

