/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.AgentTypeHolder;
import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.build.ErrorLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.artifact.AbstractArtifactHandler;
import com.atlassian.bamboo.build.artifact.ArtifactHandler;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerConfigProvider;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerDecoratorSupport;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerPublishingResult;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerPublishingResultImpl;
import com.atlassian.bamboo.build.artifact.ArtifactHandlingUtils;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.build.artifact.ArtifactPublishingConfig;
import com.atlassian.bamboo.build.artifact.ArtifactRetrievalConfig;
import com.atlassian.bamboo.build.artifact.ArtifactRetrievalStatus;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlerPackagingDecorator;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlerSupportsAgentTypeModuleDescriptorPredicate;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlersService;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.DisconnectedBuildLogger;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactContext;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactPublishingResult;
import com.atlassian.bamboo.plan.artifact.ArtifactPublishingResultImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionContextImpl;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.descriptor.predicate.ConjunctionModuleDescriptorPredicate;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.security.SecureToken;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import com.atlassian.plugin.predicate.ModuleOfClassPredicate;
import com.google.common.base.Stopwatch;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractArtifactManager
implements ArtifactManager {
    private static final Logger log = Logger.getLogger(AbstractArtifactManager.class);
    public static final String ARTIFACT_SECURITY_TOKEN = "ARTIFACT_SECURITY_TOKEN";
    private static final String SERVER_LOCAL_ART_HANDLER_KEY = "com.atlassian.bamboo.plugin.artifact.handler.local:ServerLocalArtifactHandler";
    private static final String REMOTE_ART_HANDLER_KEY = "com.atlassian.bamboo.plugin.artifact.handler.remote:BambooRemoteArtifactHandler";
    @Autowired(required=false)
    private ArtifactHandlersService artifactHandlersService;
    @Inject
    private PluginAccessor pluginAccessor;
    @Inject
    private CustomVariableContext customVariableContext;

    public ArtifactPublishingResult publish(@Nullable BuildLogger buildLogger, @NotNull PlanResultKey planResultKey, @NotNull File baseDirectory, @NotNull ArtifactDefinitionContext artifact, @NotNull Map<String, String> artifactHandlerConfiguration, int minExpectedFilesCnt) {
        FileSet sourceFileSet;
        if (buildLogger == null) {
            buildLogger = new DisconnectedBuildLogger();
        }
        boolean useRelativeLocation = true;
        try {
            sourceFileSet = ArtifactHandlingUtils.createFileSet(baseDirectory, artifact, true, log);
        }
        catch (FileNotFoundException e) {
            String failureReason = "the source directory " + ArtifactHandlingUtils.getArtifactLocation(baseDirectory, artifact, true) + " does not exist.";
            return this.loggedPublishingFailure(buildLogger, artifact, null, null, failureReason);
        }
        String matchDescription = ArtifactHandlingUtils.getArtifactMatchDescription(artifact, sourceFileSet);
        this.logPublishAttempt(planResultKey, artifact, minExpectedFilesCnt, sourceFileSet, matchDescription);
        return this.publishFileSet(planResultKey, artifact, sourceFileSet, artifactHandlerConfiguration, buildLogger);
    }

    private void logPublishAttempt(PlanResultKey planResultKey, ArtifactDefinitionContext artifact, int minExpectedFilesCnt, FileSet sourceFileSet, String matchDescription) {
        Level priority;
        String msg;
        int filesAvailableForTransfer = sourceFileSet.size();
        if (filesAvailableForTransfer == 0 || filesAvailableForTransfer < minExpectedFilesCnt) {
            msg = filesAvailableForTransfer == 0 ? "no files matching" : filesAvailableForTransfer + " file(s) matching, expected " + minExpectedFilesCnt;
            priority = filesAvailableForTransfer < minExpectedFilesCnt ? Level.WARN : Level.INFO;
        } else {
            msg = filesAvailableForTransfer + " file(s) matching";
            priority = Level.INFO;
        }
        log.log((Priority)priority, (Object)("Publishing [" + artifact.getName() + "] for " + planResultKey + ": " + msg + " " + matchDescription));
    }

    public final ErrorCollection validateArtifactsSize(@NotNull File baseDirectory, @NotNull ArtifactContext artifactContext) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        long artifactTotalSize = 0L;
        if (artifactContext.getArtifactSizeQuota().isDefined()) {
            long artifactQuota = (Long)artifactContext.getArtifactSizeQuota().get();
            for (ArtifactDefinitionContext artifact : artifactContext.getDefinitionContexts()) {
                try {
                    FileSet sourceFileSet = ArtifactHandlingUtils.createFileSet(baseDirectory, artifact, true, log);
                    artifactTotalSize += this.getTotalArtifactSize(baseDirectory, sourceFileSet);
                }
                catch (FileNotFoundException e) {
                    log.info((Object)String.format("Couldn't create fileset for artifact %s", artifact), (Throwable)e);
                }
            }
            if (artifactTotalSize > artifactQuota) {
                errorCollection.addErrorMessage("Unable to publish artifacts. Total artifact size for build [" + FileUtils.byteCountToDisplaySize((long)artifactTotalSize) + "] exceeded limit [" + FileUtils.byteCountToDisplaySize((long)artifactQuota) + "]. Artifacts were not copied to the server.");
            }
        }
        return errorCollection;
    }

    private void logPublishingFailure(@Nullable BuildLogger buildLogger, ArtifactPublishingResultImpl result) {
        String msg = "Unable to publish artifact [" + result.getArtifactDefinitionContext().getName() + "]: " + result.getFailureReason();
        buildLogger.addErrorLogEntry(msg);
        if (result.shouldContinueBuild()) {
            log.warn((Object)msg);
        } else {
            log.error((Object)msg);
            String errorMessage = result.getArtifactDefinitionContext().isRequired() ? "The artifact is required, build will now fail." : "The artifact is required for down stream Stages and Jobs, build will now fail.";
            log.error((Object)buildLogger.addErrorLogEntry(errorMessage));
        }
    }

    protected ArtifactPublishingResult publishFileSet(final PlanResultKey planResultKey, final ArtifactDefinitionContext artifact, FileSet sourceFileSet, Map<String, String> artifactHandlersConfiguration, final BuildLogger buildLogger) {
        Iterable<ArtifactHandler> artifactHandlers = this.getArtifactHandlers(artifact, artifactHandlersConfiguration);
        if (Iterables.isEmpty(artifactHandlers)) {
            return this.loggedPublishingFailure(buildLogger, artifact, null, null, "No artifact handler found.");
        }
        final ArtifactPublishingConfig artifactPublishingConfig = new ArtifactPublishingConfig(sourceFileSet, artifactHandlersConfiguration);
        boolean allPublished = true;
        final StringBuilder failureReason = new StringBuilder();
        HashSet<ArtifactHandlerPublishingResult> succesfulResults = new HashSet<ArtifactHandlerPublishingResult>();
        HashSet<ArtifactHandlerPublishingResult> failedResults = new HashSet<ArtifactHandlerPublishingResult>();
        for (final ArtifactHandler artifactHandler : artifactHandlers) {
            HashSet<ArtifactHandlerPublishingResult> publishingResults;
            ArtifactHandlerDecoratorSupport artifactHandlerDecoratorSupport = (ArtifactHandlerDecoratorSupport)Narrow.downTo((Object)artifactHandler, ArtifactHandlerDecoratorSupport.class);
            final Class<?> handlerClass = artifactHandlerDecoratorSupport != null ? artifactHandlerDecoratorSupport.delegate().getClass() : artifactHandler.getClass();
            Stopwatch stopwatch = Stopwatch.createStarted();
            log.info((Object)("Trying to publish the artifact with handler: " + handlerClass.getCanonicalName()));
            final String errorMessage = "Unable to publish artifact " + artifact + " for " + planResultKey + " via " + artifactHandler;
            ArtifactHandlerPublishingResult publishingResult = BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.NoThrowCallable<ArtifactHandlerPublishingResult>(errorMessage){

                @Override
                @NotNull
                public ArtifactHandlerPublishingResult call() {
                    try {
                        return artifactHandler.publish(planResultKey, artifact, artifactPublishingConfig);
                    }
                    catch (Exception e) {
                        log.warn((Object)e.getMessage(), (Throwable)e);
                        if (buildLogger != null) {
                            buildLogger.addErrorLogEntry((LogEntry)new ErrorLogEntry(handlerClass.getCanonicalName() + ": " + e.getMessage()));
                        }
                        failureReason.append(errorMessage).append(" ");
                        return ArtifactHandlerPublishingResultImpl.failure();
                    }
                }
            });
            if (publishingResult == null) continue;
            publishingResult.setArtifactHandlerKey(artifactHandler.getModuleDescriptor().getCompleteKey());
            if (publishingResult.isSuccessful()) {
                publishingResults = succesfulResults;
                Long totalUploadedSize = publishingResult.getTotalUploadedSize();
                String totalUploadedSizeString = totalUploadedSize == null ? "unknown" : FileUtils.byteCountToDisplaySize((long)totalUploadedSize);
                log.info((Object)("Handler " + handlerClass.getCanonicalName() + " published the artifact, size: " + totalUploadedSizeString + ", time elapsed: " + stopwatch));
            } else {
                allPublished = false;
                publishingResults = failedResults;
                log.info((Object)("Handler " + handlerClass.getCanonicalName() + " did not publish the artifact"));
            }
            publishingResults.add(publishingResult);
        }
        if (allPublished) {
            return ArtifactPublishingResultImpl.success(artifact, succesfulResults);
        }
        return this.loggedPublishingFailure(buildLogger, artifact, succesfulResults, failedResults, failureReason.toString());
    }

    private ArtifactPublishingResult loggedPublishingFailure(@Nullable BuildLogger buildLogger, ArtifactDefinitionContext artifact, Set<ArtifactHandlerPublishingResult> successfulPublishers, Set<ArtifactHandlerPublishingResult> failedPublishers, String failureReason) {
        ArtifactPublishingResultImpl result = ArtifactPublishingResultImpl.failure(artifact, failureReason, successfulPublishers, failedPublishers);
        this.logPublishingFailure(buildLogger, result);
        return result;
    }

    public boolean retrieve(@Nullable BuildLogger buildLogger, @NotNull PlanResultKey planResultKey, @NotNull ArtifactSubscriptionContext artifactSubscription, @NotNull Map<String, String> artifactHandlersConfiguration, @NotNull File buildWorkingDirectory, @NotNull Multimap<String, Artifact> availableArtifacts) {
        artifactSubscription.substituteVariables(this.customVariableContext);
        Collection matchingArtifacts = availableArtifacts.get((Object)artifactSubscription.getArtifactDefinitionContext().getName());
        ArtifactRetrievalStatus retrievalStatus = this.retrieveArtifact(buildLogger, planResultKey, (ResultKey)planResultKey, matchingArtifacts, artifactSubscription, artifactHandlersConfiguration, buildWorkingDirectory);
        if (retrievalStatus.isRetrieved()) {
            this.markSubscriptionAsConsumed(planResultKey, artifactSubscription, retrievalStatus.getLinkType());
            retrievalStatus.setRetrievalInfo(artifactSubscription);
        }
        return retrievalStatus.isRetrieved();
    }

    public boolean retrieve(@Nullable BuildLogger buildLogger, @NotNull PlanResultKey planResultKey, @NotNull ResultKey resultKey, @NotNull ArtifactDefinitionContext artifactDefinitionContext, @NotNull String destinationPath, @NotNull Map<String, String> artifactHandlersConfiguration, @NotNull File buildWorkingDirectory, @NotNull Multimap<String, Artifact> availableArtifacts) {
        artifactDefinitionContext.substituteVariables(this.customVariableContext);
        ArtifactSubscriptionContextImpl subscriptionContext = new ArtifactSubscriptionContextImpl(artifactDefinitionContext, destinationPath, SecureToken.createFromString((String)artifactHandlersConfiguration.get(ARTIFACT_SECURITY_TOKEN)), "");
        ArtifactRetrievalStatus retrievalStatus = this.retrieveArtifact(buildLogger, planResultKey, resultKey, availableArtifacts.get((Object)artifactDefinitionContext.getName()), subscriptionContext, artifactHandlersConfiguration, buildWorkingDirectory);
        return retrievalStatus.isRetrieved();
    }

    private ArtifactRetrievalStatus retrieveArtifact(final BuildLogger buildLogger, PlanResultKey sourceResultKey, final ResultKey resultKey, Collection<Artifact> matchingArtifacts, final ArtifactSubscriptionContext artifactSubscriptionContext, Map<String, String> artifactHandlersConfiguration, File buildWorkingDirectory) {
        final ArtifactRetrievalConfig artifactRetrievalConfig = new ArtifactRetrievalConfig(buildWorkingDirectory, artifactHandlersConfiguration);
        ArtifactDefinitionContext artifactDefinitionContext = artifactSubscriptionContext.getArtifactDefinitionContext();
        Iterable<ArtifactHandler> artifactHandlers = this.getArtifactHandlers(artifactDefinitionContext, artifactHandlersConfiguration);
        ArtifactRetrievalStatus retrievalStatus = ArtifactRetrievalStatus.UNABLE;
        for (final ArtifactHandler artifactHandler : artifactHandlers) {
            final Artifact artifact = this.findMatchingArtifact(artifactHandler.getModuleDescriptor().getCompleteKey(), matchingArtifacts);
            final String errorMessage = "Unable to retrieve artifact " + artifactDefinitionContext.getName() + " for " + sourceResultKey + " via " + artifactHandler;
            if (artifact == null) {
                log.info((Object)(errorMessage + " No matching Artifact found."));
                continue;
            }
            ArtifactRetrievalStatus retrievalStatusOrNull = BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.NoThrowCallable<ArtifactRetrievalStatus>(errorMessage){

                @Override
                public ArtifactRetrievalStatus call() {
                    try {
                        return artifactHandler.retrieve(resultKey, artifact, artifactSubscriptionContext, artifactRetrievalConfig);
                    }
                    catch (Exception e) {
                        if (buildLogger != null) {
                            buildLogger.addErrorLogEntry((LogEntry)new ErrorLogEntry(e.getMessage()));
                        }
                        log.warn((Object)errorMessage, (Throwable)e);
                        return ArtifactRetrievalStatus.UNABLE;
                    }
                }
            });
            retrievalStatus = (ArtifactRetrievalStatus)ObjectUtils.defaultIfNull((Object)retrievalStatusOrNull, (Object)ArtifactRetrievalStatus.UNABLE);
            if (!retrievalStatus.isRetrieved()) continue;
            break;
        }
        return retrievalStatus;
    }

    @Nullable
    protected Artifact findMatchingArtifact(String artifactHandlerKey, Collection<Artifact> matchingArtifacts) {
        boolean isServerStoringArtHandler = artifactHandlerKey.equals(SERVER_LOCAL_ART_HANDLER_KEY) || artifactHandlerKey.equals(REMOTE_ART_HANDLER_KEY);
        for (Artifact artifact : matchingArtifacts) {
            if (artifact.getLinkType().equals(artifactHandlerKey)) {
                return artifact;
            }
            if ((!isServerStoringArtHandler || !artifact.getLinkType().equals(REMOTE_ART_HANDLER_KEY)) && !artifact.getLinkType().equals(SERVER_LOCAL_ART_HANDLER_KEY)) continue;
            return artifact;
        }
        return null;
    }

    protected abstract void markSubscriptionAsConsumed(PlanResultKey var1, ArtifactSubscriptionContext var2, String var3);

    protected Iterable<ArtifactHandler> getArtifactHandlers(ArtifactDefinitionContext artifact, Map<String, String> artifactHandlersConfiguration) {
        Iterable handlersToRun = Iterables.filter(this.getArtifactHandlersForAgent(AgentTypeHolder.get()), artifactHandler -> artifactHandler.canHandleArtifact(artifact, artifactHandlersConfiguration));
        Iterable handlersWithPackaging = Iterables.transform((Iterable)handlersToRun, ArtifactHandlerPackagingDecorator.addFilePackaging());
        return ArtifactHandlingUtils.fastestFirstOrdering(artifactHandlersConfiguration).sortedCopy(handlersWithPackaging);
    }

    private long getTotalArtifactSize(File baseDirectory, @NotNull FileSet sourceFileSet) {
        DirectoryScanner scanner = sourceFileSet.getDirectoryScanner();
        String[] files = scanner.getIncludedFiles();
        long filesetSize = 0L;
        for (String fileName : files) {
            File file = new File(baseDirectory, fileName);
            filesetSize += file.length();
        }
        log.debug((Object)("Total calculated size of artifact: " + filesetSize));
        return filesetSize;
    }

    public void removeArtifactsFromStorage(@NotNull Iterable<ArtifactLink> artifactLinks) {
        Map<PlanResultKey, Set<String>> allUsedLinkTypes = this.getAllUsedLinkTypes(artifactLinks);
        final ArtifactHandlerConfigProvider artifactHandlerConfigProvider = this.artifactHandlerConfigurationProvider();
        for (Map.Entry<PlanResultKey, Set<String>> linkTypesForPlanResult : allUsedLinkTypes.entrySet()) {
            final PlanResultKey planResultKey = linkTypesForPlanResult.getKey();
            for (final String linkType : linkTypesForPlanResult.getValue()) {
                String errorMessage = linkType + " was unable to delete artifacts for " + planResultKey;
                BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.Runnable(errorMessage){

                    @Override
                    public void run() {
                        ArtifactHandler artifactHandler = ArtifactHandlingUtils.getArtifactHandlerForLink(AbstractArtifactManager.this.pluginAccessor, linkType);
                        artifactHandler.removeArtifactsFromStorage(planResultKey, artifactHandlerConfigProvider);
                    }
                });
            }
        }
    }

    private Map<PlanResultKey, Set<String>> getAllUsedLinkTypes(Iterable<ArtifactLink> artifactLinks) {
        LoadingCache linkTypes = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<PlanResultKey, Set<String>>(){

            public Set<String> load(@NotNull PlanResultKey key) {
                return new HashSet<String>();
            }
        });
        for (ArtifactLink artifactLink : artifactLinks) {
            ResultsSummary resultsSummary = artifactLink.getBuildResultsSummary();
            if (resultsSummary == null) continue;
            ((Set)linkTypes.getUnchecked((Object)resultsSummary.getPlanResultKey())).add(artifactLink.getArtifact().getLinkType());
        }
        return linkTypes.asMap();
    }

    public void removeArtifactsFromStorage(final @NotNull PlanKey planKey) {
        List<ArtifactHandler> enabledAndUsableOnAgent = this.getArtifactHandlersForAgent(AgentTypeHolder.get());
        final ArtifactHandlerConfigProvider artifactHandlerConfigProvider = this.artifactHandlerConfigurationProvider();
        for (final ArtifactHandler artifactHandler : enabledAndUsableOnAgent) {
            String errorMessage = artifactHandler.getClass() + " was unable to delete artifacts for " + planKey;
            BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.Runnable(errorMessage){

                @Override
                public void run() {
                    artifactHandler.removeArtifactsFromStorage(planKey, artifactHandlerConfigProvider);
                }
            });
        }
    }

    public void removeArtifactFromStorage(final @NotNull Artifact artifact) {
        final ArtifactHandlerConfigProvider artifactHandlerConfigProvider = this.artifactHandlerConfigurationProvider();
        String errorMessage = artifact.getLinkType() + " was unable to delete artifacts " + artifact.getLabel() + " (from " + artifact.getPlanResultKey() + ")";
        BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.Runnable(errorMessage){

            @Override
            public void run() {
                ArtifactHandler artifactHandler = ArtifactHandlingUtils.getArtifactHandlerForLink(AbstractArtifactManager.this.pluginAccessor, artifact.getLinkType());
                artifactHandler.removeArtifactFromStorage(artifact, artifactHandlerConfigProvider);
            }
        });
    }

    public void moveArtifactToGlobalStorage(@NotNull Artifact artifact) throws IOException {
        ArtifactHandlerConfigProvider artifactHandlerConfigProvider = this.artifactHandlerConfigurationProvider();
        ArtifactHandler artifactHandler = ArtifactHandlingUtils.getArtifactHandlerForLink(this.pluginAccessor, artifact.getLinkType());
        try {
            artifactHandler.moveArtifactToGlobalStorage(artifact, artifactHandlerConfigProvider);
        }
        catch (IOException e) {
            String errorMessage = artifact.getLinkType() + " was unable to move artifacts " + artifact.getLabel() + " (from " + artifact.getPlanResultKey() + ')';
            throw new IOException(errorMessage, e);
        }
    }

    public boolean removeOrphanedArtifacts() {
        return false;
    }

    public boolean removeArtifactsIfOrphaned(@NotNull List<Long> artifactIds) {
        return false;
    }

    @NotNull
    public List<ArtifactHandler> getArtifactHandlersForAgent(@NotNull AgentType agentType) {
        ConjunctionModuleDescriptorPredicate<ArtifactHandler> predicate = new ConjunctionModuleDescriptorPredicate<ArtifactHandler>();
        predicate.append((ModuleDescriptorPredicate<ArtifactHandler>)new ModuleOfClassPredicate(ArtifactHandler.class));
        predicate.append((ModuleDescriptorPredicate<ArtifactHandler>)new EnabledModulePredicate());
        predicate.append(new ArtifactHandlerSupportsAgentTypeModuleDescriptorPredicate(agentType));
        return ImmutableList.copyOf((Collection)this.pluginAccessor.getModules(predicate));
    }

    private ArtifactHandlerConfigProvider artifactHandlerConfigurationProvider() {
        return AbstractArtifactHandler.configProvider(this.artifactHandlersService);
    }
}

