/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.artifact.ArtifactImpl;
import com.atlassian.bamboo.build.artifact.AbstractArtifactHandler;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerConfigProvider;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerPublishingResult;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerPublishingResultImpl;
import com.atlassian.bamboo.build.artifact.ArtifactHandlingUtils;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkDataProvider;
import com.atlassian.bamboo.build.artifact.ArtifactPublishingConfig;
import com.atlassian.bamboo.build.artifact.ArtifactRetrievalConfig;
import com.atlassian.bamboo.build.artifact.ArtifactRetrievalStatus;
import com.atlassian.bamboo.build.artifact.FileSystemArtifactLinkDataProvider;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionContext;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinitionBase;
import com.atlassian.bamboo.storage.ArtifactDirectoryBuilder;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.utils.Pair;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.resources.FileResource;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLocalArtifactHandler
extends AbstractArtifactHandler {
    private static final Logger log = Logger.getLogger(AbstractLocalArtifactHandler.class);
    private static final Pair<Integer, Long> EMPTY_DIR = Pair.make((Object)0, (Object)0L);

    public AbstractLocalArtifactHandler(Set<AgentType> supportedAgents) {
        super(supportedAgents);
    }

    @NotNull
    public ArtifactHandlerPublishingResult publish(@NotNull PlanResultKey planResultKey, @NotNull ArtifactDefinitionContext artifact, @NotNull ArtifactPublishingConfig artifactPublishingConfig) throws IOException {
        File artifactStorageDirectory = this.getArtifactStorageDirectory(planResultKey, artifact, (ArtifactHandlerConfigProvider)artifactPublishingConfig);
        boolean isDirCreated = artifactStorageDirectory.mkdirs();
        if (!isDirCreated && !artifactStorageDirectory.isDirectory()) {
            log.error((Object)("Unable to create " + artifactStorageDirectory));
            return ArtifactHandlerPublishingResultImpl.failure();
        }
        ArtifactHandlingUtils.copyFileSet(artifactPublishingConfig.getSourceFileSet(), artifactStorageDirectory);
        return ArtifactHandlerPublishingResultImpl.fromSuccessFlag(artifactStorageDirectory.list().length != 0, this.getStats(artifactStorageDirectory));
    }

    @NotNull
    public ArtifactRetrievalStatus retrieve(@NotNull ResultKey clientKey, @NotNull Artifact artifact, @NotNull ArtifactSubscriptionContext artifactSubscription, @NotNull ArtifactRetrievalConfig artifactRetrievalConfig) throws IOException {
        File artifactStorageDirectory = this.getArtifactStorageDirectory(artifact, (ArtifactHandlerConfigProvider)artifactRetrievalConfig);
        return this.internalRetrieve(artifactStorageDirectory, artifactSubscription, artifactRetrievalConfig);
    }

    private ArtifactRetrievalStatus internalRetrieve(File artifactStorageDirectory, ArtifactSubscriptionContext artifactSubscription, ArtifactRetrievalConfig artifactRetrievalConfig) throws IOException {
        boolean singleFile;
        FileSet sourceFileSet = ArtifactHandlingUtils.createFileSet(artifactStorageDirectory, artifactSubscription.getArtifactDefinitionContext(), false, log);
        Path destinationLocation = ArtifactHandlingUtils.resolveArtifactLocation(artifactRetrievalConfig.getBaseDestinationPath().toPath(), artifactSubscription.getDestinationPath());
        ArtifactHandlingUtils.copyFileSet(sourceFileSet, destinationLocation.toFile());
        Iterator iterator = sourceFileSet.iterator();
        if (!iterator.hasNext()) {
            return ArtifactRetrievalStatus.UNABLE;
        }
        FileResource firstFile = (FileResource)iterator.next();
        boolean bl = singleFile = !iterator.hasNext();
        if (singleFile) {
            return ArtifactRetrievalStatus.singleFile((File)new File(destinationLocation.toFile(), firstFile.getName()), (String)this.getModuleDescriptor().getCompleteKey());
        }
        return ArtifactRetrievalStatus.multipleFiles((Path)destinationLocation, (String)this.getModuleDescriptor().getCompleteKey());
    }

    protected File getArtifactStorageDirectory(PlanResultKey planResultKey, ArtifactDefinitionContext artifact, ArtifactHandlerConfigProvider artifactHandlerConfigProvider) {
        return this.getArtifactDirectoryBuilder(artifactHandlerConfigProvider).getPlanOrientedArtifactDirectory(planResultKey, (ImmutableArtifactDefinitionBase)artifact);
    }

    protected File getArtifactStorageDirectory(Artifact artifact, ArtifactHandlerConfigProvider artifactHandlerConfigProvider) {
        return this.getArtifactDirectoryBuilder(artifactHandlerConfigProvider).getArtifactDirectory(artifact);
    }

    protected abstract ArtifactDirectoryBuilder getArtifactDirectoryBuilder(ArtifactHandlerConfigProvider var1);

    public int getSpeed(@NotNull Map<String, String> artifactHandlersConfiguration) {
        return 20000;
    }

    public void removeArtifactFromStorage(@NotNull Artifact artifact, @NotNull ArtifactHandlerConfigProvider artifactHandlerConfigProvider) {
        ArtifactDirectoryBuilder artifactDirectoryBuilder = this.getArtifactDirectoryBuilder(artifactHandlerConfigProvider);
        AbstractLocalArtifactHandler.removeArtifactsFromStorage(artifactDirectoryBuilder.getArtifactDirectory(artifact));
    }

    public void removeArtifactFromStorage(@NotNull PlanResultKey planResultKey, @NotNull ImmutableArtifactDefinitionBase artifact, @NotNull ArtifactHandlerConfigProvider artifactHandlerConfigProvider) {
        ArtifactDirectoryBuilder artifactDirectoryBuilder = this.getArtifactDirectoryBuilder(artifactHandlerConfigProvider);
        AbstractLocalArtifactHandler.removeArtifactsFromStorage(artifactDirectoryBuilder.getPlanOrientedArtifactDirectory(planResultKey, artifact));
    }

    public void removeArtifactsFromStorage(@NotNull PlanResultKey planResultKey, @NotNull ArtifactHandlerConfigProvider artifactHandlerConfigProvider) {
        ArtifactDirectoryBuilder artifactDirectoryBuilder = this.getArtifactDirectoryBuilder(artifactHandlerConfigProvider);
        AbstractLocalArtifactHandler.removeArtifactsFromStorage(artifactDirectoryBuilder.getBuildDirectory(planResultKey));
    }

    public void removeArtifactsFromStorage(@NotNull PlanKey planKey, @NotNull ArtifactHandlerConfigProvider artifactHandlerConfigProvider) {
        ArtifactDirectoryBuilder artifactDirectoryBuilder = this.getArtifactDirectoryBuilder(artifactHandlerConfigProvider);
        AbstractLocalArtifactHandler.removeArtifactsFromStorage(artifactDirectoryBuilder.getJobOrSharedDirectory(planKey));
        if (!PlanKeys.isJobKey((PlanKey)planKey)) {
            AbstractLocalArtifactHandler.removeArtifactsFromStorage(new File(artifactDirectoryBuilder.getRootDirectory(), planKey.toString()));
        }
    }

    public boolean moveArtifactToGlobalStorage(@NotNull Artifact artifact, @NotNull ArtifactHandlerConfigProvider artifactHandlerConfigProvider) {
        if (artifact.isGloballyStored()) {
            return true;
        }
        ArtifactDirectoryBuilder artifactDirectoryBuilder = this.getArtifactDirectoryBuilder(artifactHandlerConfigProvider);
        File oldDirectory = artifactDirectoryBuilder.getArtifactDirectory(artifact);
        if (!oldDirectory.isDirectory()) {
            return true;
        }
        ArtifactImpl globallyStoredArtifact = ArtifactImpl.globallyStoredCopyOf(artifact);
        File newDirectory = artifactDirectoryBuilder.getArtifactDirectory((Artifact)globallyStoredArtifact);
        try {
            FileUtils.moveDirectory((File)oldDirectory, (File)newDirectory);
        }
        catch (IOException e) {
            log.error((Object)"Error during move", (Throwable)e);
            return false;
        }
        return true;
    }

    private static void removeArtifactsFromStorage(File planResultArtifactDirectory) {
        try {
            BambooFileUtils.deleteDirectory(planResultArtifactDirectory);
        }
        catch (IOException e) {
            log.error((Object)("Failed to remove artifacts from " + planResultArtifactDirectory + ". There may be serious issues with the file system."), (Throwable)e);
        }
    }

    public ArtifactLinkDataProvider getArtifactLinkDataProvider(ArtifactLink artifactLink, @NotNull ArtifactHandlerConfigProvider artifactHandlerConfigProvider) {
        try {
            return new FileSystemArtifactLinkDataProvider(this.getArtifactDirectoryBuilder(artifactHandlerConfigProvider), (Artifact)artifactLink.getArtifact());
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public ArtifactLinkDataProvider getArtifactLinkDataProvider(Artifact artifact, @NotNull ArtifactHandlerConfigProvider artifactHandlerConfigProvider) {
        try {
            return new FileSystemArtifactLinkDataProvider(this.getArtifactDirectoryBuilder(artifactHandlerConfigProvider), artifact);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @NotNull
    private Supplier<Pair<Integer, Long>> getStats(File artifactRoot) {
        File[] filesInRoot = artifactRoot.listFiles();
        if (filesInRoot == null) {
            return () -> Pair.make(null, null);
        }
        switch (filesInRoot.length) {
            case 0: {
                return () -> EMPTY_DIR;
            }
            case 1: {
                File file = filesInRoot[0];
                if (!file.isFile()) break;
                return () -> Pair.make((Object)1, (Object)file.length());
            }
        }
        return () -> Pair.make((Object)filesInRoot.length, (Object)FileUtils.sizeOfDirectory((File)artifactRoot));
    }
}

