/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlersService;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.configuration.MiscellaneousPlanConfigurationPlugin;
import com.atlassian.bamboo.plugin.descriptor.ArtifactHandlerModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.MiscellaneousBuildConfigurationModuleDescriptor;
import com.atlassian.bamboo.v2.build.BaseConfigurablePlugin;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactHandlerForPlanConfigurator
extends BaseConfigurablePlugin
implements MiscellaneousPlanConfigurationPlugin {
    @Inject
    private ArtifactHandlersService artifactHandlersService;

    public boolean isApplicableTo(@NotNull ImmutablePlan plan) {
        return PlanClassHelper.isChain((ImmutablePlan)plan);
    }

    @Override
    public String getEditHtml(@NotNull BuildConfiguration buildConfiguration, @Nullable Plan plan) {
        return this.getEditHtml();
    }

    @Nullable
    public String getEditHtml() {
        List<ArtifactHandlerModuleDescriptor> handlers = this.getArtifactHandlerDescriptors();
        ImmutableMap.Builder params = ImmutableMap.builder().put((Object)"artifactHandlerDescriptors", handlers).put((Object)"configurationPrefix", (Object)"custom.artifactHandlers.");
        Map artifactHandlersConfiguration = this.artifactHandlersService.getConfiguration();
        handlers.forEach(h -> params.put((Object)(h.getConfigurationPrefix() + ":configurationComplete"), (Object)h.getConfigurator().isConfigurationComplete(artifactHandlersConfiguration)));
        return this.templateRenderer.render(this.getModuleDescriptor().getEditTemplate(), (Map)params.build());
    }

    private List<ArtifactHandlerModuleDescriptor> getArtifactHandlerDescriptors() {
        return this.artifactHandlersService.getArtifactHandlerModuleDescriptors();
    }

    public MiscellaneousBuildConfigurationModuleDescriptor getModuleDescriptor() {
        return (MiscellaneousBuildConfigurationModuleDescriptor)this.moduleDescriptor;
    }

    @NotNull
    public Set<String> getConfigurationKeys() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        result.add((Object)"custom.artifactHandlers.useCustomArtifactHandlers");
        this.getArtifactHandlerDescriptors().forEach(descriptor -> {
            result.add((Object)(descriptor.getConfigurationPrefix() + ":enabledForShared"));
            result.add((Object)(descriptor.getConfigurationPrefix() + ":enabledForNonShared"));
        });
        return result.build();
    }
}

