/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.archive.ArchiverType;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerPublishingResult;
import com.atlassian.bamboo.utils.Pair;
import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactHandlerPublishingResultImpl
implements ArtifactHandlerPublishingResult {
    private final boolean successful;
    private final Integer totalUploadedCount;
    private final Long totalUploadedSize;
    private String artifactHandlerKey;
    private ArchiverType archiverType = ArchiverType.NONE;

    private ArtifactHandlerPublishingResultImpl(boolean successful, Integer totalUploadedCount, Long totalUploadedSize) {
        this.successful = successful;
        this.totalUploadedCount = totalUploadedCount;
        this.totalUploadedSize = totalUploadedSize;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public Long getTotalUploadedSize() {
        return this.totalUploadedSize;
    }

    @Nullable
    public Integer getTotalUploadedCount() {
        return this.totalUploadedCount;
    }

    public void setArtifactHandlerKey(@NotNull String completeKey) {
        this.artifactHandlerKey = completeKey;
    }

    @NotNull
    public String getArtifactHandlerKey() {
        Preconditions.checkState((this.artifactHandlerKey != null ? 1 : 0) != 0, (Object)"artifactHandlerKey is null");
        return this.artifactHandlerKey;
    }

    @NotNull
    public ArchiverType getArchiverType() {
        return this.archiverType;
    }

    public void setArchiverType(@NotNull ArchiverType archiverType) {
        this.archiverType = archiverType;
    }

    public static ArtifactHandlerPublishingResult failure() {
        return new ArtifactHandlerPublishingResultImpl(false, null, null);
    }

    public static ArtifactHandlerPublishingResult success(@Nullable Integer totalUploadedCnt, @Nullable Long totalUploadedSize) {
        return new ArtifactHandlerPublishingResultImpl(true, totalUploadedCnt, totalUploadedSize);
    }

    public static ArtifactHandlerPublishingResult fromSuccessFlag(boolean isSuccessful) {
        return ArtifactHandlerPublishingResultImpl.fromSuccessFlag(isSuccessful, () -> Pair.make(null, null));
    }

    public static ArtifactHandlerPublishingResult fromSuccessFlag(boolean isSuccessful, @NotNull Supplier<Pair<Integer, Long>> uploadStatsSupplier) {
        if (isSuccessful) {
            Pair<Integer, Long> uploadStats = uploadStatsSupplier.get();
            return ArtifactHandlerPublishingResultImpl.success((Integer)uploadStats.getFirst(), (Long)uploadStats.getSecond());
        }
        return ArtifactHandlerPublishingResultImpl.failure();
    }
}

