/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.build.artifact.ArtifactHandler;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkDataProvider;
import com.atlassian.bamboo.build.artifact.ArtifactLinkManager;
import com.atlassian.bamboo.build.artifact.CopyTask;
import com.atlassian.bamboo.build.artifact.FileTask;
import com.atlassian.bamboo.build.artifact.MoveTask;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plugin.descriptor.ArtifactHandlerModuleDescriptor;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArtifactHandlingUtils {
    public static final String SERVER_LOCAL_HANDLER = "com.atlassian.bamboo.plugin.artifact.handler.local:ServerLocalArtifactHandler";
    public static final String SERVER_REMOTE_HANDLER = "com.atlassian.bamboo.plugin.artifact.handler.remote:BambooRemoteArtifactHandler";
    public static final String S3_HANDLER = "com.atlassian.bamboo.plugin.artifact.handler.remote:S3ArtifactHandler";
    private static final List<String> BAMBOO_DEFAULT_ARTIFACT_HANDLERS = ImmutableList.of((Object)"com.atlassian.bamboo.plugin.artifact.handler.remote:BambooRemoteArtifactHandler", (Object)"com.atlassian.bamboo.plugin.artifact.handler.local:ServerLocalArtifactHandler");

    private ArtifactHandlingUtils() {
    }

    @NotNull
    public static FileSet createFileSet(File baseDirectory, ArtifactDefinitionContext artifact, boolean useRelativeLocation, @Nullable Logger log) throws FileNotFoundException {
        File artifactLocation = ArtifactHandlingUtils.getArtifactLocation(baseDirectory, artifact, useRelativeLocation);
        if (!artifactLocation.isDirectory()) {
            throw new FileNotFoundException(artifactLocation + " is not a directory");
        }
        FileSet fileSet = new FileSet();
        PatternSet.NameEntry include = fileSet.createInclude();
        include.setName(artifact.getCopyPattern());
        fileSet.setDir(artifactLocation);
        fileSet.setProject(new Project());
        return fileSet;
    }

    public static void copyFileSet(FileSet sourceFileSet, File destinationDirectory) throws IOException {
        ArtifactHandlingUtils.transferFileSet(sourceFileSet, destinationDirectory, false);
    }

    public static void moveFileSet(FileSet sourceFileSet, File destinationDirectory) throws IOException {
        ArtifactHandlingUtils.transferFileSet(sourceFileSet, destinationDirectory, true);
    }

    public static void transferFileSet(FileSet sourceFileSet, File destinationDirectory, boolean deleteSource) throws IOException {
        FileTask task = deleteSource ? ArtifactHandlingUtils.createMoveTask(sourceFileSet, destinationDirectory) : ArtifactHandlingUtils.createCopyTask(sourceFileSet, destinationDirectory);
        try {
            task.execute();
        }
        catch (BuildException e) {
            throw new IOException(e);
        }
    }

    private static FileTask createCopyTask(FileSet sourceFileSet, File destinationDirectory) {
        CopyTask copyTask = new CopyTask();
        copyTask.setTodir(destinationDirectory);
        copyTask.addFileset(sourceFileSet);
        return copyTask;
    }

    private static FileTask createMoveTask(FileSet sourceFileSet, File destinationDirectory) {
        MoveTask moveTask = new MoveTask();
        moveTask.setTodir(destinationDirectory);
        moveTask.addFileset(sourceFileSet);
        return moveTask;
    }

    @NotNull
    public static File getArtifactLocation(@NotNull File baseDirectory, @NotNull ArtifactDefinitionContext artifact, boolean useRelativeLocation) {
        return useRelativeLocation ? ArtifactHandlingUtils.getArtifactLocation(baseDirectory, artifact) : baseDirectory;
    }

    @NotNull
    private static File getArtifactLocation(@NotNull File baseDirectory, @NotNull ArtifactDefinitionContext artifact) {
        return ArtifactHandlingUtils.resolveArtifactLocation(baseDirectory.toPath(), artifact.getLocation()).toFile();
    }

    @NotNull
    public static Path resolveArtifactLocation(Path basePath, @Nullable String location) {
        return StringUtils.isEmpty((CharSequence)location) ? basePath : basePath.resolve(location);
    }

    @NotNull
    public static String getArtifactMatchDescription(@NotNull ArtifactDefinitionContext artifact, @NotNull FileSet sourceFileSet) {
        return "[" + artifact.getCopyPattern() + "] in directory " + sourceFileSet.getDir();
    }

    public static Ordering<ArtifactHandler> fastestFirstOrdering(final @NotNull Map<String, String> artifactHandlersConfiguration) {
        return new Ordering<ArtifactHandler>(){

            public int compare(ArtifactHandler left, ArtifactHandler right) {
                return Integer.compare(right.getSpeed(artifactHandlersConfiguration), left.getSpeed(artifactHandlersConfiguration));
            }
        };
    }

    @Deprecated
    @Nullable
    public static String getArtifactUrl(@NotNull ArtifactLinkManager artifactLinkManager, @NotNull ArtifactLink artifactLink, @NotNull String baseUrl) {
        return ArtifactHandlingUtils.getArtifactUrl(artifactLinkManager, (Artifact)artifactLink.getArtifact(), baseUrl);
    }

    @Nullable
    public static String getArtifactUrl(@NotNull ArtifactLinkManager artifactLinkManager, @NotNull Artifact artifact, @NotNull String baseUrl) {
        ArtifactLinkDataProvider artifactLinkDataProvider = artifactLinkManager.getArtifactLinkDataProvider(artifact);
        if (artifactLinkDataProvider == null || artifact.getSize() < 0L) {
            return null;
        }
        String rootUrl = artifactLinkDataProvider.getRootUrl();
        if (rootUrl == null) {
            return null;
        }
        return StringUtils.replaceOnce((String)rootUrl, (String)"BASE_URL", (String)baseUrl);
    }

    public static boolean isCustomArtifactHandlingConfigured(Map<String, String> planCustomConfiguration) {
        return MapUtils.getBooleanValue(planCustomConfiguration, (Object)"custom.artifactHandlers.useCustomArtifactHandlers");
    }

    public static boolean isServerLocalArtifactHandler(String linkType) {
        return BambooStringUtils.in((String)linkType, (String[])new String[]{"system", SERVER_REMOTE_HANDLER, SERVER_LOCAL_HANDLER, "com.atlassian.bamboo.maven.sharing"});
    }

    public static ArtifactHandler getArtifactHandlerForLink(PluginAccessor pluginAccessor, String linkType) {
        if (ArtifactHandlingUtils.isServerLocalArtifactHandler(linkType)) {
            linkType = SERVER_LOCAL_HANDLER;
        }
        ArtifactHandlerModuleDescriptor artifactHandlerModuleDescriptor = (ArtifactHandlerModuleDescriptor)pluginAccessor.getEnabledPluginModule(linkType);
        return (ArtifactHandler)Preconditions.checkNotNull((Object)artifactHandlerModuleDescriptor.getModule());
    }

    public static boolean isDefaultArtifactHandler(String key) {
        return BAMBOO_DEFAULT_ARTIFACT_HANDLERS.contains(key);
    }

    @NotNull
    public static String getConfigKey(@NotNull String moduleDescriptorKey, @NotNull String settingKey) {
        return moduleDescriptorKey + ":" + settingKey;
    }
}

