/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.build.artifact.ArtifactLink;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class ArtifactLinkPredicates {
    private ArtifactLinkPredicates() {
    }

    public static boolean isSharedArtifact(ArtifactLink artifactLink) {
        return artifactLink.getArtifact().isSharedArtifact();
    }

    public static boolean isNotSharedArtifact(ArtifactLink artifactLink) {
        return !ArtifactLinkPredicates.isSharedArtifact(artifactLink);
    }

    public static boolean isOrphanedArtifact(ArtifactLink artifactLink) {
        return artifactLink.getProducerJobResult() == null && "system".equals(artifactLink.getArtifact().getLinkType());
    }

    public static boolean isAvailableLocally(ArtifactLink artifactLink) {
        String linkType = artifactLink.getArtifact().getLinkType();
        return linkType.equals("system") || linkType.equals("com.atlassian.bamboo.plugin.artifact.handler.remote:BambooRemoteArtifactHandler") || linkType.equals("com.atlassian.bamboo.plugin.artifact.handler.local:ServerLocalArtifactHandler");
    }

    public static Predicate<ArtifactLink> isLabelEqual(@NotNull String label) {
        return artifactLink -> Objects.equals(label, artifactLink.getArtifact().getLabel());
    }
}

