/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.CustomBuildProcessor;
import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.plan.artifact.ArtifactContext;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactPublishingResult;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildContextHelper;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.task.AbstractBuildTask;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuildArtifactPostProcessor
extends AbstractBuildTask
implements CustomBuildProcessor {
    private static final Logger log = Logger.getLogger(BuildArtifactPostProcessor.class);
    private ArtifactManager artifactManager;
    private BuildLoggerManager buildLoggerManager;
    private CustomVariableContext customVariableContext;
    private ErrorUpdateHandler errorUpdateHandler;

    @NotNull
    public BuildContext call() throws Exception {
        log.info((Object)("Copying the build artifacts for build: " + this.buildContext.getPlanResultKey()));
        BuildLogger buildLogger = this.buildLoggerManager.getLogger((ResultKey)this.buildContext.getPlanResultKey());
        File buildWorkingDirectory = BuildContextHelper.getBuildWorkingDirectory(this.buildContext);
        ArtifactContext artifactContext = this.buildContext.getArtifactContext();
        ErrorCollection validateArtifactsResult = this.artifactManager.validateArtifactsSize(buildWorkingDirectory, artifactContext);
        if (validateArtifactsResult.hasAnyErrors()) {
            for (List errorsForKey : validateArtifactsResult.getErrors().values()) {
                for (String errorForKey : errorsForKey) {
                    this.logError(buildLogger, errorForKey);
                }
            }
            for (String errorForKey : validateArtifactsResult.getErrorMessages()) {
                this.logError(buildLogger, errorForKey);
            }
        } else {
            for (ArtifactDefinitionContext artifact : artifactContext.getDefinitionContexts()) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                Stopwatch stopWatch = Stopwatch.createStarted();
                buildLogger.addBuildLogEntry("Publishing an artifact: " + artifact.getName());
                artifact.substituteVariables(this.customVariableContext);
                Map<String, String> artifactHandlerConfiguration = BuildContextHelper.getArtifactHandlerConfiguration((CommonContext)this.buildContext);
                ArtifactPublishingResult publishingResult = this.artifactManager.publish(buildLogger, this.buildContext.getPlanResultKey(), buildWorkingDirectory, artifact, artifactHandlerConfiguration, 1);
                artifactContext.addPublishingResult(publishingResult);
                if (publishingResult.getSuccessfulPublishingResults().isEmpty()) {
                    buildLogger.addBuildLogEntry("The artifact hasn't been successfully published after " + stopWatch);
                } else {
                    buildLogger.addBuildLogEntry("Finished publishing of artifact " + artifact + " in " + stopWatch);
                }
                if (publishingResult.shouldContinueBuild()) continue;
                this.buildContext.getBuildResult().setBuildState(BuildState.FAILED);
            }
        }
        return this.buildContext;
    }

    private void logError(BuildLogger buildLogger, String errorForKey) {
        log.warn((Object)buildLogger.addErrorLogEntry(errorForKey));
        this.errorUpdateHandler.recordError((ResultKey)this.buildContext.getPlanResultKey(), errorForKey, null);
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }

    public void setArtifactManager(ArtifactManager artifactManager) {
        this.artifactManager = artifactManager;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public void setErrorUpdateHandler(ErrorUpdateHandler errorUpdateHandler) {
        this.errorUpdateHandler = errorUpdateHandler;
    }
}

