/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.build.artifact.ArtifactFileData;
import com.atlassian.bamboo.build.artifact.ArtifactLinkDataProvider;
import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.atlassian.util.concurrent.Lazy;
import java.util.Date;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingArtifactLinkDataProviderDecorator
implements ArtifactLinkDataProvider {
    private final ArtifactLinkDataProvider delegate;
    public Supplier<Date> lastModified = Lazy.supplier((Supplier)new Supplier<Date>(){

        @Override
        @Nullable
        public Date get() {
            return CachingArtifactLinkDataProviderDecorator.this.delegate.lastModified();
        }
    });
    public Supplier<Long> size = Lazy.supplier((Supplier)new Supplier<Long>(){

        @Override
        public Long get() {
            return CachingArtifactLinkDataProviderDecorator.this.delegate.getSize();
        }
    });
    private final Supplier<Boolean> exists = Lazy.supplier((Supplier)new Supplier(){

        public Boolean get() {
            return CachingArtifactLinkDataProviderDecorator.this.delegate.exists();
        }
    });
    private final LoadingCache<Iterable<String>, Boolean> existsPathComponents = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Iterable<String>, Boolean>(){

        public Boolean load(Iterable<String> pathComponents) throws Exception {
            return CachingArtifactLinkDataProviderDecorator.this.delegate.exists(pathComponents);
        }
    });
    private final LoadingCache<String, Iterable<ArtifactFileData>> listObjectsCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Iterable<ArtifactFileData>>(){

        public Iterable<ArtifactFileData> load(@NotNull String subPath) throws Exception {
            return CachingArtifactLinkDataProviderDecorator.this.delegate.listObjects(subPath);
        }
    });
    private final Supplier<String> url = Lazy.supplier((Supplier)new Supplier<String>(){

        @Override
        public String get() {
            return CachingArtifactLinkDataProviderDecorator.this.delegate.getRootUrl();
        }
    });

    public CachingArtifactLinkDataProviderDecorator(ArtifactLinkDataProvider artifactLinkDataProvider) {
        this.delegate = artifactLinkDataProvider;
    }

    @NotNull
    public String getRootUrl() {
        return this.url.get();
    }

    @NotNull
    public Iterable<ArtifactFileData> listObjects(@Nullable String subpath) {
        return (Iterable)this.listObjectsCache.getUnchecked(MoreObjects.firstNonNull((Object)subpath, (Object)""));
    }

    @Nullable
    public Date lastModified() {
        return this.lastModified.get();
    }

    public long getSize() {
        return this.size.get();
    }

    public boolean exists() {
        return this.exists.get();
    }

    public boolean exists(Iterable<String> pathComponents) {
        return (Boolean)this.existsPathComponents.getUnchecked(pathComponents);
    }

    public static ArtifactLinkDataProvider decorate(ArtifactLinkDataProvider artifactLinkDataProvider) {
        return new CachingArtifactLinkDataProviderDecorator(artifactLinkDataProvider);
    }
}

