/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.artifact.MutableArtifact;
import com.atlassian.bamboo.artifact.MutableArtifactImpl;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerPublishingResult;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ConsumedSubscription;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Optional;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="BRS_ARTIFACT_LINK")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class DefaultArtifactLink
extends BambooEntityObject
implements ArtifactLink {
    private static final Logger log = Logger.getLogger(DefaultArtifactLink.class);
    private ResultsSummary resultsSummary;
    private BuildResultsSummary producerJobResult;
    private List<ConsumedSubscription> subscriptions;
    private MutableArtifact artifact;

    public DefaultArtifactLink(@NotNull ArtifactDefinitionContext artifactDefinitionContext, @NotNull BuildResultsSummary producerResult, @NotNull ArtifactHandlerPublishingResult publishingResult) {
        this(artifactDefinitionContext.getName(), artifactDefinitionContext.isSharedArtifact(), producerResult, publishingResult.getArtifactHandlerKey(), publishingResult.getTotalUploadedSize());
        this.artifact.setArchiverType(publishingResult.getArchiverType());
    }

    protected DefaultArtifactLink(String name, boolean sharedArtifact, @NotNull BuildResultsSummary producerResult, String linkType, Long size) {
        this(name, sharedArtifact, (ResultsSummary)(sharedArtifact ? producerResult.getChainResultsSummary() : producerResult), producerResult, linkType, size);
    }

    protected DefaultArtifactLink() {
    }

    @VisibleForTesting
    public DefaultArtifactLink(String name, boolean sharedArtifact, @NotNull ResultsSummary planResultsSummary, @Nullable BuildResultsSummary producerJobResult, String linkType, Long size) {
        this.resultsSummary = planResultsSummary;
        this.producerJobResult = producerJobResult;
        this.artifact = new MutableArtifactImpl(name, planResultsSummary.getPlanResultKey(), linkType, sharedArtifact, size);
    }

    public static DefaultArtifactLink createForExport(long artifactLinkId, ResultsSummary buildResultsSummary, Optional<? extends BuildResultsSummary> producerJobResult, MutableArtifact artifact) {
        DefaultArtifactLink artifactLink = new DefaultArtifactLink();
        artifactLink.setId(artifactLinkId);
        artifactLink.setBuildResultsSummary(buildResultsSummary);
        producerJobResult.ifPresent(artifactLink::setProducerJobResult);
        artifactLink.setArtifact(artifact);
        return artifactLink;
    }

    @NotNull
    public String getLinkType() {
        return this.artifact.getLinkType();
    }

    @NotNull
    public String getLabel() {
        return this.artifact.getLabel();
    }

    public long getSize() {
        return this.artifact.getSize();
    }

    public ResultsSummary getBuildResultsSummary() {
        return this.resultsSummary;
    }

    protected void setBuildResultsSummary(ResultsSummary resultsSummary) {
        this.resultsSummary = resultsSummary;
    }

    @Nullable
    public BuildResultsSummary getProducerJobResult() {
        return this.producerJobResult;
    }

    public void setProducerJobResult(@Nullable BuildResultsSummary producerJobResult) {
        this.producerJobResult = producerJobResult;
    }

    public boolean isSharedArtifact() {
        return this.artifact.isSharedArtifact();
    }

    public List<ConsumedSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    protected void setSubscriptions(List<ConsumedSubscription> subscriptions) {
        this.subscriptions = subscriptions;
    }

    @NotNull
    public MutableArtifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(MutableArtifact artifact) {
        this.artifact = artifact;
    }
}

