/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.artifact.ArtifactDao;
import com.atlassian.bamboo.artifact.ArtifactImpl;
import com.atlassian.bamboo.artifact.MutableArtifact;
import com.atlassian.bamboo.build.artifact.AbstractArtifactHandler;
import com.atlassian.bamboo.build.artifact.ArtifactHandler;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerConfigProvider;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerPublishingResult;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerPublishingResultImpl;
import com.atlassian.bamboo.build.artifact.ArtifactHandlingUtils;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkDao;
import com.atlassian.bamboo.build.artifact.ArtifactLinkDataProvider;
import com.atlassian.bamboo.build.artifact.ArtifactLinkManager;
import com.atlassian.bamboo.build.artifact.ArtifactLinkPredicates;
import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.build.artifact.DefaultArtifactLink;
import com.atlassian.bamboo.build.artifact.FileSystemArtifactLinkDataProvider;
import com.atlassian.bamboo.build.artifact.TrampolineUrlArtifactLinkDataProvider;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlersService;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactPublishingResult;
import com.atlassian.bamboo.plan.artifact.ArtifactPublishingResultImpl;
import com.atlassian.bamboo.plan.artifact.ConsumedSubscription;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.storage.ArtifactDirectoryBuilder;
import com.atlassian.bamboo.storage.StorageCappingService;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.FirstException;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultArtifactLinkManager
implements ArtifactLinkManager {
    private static final Logger log = Logger.getLogger(DefaultArtifactLinkManager.class);
    @Inject
    private ArtifactHandlersService artifactHandlersService;
    @Inject
    private StorageCappingService storageCappingService;
    @Inject
    private StorageLocationService storageLocationService;
    private final ArtifactLinkDao artifactLinkDao;
    private final ArtifactDao artifactDao;
    private final ArtifactManager artifactManager;
    private final PluginAccessor pluginAccessor;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;

    public DefaultArtifactLinkManager(ArtifactLinkDao artifactLinkDao, ArtifactDao artifactDao, ArtifactManager artifactManager, PluginAccessor pluginAccessor, AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.artifactLinkDao = artifactLinkDao;
        this.artifactManager = artifactManager;
        this.pluginAccessor = pluginAccessor;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.artifactDao = artifactDao;
    }

    @NotNull
    public ArtifactLink addArtifactLink(@NotNull BuildResultsSummary producerResult, @NotNull ArtifactDefinitionContext artifactDefinitionContext, @NotNull String publisherPluginKey) {
        ArtifactHandlerPublishingResult success = ArtifactHandlerPublishingResultImpl.success(null, null);
        success.setArtifactHandlerKey(publisherPluginKey);
        HashSet successfulPublishers = Sets.newHashSet((Object[])new ArtifactHandlerPublishingResult[]{success});
        ArtifactPublishingResult publishingResult = ArtifactPublishingResultImpl.success(artifactDefinitionContext, successfulPublishers);
        return (ArtifactLink)Iterables.getOnlyElement(this.addArtifactLinks(producerResult, publishingResult));
    }

    @NotNull
    public Collection<ArtifactLink> addArtifactLinks(@NotNull BuildResultsSummary producerResult, @NotNull ArtifactPublishingResult publishingResult) {
        ArtifactDefinitionContext artifactDefinitionContext = publishingResult.getArtifactDefinitionContext();
        ArrayList<ArtifactLink> artifactLinks = new ArrayList<ArtifactLink>();
        for (ArtifactHandlerPublishingResult artifactHandlerPublishingResult : publishingResult.getSuccessfulPublishingResults()) {
            DefaultArtifactLink artifactLink = new DefaultArtifactLink(artifactDefinitionContext, producerResult, artifactHandlerPublishingResult);
            if (artifactDefinitionContext.isSharedArtifact()) {
                ChainResultsSummary crs = producerResult.getChainResultsSummary();
                if (crs != null) {
                    crs.getArtifactLinks().add(artifactLink);
                }
            } else {
                producerResult.getArtifactLinks().add(artifactLink);
            }
            producerResult.getProducedArtifactLinks().add(artifactLink);
            this.saveLinkAndArtifact(artifactLink);
            artifactLinks.add(artifactLink);
        }
        return artifactLinks;
    }

    public void removeArtifactLink(long artifactLinkId) throws IOException {
        ArtifactLink artifactLink = (ArtifactLink)this.artifactLinkDao.findById(artifactLinkId);
        if (artifactLink != null) {
            this.removeArtifactLink(artifactLink);
        }
    }

    public void removeArtifactLink(@NotNull ArtifactLink artifactLink) throws IOException {
        BuildResultsSummary producerResult;
        ResultsSummary resultsSummary = artifactLink.getBuildResultsSummary();
        if (resultsSummary != null) {
            resultsSummary.getArtifactLinks().remove(artifactLink);
            if (this.artifactDao.isReferencedByVersion(artifactLink.getArtifact().getId())) {
                this.artifactManager.moveArtifactToGlobalStorage((Artifact)artifactLink.getArtifact());
            } else {
                this.artifactManager.removeArtifactFromStorage((Artifact)artifactLink.getArtifact());
            }
        }
        if ((producerResult = artifactLink.getProducerJobResult()) != null) {
            producerResult.getProducedArtifactLinks().remove(artifactLink);
        }
        this.artifactLinkDao.remove((EntityObject)artifactLink);
    }

    public void removeProducedArtifactLinks(@NotNull BuildResultsSummary buildResultsSummary) throws IOException {
        FirstException firstException = new FirstException();
        for (ArtifactLink artifactLink : ImmutableList.copyOf((Collection)buildResultsSummary.getProducedArtifactLinks())) {
            try {
                this.removeArtifactLink(artifactLink);
            }
            catch (IOException e) {
                firstException.setIfFirst((Throwable)e);
            }
        }
        firstException.throwIfPresent();
    }

    public void removeArtifactLinks(@NotNull BuildResultsSummary buildResultsSummary) {
        List nonSharedArtifactLinks = buildResultsSummary.getProducedArtifactLinks().stream().filter(ArtifactLinkPredicates::isNotSharedArtifact).collect(Collectors.toList());
        Iterables.removeIf((Iterable)buildResultsSummary.getProducedArtifactLinks(), ArtifactLinkPredicates::isNotSharedArtifact);
        this.artifactLinkDao.removeAll(buildResultsSummary.getArtifactLinks());
        buildResultsSummary.getArtifactLinks().clear();
        this.artifactManager.removeArtifactsFromStorage(nonSharedArtifactLinks);
    }

    public void removeArtifactLinks(@NotNull ChainResultsSummary chainResultsSummary) throws IOException {
        Collection artifactLinks = chainResultsSummary.getArtifactLinks();
        boolean foundSharedArtifacts = false;
        for (ArtifactLink artifactLink : artifactLinks) {
            foundSharedArtifacts |= artifactLink.getArtifact().isSharedArtifact();
            BuildResultsSummary producerResult = artifactLink.getProducerJobResult();
            if (producerResult != null) {
                producerResult.getProducedArtifactLinks().remove(artifactLink);
            }
            ArrayList subscriptions = new ArrayList(artifactLink.getSubscriptions());
            artifactLink.getSubscriptions().clear();
            Iterator iterator = subscriptions.iterator();
            while (iterator.hasNext()) {
                ConsumedSubscription subscription = (ConsumedSubscription)iterator.next();
                ResultsSummary consumerResult = subscription.getConsumerResultSummary();
                consumerResult.getSubscriptions().remove(subscription);
            }
        }
        if (CollectionUtils.isEmpty((Collection)artifactLinks)) {
            return;
        }
        Stopwatch stopWatch = Stopwatch.createStarted();
        List planResultArtifactsReferencedByVersion = foundSharedArtifacts ? this.artifactDao.findPlanResultArtifactsReferencedByVersion(chainResultsSummary.getPlanResultKey()) : Collections.emptyList();
        log.debug((Object)("Deployment artifact retrieval took " + stopWatch));
        FirstException firstException = new FirstException();
        for (MutableArtifact mutableArtifact : planResultArtifactsReferencedByVersion) {
            try {
                this.artifactManager.moveArtifactToGlobalStorage((Artifact)mutableArtifact);
            }
            catch (IOException e) {
                firstException.setIfFirst((Throwable)e);
            }
        }
        firstException.throwIfPresent();
        ArrayList artifactLinksToRemoveFromStorage = new ArrayList(artifactLinks);
        this.artifactLinkDao.removeAll(artifactLinks);
        artifactLinks.clear();
        this.artifactManager.removeArtifactsFromStorage(artifactLinksToRemoveFromStorage);
    }

    @NotNull
    public Collection<ArtifactLink> getArtifactLinksForLinkType(@NotNull ResultsSummary resultsSummary, @NotNull String linkType) {
        return this.getArtifactLinks(resultsSummary, linkType);
    }

    @NotNull
    public Collection<ArtifactLink> getArtifactLinks(@NotNull ResultsSummary resultsSummary, @Nullable String linkType) {
        return this.artifactLinkDao.getArtifactLinks(resultsSummary, linkType);
    }

    @Nullable
    public ArtifactLinkDataProvider getArtifactLinkDataProvider(@NotNull ArtifactLink artifactLink) {
        return this.getArtifactLinkDataProviderInternal((Artifact)artifactLink.getArtifact());
    }

    @Nullable
    public ArtifactLinkDataProvider getArtifactLinkDataProvider(@NotNull Artifact artifact) {
        ArtifactLinkDataProvider artifactLinkDataProvider = this.getArtifactLinkDataProviderInternal(artifact);
        TrampolineUrlArtifactLinkDataProvider trampolineProvider = (TrampolineUrlArtifactLinkDataProvider)Narrow.downTo((Object)artifactLinkDataProvider, TrampolineUrlArtifactLinkDataProvider.class);
        if (trampolineProvider != null) {
            trampolineProvider.setPlanResultKey(artifact.getPlanResultKey());
            trampolineProvider.setArtifactName(artifact.getLabel());
        }
        return artifactLinkDataProvider;
    }

    @Nullable
    private ArtifactLinkDataProvider getArtifactLinkDataProviderInternal(Artifact artifact) {
        String linkType = artifact.getLinkType();
        if (ArtifactHandlingUtils.isServerLocalArtifactHandler(linkType)) {
            ArtifactDirectoryBuilder artifactDirectoryBuilder = this.storageLocationService.getDefaultArtifactDirectoryBuilder();
            try {
                return new FileSystemArtifactLinkDataProvider(artifactDirectoryBuilder, artifact, this.administrationConfigurationAccessor.getAdministrationConfiguration().getResolveArtifactContentTypeByExtension());
            }
            catch (FileNotFoundException ignored) {
                return null;
            }
        }
        ArtifactHandler module = ArtifactHandlingUtils.getArtifactHandlerForLink(this.pluginAccessor, linkType);
        ArtifactHandlerConfigProvider configProvider = AbstractArtifactHandler.configProvider(this.artifactHandlersService);
        return module.getArtifactLinkDataProvider(artifact, configProvider);
    }

    @NotNull
    public Multimap<String, Artifact> findArtifactsByChainResultKey(@NotNull PlanResultKey chainResultKey) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (ArtifactLink artifactLink : this.artifactLinkDao.findArtifactsByChainResultKey(chainResultKey)) {
            result.put((Object)artifactLink.getArtifact().getLabel(), (Object)new ArtifactImpl((Artifact)artifactLink.getArtifact()));
        }
        return result;
    }

    private void saveLinkAndArtifact(@NotNull DefaultArtifactLink artifactLink) {
        this.artifactDao.save(artifactLink.getArtifact());
        this.artifactLinkDao.save((EntityObject)artifactLink);
        this.storageCappingService.onArtifactUpdated(artifactLink.getArtifact().getPlanResultKey(), artifactLink.getArtifact().getSize());
    }
}

