/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.build.artifact.ArtifactFileData;
import com.atlassian.bamboo.build.artifact.ArtifactFileDataImpl;
import com.atlassian.bamboo.build.artifact.ArtifactLinkDataProvider;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.storage.ArtifactDirectoryBuilder;
import com.atlassian.bamboo.storage.ArtifactPathBuilder;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.bamboo.utils.EscapeChars;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Pair;
import io.atlassian.util.concurrent.Lazy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.function.Supplier;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSystemArtifactLinkDataProvider
implements ArtifactLinkDataProvider {
    private static final Logger log = Logger.getLogger(FileSystemArtifactLinkDataProvider.class);
    private String url = null;
    private String filePathSuffix = null;
    private static final ImmutableList<String> INDEX_FILES = ImmutableList.of((Object)"index.html", (Object)"index.htm");
    private final Supplier<Long> sizeSupplier;
    final Supplier<Boolean> notEmptyArtifactSupplier;
    private static final String BROWSE_URL_ELEMENT = "browse";
    private File file;
    private final File artifactRoot;
    private final boolean lookForIndexFiles;

    public FileSystemArtifactLinkDataProvider(@NotNull ArtifactDirectoryBuilder artifactDirectoryBuilder, @NotNull Artifact artifact) throws FileNotFoundException {
        this(artifactDirectoryBuilder, artifact, true);
    }

    public FileSystemArtifactLinkDataProvider(@NotNull ArtifactDirectoryBuilder artifactDirectoryBuilder, @NotNull Artifact artifact, boolean lookForIndexFiles) throws FileNotFoundException {
        this.lookForIndexFiles = lookForIndexFiles;
        this.artifactRoot = artifactDirectoryBuilder.getArtifactDirectory(artifact);
        if (!this.artifactRoot.exists()) {
            throw new FileNotFoundException(this.artifactRoot + " does not exist");
        }
        Pair<String, Supplier<Long>> fileNameAndSize = this.getFileNameAndSize(this.artifactRoot);
        this.notEmptyArtifactSupplier = this.getArtifactNotEmpty(this.artifactRoot);
        StringBuilder urlSuffixBuilder = this.buildUrlSuffix(artifact);
        StringBuilder filePathSuffixBuilder = this.buildFileSuffix(artifact);
        if (fileNameAndSize != null) {
            String filename = (String)fileNameAndSize.left();
            filePathSuffixBuilder.append(File.separator).append(filename);
            urlSuffixBuilder.append("/").append(EscapeChars.forUrl((String)filename));
            this.sizeSupplier = (Supplier)fileNameAndSize.right();
        } else {
            this.sizeSupplier = null;
        }
        this.url = urlSuffixBuilder.toString();
        this.filePathSuffix = filePathSuffixBuilder.toString();
    }

    private StringBuilder buildUrlSuffix(Artifact artifact) {
        StringBuilder urlSuffixBuilder = new StringBuilder("BASE_URL");
        if (artifact.isGloballyStored()) {
            return urlSuffixBuilder.append("/global-artifact").append('/').append(artifact.getId());
        }
        PlanResultKey planResultKey = artifact.getPlanResultKey();
        PlanKey planKey = planResultKey.getPlanKey();
        boolean isJobResultsSummary = PlanKeys.isJobKey((PlanKey)planKey);
        PlanResultKey chainResultKey = isJobResultsSummary ? PlanKeys.getChainResultKey((PlanResultKey)planResultKey) : planResultKey;
        urlSuffixBuilder.append("/browse/").append(chainResultKey.getKey()).append("/artifact/");
        String artifactNameWithoutSpaces = StringUtils.replace((String)artifact.getLabel(), (String)" ", (String)"-");
        boolean treatAsSharedArtifact = artifact.isSharedArtifact() || !isJobResultsSummary;
        return urlSuffixBuilder.append(treatAsSharedArtifact ? "shared" : PlanKeys.getPartialJobKey((PlanKey)planKey)).append("/").append(EscapeChars.forUrl((String)artifactNameWithoutSpaces));
    }

    private StringBuilder buildFileSuffix(Artifact artifact) {
        ArtifactPathBuilder pathBuilder = ((StorageLocationService)ComponentAccessor.STORAGE_LOCATION_SERVICE.get()).getArtifactPathBuilder(File.separatorChar);
        return new StringBuilder(pathBuilder.getArtifactPath(artifact));
    }

    @Nullable
    private Pair<String, Supplier<Long>> getFileNameAndSize(File artifactRoot) {
        String filename;
        File[] filesInRoot = artifactRoot.listFiles();
        if (filesInRoot == null) {
            return null;
        }
        Supplier<Long> sizeSupplier = null;
        switch (filesInRoot.length) {
            case 0: {
                filename = "";
                sizeSupplier = () -> 0L;
                break;
            }
            case 1: {
                File file = filesInRoot[0];
                filename = file.getName();
                if (!file.isFile()) break;
                sizeSupplier = file::length;
                break;
            }
            default: {
                filename = this.lookForIndexFiles ? this.getIndexFilename(artifactRoot) : "";
            }
        }
        if (sizeSupplier == null) {
            sizeSupplier = Lazy.supplier(() -> FileUtils.sizeOfDirectory((File)artifactRoot));
        }
        this.file = new File(artifactRoot, filename);
        return Pair.pair((Object)filename, sizeSupplier);
    }

    @Nullable
    private Supplier<Boolean> getArtifactNotEmpty(final File artifactRoot) {
        return Lazy.supplier((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                File[] filesInRoot = artifactRoot.listFiles();
                if (filesInRoot == null) {
                    return Boolean.FALSE;
                }
                switch (filesInRoot.length) {
                    case 0: {
                        return Boolean.FALSE;
                    }
                    case 1: {
                        File file = filesInRoot[0];
                        if (!file.isFile()) break;
                        return file.length() > 0L;
                    }
                }
                return new DirectoryWalker<Boolean>(){
                    public boolean cancelled = false;

                    public boolean isNotEmpty(File root) {
                        ArrayList notEmpty = new ArrayList();
                        try {
                            this.walk(root, notEmpty);
                        }
                        catch (DirectoryWalker.CancelException cancelException) {
                        }
                        catch (IOException e) {
                            log.error((Object)e, (Throwable)e);
                            return false;
                        }
                        if (notEmpty.size() > 0) {
                            return (Boolean)notEmpty.iterator().next();
                        }
                        return false;
                    }

                    protected void handleFile(File file, int depth, Collection<Boolean> results) throws IOException {
                        if (file.length() > 0L) {
                            results.add(Boolean.TRUE);
                            this.cancelled = true;
                        }
                    }

                    protected boolean handleIsCancelled(File file, int depth, Collection<Boolean> results) throws IOException {
                        return this.cancelled;
                    }
                }.isNotEmpty(artifactRoot);
            }
        });
    }

    @NotNull
    public String getRootUrl() {
        return this.url;
    }

    @NotNull
    public Iterable<ArtifactFileData> listObjects(@Nullable String subpath) {
        return Collections.singleton(new ArtifactFileDataImpl("", ArtifactFileData.FileType.REGULAR_FILE, StringUtils.substringAfter((String)this.url, (String)"BASE_URL"), null, null, Long.valueOf(0L)));
    }

    public long getSize() {
        return this.sizeSupplier.get();
    }

    @NotNull
    private String getIndexFilename(File directory) {
        for (String indexFile : INDEX_FILES) {
            File possibleIndexFile = new File(directory, indexFile);
            if (!possibleIndexFile.canRead() || !possibleIndexFile.isFile()) continue;
            return indexFile;
        }
        return "";
    }

    public Date lastModified() {
        return new Date(this.file.lastModified());
    }

    public boolean exists() {
        return this.filePathSuffix != null && this.notEmptyArtifactSupplier.get() != false;
    }

    public boolean exists(Iterable<String> pathComponents) {
        return new File(this.artifactRoot, Joiner.on((char)File.separatorChar).join(pathComponents)).exists();
    }

    public File getFile() {
        return this.file;
    }
}

