/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.build.artifact.FileTask;
import com.atlassian.bamboo.utils.BambooFiles;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.log4j.Logger;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.resources.FileResource;
import org.jetbrains.annotations.NotNull;

abstract class FileTransferTask
extends FileTask {
    private static final Logger log = Logger.getLogger(FileTransferTask.class);

    FileTransferTask() {
    }

    @Override
    public void execute() throws IOException {
        FileSet sourceFileSet = this.getSourceFileSet();
        File todir = this.getTodir();
        for (FileResource fileResource : sourceFileSet) {
            File source = fileResource.getFile();
            if (!source.isDirectory()) {
                String relativePath = fileResource.getBaseDir().toPath().normalize().relativize(fileResource.getFile().toPath().normalize()).toString();
                File destination = new File(todir, relativePath);
                this.createDestinationPathIfRequired(destination);
                log.debug((Object)("copy '" + source.getAbsolutePath() + "' to '" + destination.getAbsolutePath() + "'"));
                boolean executable = BambooFiles.isExecutable((Path)source.toPath());
                this.transfer(source, destination);
                this.preserveExecutablePermissions(destination.toPath(), executable);
                continue;
            }
            throw new UnsupportedOperationException("Folder processing is not supported");
        }
    }

    protected abstract void transfer(File var1, File var2) throws IOException;

    private void preserveExecutablePermissions(Path destination, boolean executable) throws IOException {
        BambooFiles.setExecutable((Path)destination, (boolean)executable);
    }

    private void createDestinationPathIfRequired(@NotNull File destination) {
        boolean created = destination.getName().endsWith("/") ? destination.mkdirs() : destination.getParentFile().mkdirs();
        if (!created) {
            log.debug((Object)("destination path was not created, maybe already exists - " + destination.getAbsolutePath()));
        }
    }
}

