/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.artifact.ArtifactDao;
import com.atlassian.bamboo.artifact.MutableArtifact;
import com.atlassian.bamboo.build.artifact.AbstractArtifactManager;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.storage.StorageCappingService;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.BambooHibernateUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LocalArtifactManager
extends AbstractArtifactManager {
    private static final Logger log = Logger.getLogger(LocalArtifactManager.class);
    @Inject
    private ArtifactSubscriptionManager artifactSubscriptionManager;
    @Inject
    private StorageCappingService storageCappingService;
    @Inject
    private ArtifactDao artifactDao;
    @Inject
    private TransactionAndHibernateTemplate transactionTemplate;
    @Inject
    private StorageLocationService storageLocationService;

    @Override
    protected void markSubscriptionAsConsumed(PlanResultKey planResultKey, ArtifactSubscriptionContext artifactSubscription, String artifactLinkType) {
        this.artifactSubscriptionManager.saveConsumedSubscription(artifactSubscription, planResultKey, artifactLinkType);
    }

    @Override
    public void moveArtifactToGlobalStorage(@NotNull Artifact artifact) throws IOException {
        super.moveArtifactToGlobalStorage(artifact);
        MutableArtifact mutableArtifact = this.artifactDao.findById(artifact.getId());
        mutableArtifact.setGloballyStored(true);
        this.artifactDao.save(mutableArtifact);
        this.storageCappingService.onArtifactUpdated(artifact.getPlanResultKey(), artifact.getSize());
    }

    @Override
    public void removeArtifactFromStorage(@NotNull Artifact artifact) {
        super.removeArtifactFromStorage(artifact);
        this.artifactDao.removeById(artifact.getId());
        this.storageCappingService.onArtifactUpdated(artifact.getPlanResultKey(), -artifact.getSize());
    }

    @Override
    public void removeArtifactsFromStorage(@NotNull PlanKey planKey) {
        super.removeArtifactsFromStorage(planKey);
        this.artifactDao.removeByPlanKey(planKey);
        this.storageCappingService.onArtifactUpdated(null, Long.MIN_VALUE);
    }

    @Override
    public void removeArtifactsFromStorage(@NotNull Iterable<ArtifactLink> artifactLinks) {
        super.removeArtifactsFromStorage(artifactLinks);
        HashSet<PlanResultKey> planResultKeys = new HashSet<PlanResultKey>();
        long size = 0L;
        for (ArtifactLink artifactLink : artifactLinks) {
            ResultsSummary buildResultsSummary = artifactLink.getBuildResultsSummary();
            if (buildResultsSummary == null) continue;
            planResultKeys.add(buildResultsSummary.getPlanResultKey());
            size += artifactLink.getArtifact().getSize();
        }
        for (PlanResultKey planResultKey : planResultKeys) {
            this.artifactDao.removeByPlanResultKey(planResultKey);
        }
        this.storageCappingService.onArtifactUpdated(null, -size);
    }

    @Override
    public boolean removeOrphanedArtifacts() {
        return this.removeArtifacts(() -> ((ArtifactDao)this.artifactDao).findOrphanedArtifacts());
    }

    @Override
    public boolean removeArtifactsIfOrphaned(@NotNull List<Long> artifactIds) {
        return this.removeArtifacts(() -> this.artifactDao.findOrphanedArtifactsByIds(artifactIds));
    }

    private boolean removeArtifacts(@NotNull Supplier<Collection<MutableArtifact>> artifactSupplier) {
        try {
            return (Boolean)this.transactionTemplate.execute(session -> {
                BambooHibernateUtils.flushIfNeeded(session);
                session.clear();
                Collection artifacts = (Collection)artifactSupplier.get();
                if (artifacts.isEmpty()) {
                    return false;
                }
                List ids = artifacts.stream().map(BambooIdProvider::getId).collect(Collectors.toList());
                log.info((Object)("Removing " + artifacts.size() + " orphaned artifacts: " + ids));
                long size = 0L;
                for (Artifact artifact : artifacts) {
                    size += artifact.getSize();
                    LocalArtifactManager.super.removeArtifactFromStorage(artifact);
                }
                this.artifactDao.removeAll(artifacts);
                this.storageCappingService.onArtifactUpdated(null, -size);
                return true;
            });
        }
        catch (RuntimeException e) {
            log.warn((Object)"", (Throwable)e);
            return false;
        }
    }

    public void cleanupTemporaryArtifactStorage() {
        File tmpStorageDirectory = this.storageLocationService.getDefaultArtifactDirectoryBuilder().getTemporaryDirectory();
        if (!tmpStorageDirectory.isDirectory()) {
            return;
        }
        try {
            log.debug((Object)String.format("Cleanup of temporary artifact storage %s started", tmpStorageDirectory.getAbsolutePath()));
            BambooFileUtils.cleanDirectory(tmpStorageDirectory);
            log.debug((Object)"Cleanup of temporary artifact storage completed");
        }
        catch (IOException e) {
            log.warn((Object)String.format("Unable to clean temporary artifact storage %s", tmpStorageDirectory.getAbsolutePath()), (Throwable)e);
        }
    }
}

