/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ResponseHeaderOverrides;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.atlassian.aws.utils.FullListObjectsResult;
import com.atlassian.bamboo.build.artifact.ArtifactFileData;
import com.atlassian.bamboo.build.artifact.ArtifactFileDataImpl;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerConfigProvider;
import com.atlassian.bamboo.build.artifact.ArtifactLinkDataProvider;
import com.atlassian.bamboo.build.artifact.MutableArtifactFileData;
import com.atlassian.bamboo.utils.EscapeChars;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.net.URL;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class S3ArtifactLinkDataProvider
implements ArtifactLinkDataProvider {
    private final AmazonS3 s3Client;
    private final String bucketName;
    private final String keyInBucket;

    public S3ArtifactLinkDataProvider(@NotNull AmazonS3 s3Client, @NotNull String bucketName, @NotNull String keyInBucket, ArtifactHandlerConfigProvider artifactHandlerConfigProvider) {
        this.s3Client = s3Client;
        this.bucketName = bucketName;
        this.keyInBucket = keyInBucket + '/';
    }

    @NotNull
    public String getRootUrl() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Iterable<ArtifactFileData> listObjects(@Nullable String subpath) {
        FullListObjectsResult.ContinuousObjectListing objectListing = this.s3ListObjects(this.getFullKey(subpath));
        Iterable files = Iterables.transform((Iterable)objectListing.getS3ObjectSummaries(), this::objectToArtifactData);
        Iterable dirs = Iterables.transform((Iterable)objectListing.getCommonPrefixes(), this::dirToArtifactData);
        return Iterables.concat((Iterable)files, (Iterable)dirs);
    }

    private ArtifactFileData dirToArtifactData(String key) {
        String keyWithoutTrailingSlash = StringUtils.removeEnd((String)key, (String)"/");
        return new MutableArtifactFileData(keyWithoutTrailingSlash, ArtifactFileData.FileType.DIRECTORY).withTag(this.getSubKey(key));
    }

    private ArtifactFileData objectToArtifactData(S3ObjectSummary s3ObjectSummary) {
        final String fullKey = s3ObjectSummary.getKey();
        return new ArtifactFileDataImpl(fullKey, ArtifactFileData.FileType.REGULAR_FILE, null, this.getSubKey(fullKey), s3ObjectSummary.getLastModified(), s3ObjectSummary.getSize()){

            @Nullable
            public String getUrl() {
                return S3ArtifactLinkDataProvider.this.getSignedUrl(fullKey);
            }
        };
    }

    private String getSubKey(@Nullable String key) {
        return StringUtils.removeStart((String)key, (String)this.keyInBucket);
    }

    private String getFullKey(@Nullable String subKey) {
        if (StringUtils.isEmpty((CharSequence)subKey)) {
            return this.keyInBucket;
        }
        return this.keyInBucket + subKey;
    }

    private String getSignedUrl(String key) {
        GeneratePresignedUrlRequest presignedUrlRequest = new GeneratePresignedUrlRequest(this.bucketName, key);
        String fileName = FilenameUtils.getName((String)key);
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            ResponseHeaderOverrides responseHeaders = new ResponseHeaderOverrides().withContentDisposition("attachment; filename=\"" + EscapeChars.forUrl((String)fileName) + "\"");
            presignedUrlRequest.withResponseHeaders(responseHeaders);
        }
        URL url = this.s3Client.generatePresignedUrl(presignedUrlRequest);
        return url.toString();
    }

    public Date lastModified() {
        return null;
    }

    public long getSize() {
        return 0L;
    }

    public boolean exists() {
        FullListObjectsResult.ContinuousObjectListing objectSummary = this.s3ListObjects(this.keyInBucket);
        return !Iterables.isEmpty((Iterable)objectSummary.getS3ObjectSummaries()) || !Iterables.isEmpty((Iterable)objectSummary.getCommonPrefixes());
    }

    public boolean exists(Iterable<String> pathComponents) {
        String fullPath = this.keyInBucket + Joiner.on((char)'/').join(pathComponents);
        FullListObjectsResult.ContinuousObjectListing objectSummary = this.s3ListObjects(fullPath);
        Iterable objectSummaries = objectSummary.getS3ObjectSummaries();
        for (S3ObjectSummary summary : objectSummaries) {
            if (!summary.getKey().equals(fullPath)) continue;
            return true;
        }
        Iterable commonPrefixes = objectSummary.getCommonPrefixes();
        for (String commonPrefix : commonPrefixes) {
            if (!commonPrefix.equals(fullPath + '/')) continue;
            return true;
        }
        return false;
    }

    private FullListObjectsResult.ContinuousObjectListing s3ListObjects(String key) {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.bucketName).withPrefix(key).withDelimiter("/").withMaxKeys(Integer.valueOf(100));
        return FullListObjectsResult.listObjects((AmazonS3)this.s3Client, (ListObjectsRequest)listObjectsRequest);
    }
}

