/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.build.artifact.AbstractLocalArtifactHandler;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerConfigProvider;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerPublishingResult;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerPublishingResultImpl;
import com.atlassian.bamboo.build.artifact.ArtifactPublishingConfig;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.storage.ArtifactDirectoryBuilder;
import com.atlassian.bamboo.storage.StorageCappingService;
import com.atlassian.bamboo.storage.StorageLocationService;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ServerLocalArtifactHandler
extends AbstractLocalArtifactHandler {
    private static final Logger log = Logger.getLogger(ServerLocalArtifactHandler.class);

    public ServerLocalArtifactHandler() {
        super(LOCAL_AGENTS);
    }

    @Override
    @NotNull
    public ArtifactHandlerPublishingResult publish(@NotNull PlanResultKey planResultKey, @NotNull ArtifactDefinitionContext artifact, @NotNull ArtifactPublishingConfig artifactPublishingConfig) throws IOException {
        if (((StorageCappingService)ComponentAccessor.STORAGE_CAPPING_SERVICE.get()).isHardLimitExceeded()) {
            log.error((Object)("Unable to publish artifact " + artifact + " for " + planResultKey + " because local storage is full. Switch to S3 storage"));
            return ArtifactHandlerPublishingResultImpl.failure();
        }
        return super.publish(planResultKey, artifact, artifactPublishingConfig);
    }

    @Override
    protected ArtifactDirectoryBuilder getArtifactDirectoryBuilder(@NotNull ArtifactHandlerConfigProvider artifactHandlerConfigProvider) {
        return ((StorageLocationService)ComponentAccessor.STORAGE_LOCATION_SERVICE.get()).getDefaultArtifactDirectoryBuilder();
    }
}

