/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.build.artifact.ArtifactFileData;
import com.atlassian.bamboo.build.artifact.ArtifactLinkDataProvider;
import com.atlassian.bamboo.build.artifact.TrampolineArtifactFileData;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.utils.EscapeChars;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrampolineUrlArtifactLinkDataProvider
implements ArtifactLinkDataProvider {
    private final ArtifactLinkDataProvider delegate;
    private PlanResultKey planResultKey;
    private String artifactName;

    public TrampolineUrlArtifactLinkDataProvider(ArtifactLinkDataProvider artifactLinkDataProvider) {
        this.delegate = artifactLinkDataProvider;
    }

    @NotNull
    public String getRootUrl() {
        this.checkState();
        return TrampolineUrlArtifactLinkDataProvider.createTrampolineUrl(this.planResultKey, this.artifactName, null);
    }

    private void checkState() {
        Preconditions.checkState((this.planResultKey != null ? 1 : 0) != 0);
        Preconditions.checkState((this.artifactName != null ? 1 : 0) != 0);
    }

    @NotNull
    public Iterable<ArtifactFileData> listObjects(@Nullable String subpath) {
        this.checkState();
        return Iterables.transform((Iterable)this.delegate.listObjects(subpath), this::toTrampolineArtifactData);
    }

    private ArtifactFileData toTrampolineArtifactData(ArtifactFileData artifactFileData) {
        if (artifactFileData.getFileType() == ArtifactFileData.FileType.REGULAR_FILE) {
            return new TrampolineArtifactFileData(artifactFileData, artifactFileData.getUrl());
        }
        String trampolineUrl = TrampolineUrlArtifactLinkDataProvider.createTrampolineUrl(this.planResultKey, this.artifactName, artifactFileData.getTag());
        return new TrampolineArtifactFileData(artifactFileData, trampolineUrl);
    }

    @Nullable
    public Date lastModified() {
        return this.delegate.lastModified();
    }

    public long getSize() {
        return this.delegate.getSize();
    }

    public boolean exists() {
        return this.delegate.exists();
    }

    public boolean exists(Iterable<String> pathComponents) {
        return this.delegate.exists(pathComponents);
    }

    public void setPlanResultKey(PlanResultKey planResultKey) {
        this.planResultKey = planResultKey;
    }

    public void setArtifactName(String artifactName) {
        this.artifactName = artifactName;
    }

    public ArtifactLinkDataProvider getDelegate() {
        return this.delegate;
    }

    public static ArtifactLinkDataProvider decorate(ArtifactLinkDataProvider artifactLinkDataProvider) {
        if (artifactLinkDataProvider instanceof TrampolineUrlArtifactLinkDataProvider) {
            return artifactLinkDataProvider;
        }
        return new TrampolineUrlArtifactLinkDataProvider(artifactLinkDataProvider);
    }

    public static String createTrampolineUrl(PlanResultKey planResultKey, String artifactName, @Nullable String tag) {
        StringBuilder sb = new StringBuilder("BASE_URL").append("/build/result/artifactUrlRedirect.action?planKey=").append(planResultKey.getPlanKey()).append("&buildNumber=").append(planResultKey.getBuildNumber()).append("&artifactName=").append(EscapeChars.forUrl((String)artifactName));
        if (tag != null) {
            sb.append("&tag=").append(tag);
        }
        return sb.toString();
    }
}

