/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact.handlers;

import com.atlassian.bamboo.build.artifact.ArtifactHandlingUtils;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlerConfigurator;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugin.descriptor.ArtifactHandlerModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.ArtifactHandlerModuleDescriptorImpl;
import com.atlassian.bamboo.utils.MessageCollection;
import com.atlassian.bamboo.utils.MessageCollectionImpl;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractArtifactHandlerConfigurator
implements ArtifactHandlerConfigurator {
    public static final String SHARED_ARTIFACT_OPTION_NAME = ArtifactHandlerModuleDescriptorImpl.SHARED_NON_SHARED_ONOFF_OPTION_NAME.get(Boolean.TRUE);
    public static final String NON_SHARED_ARTIFACT_OPTION_NAME = ArtifactHandlerModuleDescriptorImpl.SHARED_NON_SHARED_ONOFF_OPTION_NAME.get(Boolean.FALSE);
    private ArtifactHandlerModuleDescriptor moduleDescriptor;

    public void init(@NotNull ArtifactHandlerModuleDescriptor moduleDescriptor) {
        this.moduleDescriptor = moduleDescriptor;
    }

    public void postProcessConfiguration(ActionParametersMap actionParametersMap) {
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context) {
        context.put("pluginModuleConfigurationPrefix", this.moduleDescriptor.getConfigurationPrefix());
    }

    @NotNull
    protected String getConfigurationKey(@NotNull String key) {
        return ArtifactHandlingUtils.getConfigKey(this.moduleDescriptor.getConfigurationPrefix(), key);
    }

    public void decorateConfigurationForRuntime(@NotNull Map<String, String> artifactHandlersConfiguration) {
    }

    public void validateConfiguration(@NotNull Map<String, String> newArtifactHandlersConfiguration, @NotNull Map<String, String> oldArtifactHandlersConfiguration, @NotNull ErrorCollection errorCollection) {
    }

    public boolean isConfigurationComplete(@NotNull Map<String, String> configuration) {
        return true;
    }

    public Map<String, String> getEncryptedArtifactHandlerConfiguration(@NotNull Map<String, String> configuration) {
        return this.getArtifactHandlerConfiguration(configuration);
    }

    public Map<String, String> getArtifactHandlerConfiguration(@NotNull Map<String, String> configuration) {
        String nonSharedArtifactEnabledKey;
        HashMap<String, String> result = new HashMap<String, String>();
        String sharedArtifactEnabledKey = this.getConfigurationKey(SHARED_ARTIFACT_OPTION_NAME);
        if (configuration.containsKey(sharedArtifactEnabledKey)) {
            result.put(sharedArtifactEnabledKey, configuration.get(sharedArtifactEnabledKey));
        }
        if (configuration.containsKey(nonSharedArtifactEnabledKey = this.getConfigurationKey(NON_SHARED_ARTIFACT_OPTION_NAME))) {
            result.put(nonSharedArtifactEnabledKey, configuration.get(nonSharedArtifactEnabledKey));
        }
        return result;
    }

    public MessageCollection beforeSave(Map<String, String> artifactHandlersConfigurationBeforeSave, Map<String, String> existingArtifactHandlersConfiguration) {
        return new MessageCollectionImpl();
    }
}

