/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact.handlers;

import com.atlassian.bamboo.build.artifact.ArtifactHandlingUtils;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlersService;
import com.atlassian.bamboo.event.ServerStartedEvent;
import com.atlassian.bamboo.plugin.descriptor.ArtifactHandlerModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.ArtifactHandlerModuleDescriptorImpl;
import com.atlassian.event.api.EventListener;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class ArtifactHandlerConfigListener {
    @Inject
    private ArtifactHandlersService artifactHandlersService;

    @EventListener
    public void onServerStarted(ServerStartedEvent event) {
        Map configuration = this.artifactHandlersService.getConfiguration();
        List artifactHandlerModuleDescriptors = this.artifactHandlersService.getArtifactHandlerModuleDescriptors();
        String enabledForShared = ArtifactHandlerModuleDescriptorImpl.SHARED_NON_SHARED_ONOFF_OPTION_NAME.get(Boolean.TRUE);
        String enabledForNonShared = ArtifactHandlerModuleDescriptorImpl.SHARED_NON_SHARED_ONOFF_OPTION_NAME.get(Boolean.FALSE);
        boolean requireSaving = false;
        for (ArtifactHandlerModuleDescriptor artifactHandlerModuleDescriptor : artifactHandlerModuleDescriptors) {
            String enabledForNonSharedConfigKey;
            boolean isDefault = ArtifactHandlingUtils.isDefaultArtifactHandler(artifactHandlerModuleDescriptor.getCompleteKey());
            String enabledForSharedConfigKey = ArtifactHandlingUtils.getConfigKey(artifactHandlerModuleDescriptor.getConfigurationPrefix(), enabledForShared);
            if (configuration.get(enabledForSharedConfigKey) == null) {
                configuration.put(enabledForSharedConfigKey, String.valueOf(isDefault));
                requireSaving = true;
            }
            if (configuration.get(enabledForNonSharedConfigKey = ArtifactHandlingUtils.getConfigKey(artifactHandlerModuleDescriptor.getConfigurationPrefix(), enabledForNonShared)) != null) continue;
            configuration.put(enabledForNonSharedConfigKey, String.valueOf(isDefault));
            requireSaving = true;
        }
        if (requireSaving) {
            this.artifactHandlersService.saveConfiguration(configuration);
        }
    }
}

