/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact.handlers;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.archive.ArchiverResolver;
import com.atlassian.bamboo.archive.ArchiverType;
import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.build.artifact.ArtifactHandler;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerDecoratorSupport;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerPublishingResult;
import com.atlassian.bamboo.build.artifact.ArtifactHandlingUtils;
import com.atlassian.bamboo.build.artifact.ArtifactPublishingConfig;
import com.atlassian.bamboo.build.artifact.ArtifactRetrievalConfig;
import com.atlassian.bamboo.build.artifact.ArtifactRetrievalStatus;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionContext;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.utils.archive.ArchiveUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.types.FileSet;
import org.jetbrains.annotations.NotNull;

public class ArtifactHandlerPackagingDecorator
extends ArtifactHandlerDecoratorSupport {
    private static final Logger log = Logger.getLogger(ArtifactHandlerPackagingDecorator.class);
    @VisibleForTesting
    static final ArchiverType ARCHIVER_TYPE = ArchiverType.ZIP;
    @VisibleForTesting
    static final String ARCHIVE_FILE_EXTENSION = ArchiverResolver.getDefaultArchiveExtension(ARCHIVER_TYPE);
    @VisibleForTesting
    static final int ARCHIVE_NAME_MAX_LENGTH = 64;
    @VisibleForTesting
    static final String ARCHIVE_NAME_LEGAL_CHARACTER_REGEX = "a-zA-Z0-9 \\.\\-_";
    private final ArtifactHandler delegate;

    public ArtifactHandlerPackagingDecorator(@NotNull ArtifactHandler delegate) {
        this.delegate = delegate;
    }

    @NotNull
    protected ArtifactHandler delegate() {
        return this.delegate;
    }

    @NotNull
    public static Function<ArtifactHandler, ArtifactHandler> addFilePackaging() {
        return new Function<ArtifactHandler, ArtifactHandler>(){

            public ArtifactHandler apply(ArtifactHandler artifactHandler) {
                return new ArtifactHandlerPackagingDecorator(artifactHandler);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ArtifactHandlerPublishingResult publish(@NotNull PlanResultKey planResultKey, @NotNull ArtifactDefinitionContext artifact, @NotNull ArtifactPublishingConfig artifactPublishingConfig) throws Exception {
        boolean shouldArchive;
        FileSet sourceFileSet = artifactPublishingConfig.getSourceFileSet();
        Map artifactHandlersConfiguration = artifactPublishingConfig.getArtifactHandlersConfiguration();
        long maxUnarchivedFiles = this.delegate().getMaxUnarchivedFilesPerArtifact(artifactHandlersConfiguration);
        int sourceFilesCount = sourceFileSet.size();
        boolean bl = shouldArchive = (long)sourceFilesCount > maxUnarchivedFiles;
        if (!shouldArchive) {
            return this.delegate().publish(planResultKey, artifact, artifactPublishingConfig);
        }
        File temporaryDir = BambooFileUtils.createTempDirectory(((Object)((Object)this)).getClass().getSimpleName());
        try {
            log.info((Object)String.format("Maximum number of files per artifact exceeded (max: %d, actual: %d), compressing into a single archive", maxUnarchivedFiles, sourceFilesCount));
            File archive = new File(temporaryDir, ArtifactHandlerPackagingDecorator.getArchiveName(artifact));
            Iterable<File> filesToArchive = BambooFileUtils.getFilesFromFileSet(sourceFileSet);
            ArchiveUtils.compressFiles(ARCHIVER_TYPE, filesToArchive, archive, sourceFileSet.getDir());
            log.info((Object)String.format("Archive created, size: %d bytes", archive.length()));
            FileSet fileSet = new FileSet();
            fileSet.setProject(sourceFileSet.getProject());
            fileSet.setFile(archive);
            ArtifactPublishingConfig archivedArtifactPublishingConfig = new ArtifactPublishingConfig(fileSet, artifactHandlersConfiguration);
            ArtifactHandlerPublishingResult publishingResult = this.delegate().publish(planResultKey, artifact, archivedArtifactPublishingConfig);
            publishingResult.setArchiverType(ARCHIVER_TYPE);
            ArtifactHandlerPublishingResult artifactHandlerPublishingResult = publishingResult;
            return artifactHandlerPublishingResult;
        }
        finally {
            BambooFileUtils.deleteQuietly(temporaryDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ArtifactRetrievalStatus retrieve(@NotNull ResultKey clientKey, @NotNull Artifact artifact, @NotNull ArtifactSubscriptionContext artifactSubscription, @NotNull ArtifactRetrievalConfig artifactRetrievalConfig) throws Exception {
        boolean wasArchived;
        ArtifactRetrievalStatus initialRetrievalStatus = this.delegate().retrieve(clientKey, artifact, artifactSubscription, artifactRetrievalConfig);
        String handlerKey = this.delegate().getModuleDescriptor().getCompleteKey();
        ArchiverType archiverType = artifact.getArchiverType();
        boolean wasRetrieved = initialRetrievalStatus.isRetrieved();
        boolean bl = wasArchived = archiverType != ArchiverType.NONE;
        if (!wasRetrieved || !wasArchived) {
            return initialRetrievalStatus;
        }
        log.info((Object)"Artifact files were packaged, extracting archive content");
        File temporaryDir = BambooFileUtils.createTempDirectory(((Object)((Object)this)).getClass().getSimpleName());
        try {
            Preconditions.checkState((boolean)initialRetrievalStatus.isSingleFile(), (Object)"Expected retrieval of a single archive file, multiple files found");
            File destinationDirectory = ArtifactHandlingUtils.resolveArtifactLocation(artifactRetrievalConfig.getBaseDestinationPath().toPath(), artifactSubscription.getDestinationPath()).toFile();
            File archiveFile = initialRetrievalStatus.getSingleFile();
            File archiveFileInTempDir = new File(temporaryDir, archiveFile.getName());
            log.debug((Object)String.format("Moving archive file '%s' to temporary directory '%s'", archiveFile.getCanonicalFile(), archiveFileInTempDir.getCanonicalPath()));
            FileUtils.moveFile((File)archiveFile, (File)archiveFileInTempDir);
            log.debug((Object)("Extracting archived artifact files to destination directory: " + destinationDirectory.getCanonicalPath()));
            ArchiveUtils.extractArchive(archiverType, archiveFileInTempDir, destinationDirectory);
            Preconditions.checkState((destinationDirectory.list().length > 0 ? 1 : 0) != 0, (Object)"Should have extracted at least one artifact file");
            log.info((Object)("Extracted archive to destination directory: " + destinationDirectory.getCanonicalPath()));
            ArtifactRetrievalStatus artifactRetrievalStatus = destinationDirectory.list().length == 1 ? ArtifactRetrievalStatus.singleFile((File)destinationDirectory.listFiles()[0], (String)handlerKey) : ArtifactRetrievalStatus.multipleFiles((File)destinationDirectory, (String)handlerKey);
            return artifactRetrievalStatus;
        }
        finally {
            BambooFileUtils.deleteQuietly(temporaryDir);
        }
    }

    @NotNull
    @VisibleForTesting
    static String getArchiveName(@NotNull ArtifactDefinitionContext artifact) {
        String extension = '.' + ARCHIVE_FILE_EXTENSION;
        String shortenedArtifactName = StringUtils.left((String)artifact.getName(), (int)(64 - extension.length()));
        String unsafeArchiveName = shortenedArtifactName + extension;
        return unsafeArchiveName.replaceAll(String.format("[^%s]", ARCHIVE_NAME_LEGAL_CHARACTER_REGEX), "_").trim();
    }
}

