/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact.handlers;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.build.artifact.ArtifactHandler;
import com.atlassian.bamboo.build.artifact.ArtifactHandlingUtils;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlerConfigurator;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlersService;
import com.atlassian.bamboo.exception.UnauthorisedException;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.descriptor.ArtifactHandlerModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.ArtifactHandlerModuleDescriptorImpl;
import com.atlassian.bamboo.plugin.descriptor.predicate.ConjunctionModuleDescriptorPredicate;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.utils.BambooValidationUtils;
import com.atlassian.bamboo.utils.MessageCollection;
import com.atlassian.bamboo.utils.MessageCollectionImpl;
import com.atlassian.bamboo.utils.OptionalNarrow;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import com.atlassian.plugin.predicate.ModuleOfClassPredicate;
import com.atlassian.plugin.webresource.TransformDescriptorToKey;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.acegisecurity.acls.Permission;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ArtifactHandlersServiceImpl
implements ArtifactHandlersService {
    private static final Logger log = Logger.getLogger(ArtifactHandlersServiceImpl.class);
    private static final BandanaContext BANDANA_CONTEXT = PlanAwareBandanaContext.GLOBAL_CONTEXT;
    public static final String BANDANA_KEY = "artifactHandlersConfiguration";
    public static final String ENABLED_FOR_SHARED = ArtifactHandlerModuleDescriptorImpl.SHARED_NON_SHARED_ONOFF_OPTION_NAME.get(Boolean.TRUE);
    public static final String ENABLED_FOR_NON_SHARED = ArtifactHandlerModuleDescriptorImpl.SHARED_NON_SHARED_ONOFF_OPTION_NAME.get(Boolean.FALSE);
    @Inject
    private BandanaManager bandanaManager;
    @Inject
    private PluginAccessor pluginAccessor;
    @Inject
    private BambooPermissionManager bambooPermissionManager;
    private java.util.function.Function<String, String> artifactHandlerPropertyToArtifactHandlerKeyMapper = input -> {
        for (ArtifactHandlerModuleDescriptor artifactHandlerModuleDescriptor : this.getArtifactHandlerModuleDescriptors()) {
            if (!ArtifactHandlingUtils.getConfigKey(artifactHandlerModuleDescriptor.getConfigurationPrefix(), ENABLED_FOR_SHARED).equals(input)) continue;
            return artifactHandlerModuleDescriptor.getCompleteKey();
        }
        log.info((Object)("can't transform '" + input + "' so return default server local storage"));
        return "com.atlassian.bamboo.plugin.artifact.handler.local:ServerLocalArtifactHandler";
    };

    @NotNull
    public Map<String, String> getConfiguration() {
        Map configuration = (Map)this.bandanaManager.getValue(BANDANA_CONTEXT, BANDANA_KEY);
        return configuration != null ? new HashMap<String, String>(configuration) : new HashMap();
    }

    @NotNull
    public Map<String, String> getRuntimeConfiguration() {
        final Map<String, String> configuration = this.getConfiguration();
        for (final ArtifactHandlerConfigurator configurator : this.getArtifactHandlerConfigurators()) {
            String errorMessage = configurator.getClass() + " has failed to decorate configuration for runtime";
            BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.Runnable(errorMessage){

                @Override
                public void run() {
                    configurator.decorateConfigurationForRuntime(configuration);
                }
            });
        }
        return configuration;
    }

    @NotNull
    public Set<String> getEnabledArtifactHandlerKeys() {
        return this.getEnabledArtifactHandlerKeys(this.getConfiguration());
    }

    @NotNull
    @VisibleForTesting
    Set<String> getEnabledArtifactHandlerKeys(@NotNull Map<String, String> handlersConfiguration) {
        Set iterator = Maps.filterEntries(handlersConfiguration, input -> ((String)input.getKey()).endsWith(ENABLED_FOR_SHARED) && Boolean.parseBoolean((String)input.getValue())).keySet();
        if (!Iterables.isEmpty(iterator)) {
            return BambooIterables.stream(iterator).map(this.artifactHandlerPropertyToArtifactHandlerKeyMapper).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return Sets.newHashSet((Object[])new String[]{"com.atlassian.bamboo.plugin.artifact.handler.remote:BambooRemoteArtifactHandler"});
    }

    public MessageCollection saveConfiguration(@NotNull Map<String, String> configuration) {
        MessageCollection feedback = this.beforeSaveConfigurationHandler(configuration);
        this.bandanaManager.setValue(BANDANA_CONTEXT, BANDANA_KEY, new HashMap<String, String>(configuration));
        return feedback;
    }

    public ErrorCollection validateConfiguration(final @NotNull Map<String, String> artifactHandlerConfigurationToSave) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        final Map<String, String> existingArtifactHandlersConfiguration = this.getConfiguration();
        Iterable<ArtifactHandlerModuleDescriptor> enabledArtifactHandlers = this.findEnabledArtifactHandler(artifactHandlerConfigurationToSave);
        for (ArtifactHandlerModuleDescriptor artifactHandler : enabledArtifactHandlers) {
            final ArtifactHandlerConfigurator configurator = artifactHandler.getConfigurator();
            String errorMessage = configurator.getClass() + " has failed to validate configuration";
            BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.Runnable(errorMessage, (ErrorCollection)errorCollection){
                final /* synthetic */ ErrorCollection val$errorCollection;
                {
                    this.val$errorCollection = errorCollection;
                    super(errorMessage);
                }

                @Override
                public void run() {
                    configurator.validateConfiguration(artifactHandlerConfigurationToSave, existingArtifactHandlersConfiguration, this.val$errorCollection);
                }
            });
        }
        return errorCollection;
    }

    @NotNull
    private MessageCollection beforeSaveConfigurationHandler(final @NotNull Map<String, String> artifactHandlersConfiguration) {
        final MessageCollectionImpl aggregatedFeedback = new MessageCollectionImpl();
        Iterable<ArtifactHandlerModuleDescriptor> enabledArtifactHandlers = this.findEnabledArtifactHandler(artifactHandlersConfiguration);
        final Map<String, String> existingArtifactHandlersConfiguration = this.getConfiguration();
        for (ArtifactHandlerModuleDescriptor artifactHandler : enabledArtifactHandlers) {
            final ArtifactHandlerConfigurator configurator = artifactHandler.getConfigurator();
            String errorMessage = configurator.getClass() + " has failed to validate configuration";
            BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.Runnable(errorMessage){

                @Override
                public void run() {
                    MessageCollection feedback = configurator.beforeSave(artifactHandlersConfiguration, existingArtifactHandlersConfiguration);
                    aggregatedFeedback.addMessages(feedback);
                }
            });
        }
        return aggregatedFeedback;
    }

    public Map<String, String> getEncryptedArtifactHandlerConfigurationWithoutPrefix(@NotNull String artifactHandlerKey) {
        this.failIfNoRestrictedAdminPermission();
        ArtifactHandlerModuleDescriptor descriptor = this.getArtifactHandlerModuleDescriptor(artifactHandlerKey);
        if (descriptor == null) {
            throw new IllegalArgumentException("Invalid artifact handler key: " + artifactHandlerKey);
        }
        ArtifactHandlerConfigurator configurator = descriptor.getConfigurator();
        HashMap<String, String> artifactHandlerConfig = new HashMap<String, String>();
        artifactHandlerConfig.putAll(configurator.getEncryptedArtifactHandlerConfiguration(this.getConfiguration()));
        return this.stripArtifactHandlerConfigurationPrefix(descriptor, artifactHandlerConfig);
    }

    public Map<String, String> getArtifactHandlerConfigurationWithoutPrefix(@NotNull String artifactHandlerKey) {
        this.failIfNoRestrictedAdminPermission();
        ArtifactHandlerModuleDescriptor descriptor = this.getArtifactHandlerModuleDescriptor(artifactHandlerKey);
        if (descriptor == null) {
            throw new IllegalArgumentException("Invalid artifact handler key: " + artifactHandlerKey);
        }
        ArtifactHandlerConfigurator configurator = descriptor.getConfigurator();
        HashMap<String, String> artifactHandlerConfig = new HashMap<String, String>();
        artifactHandlerConfig.putAll(configurator.getArtifactHandlerConfiguration(this.getConfiguration()));
        return this.stripArtifactHandlerConfigurationPrefix(descriptor, artifactHandlerConfig);
    }

    public void updateArtifactHandlerConfiguration(@NotNull String artifactHandlerKey, @NotNull Map<String, String> configuration) throws WebValidationException {
        HashMap<String, String> transformed;
        ArtifactHandlerConfigurator configurator;
        this.failIfNoRestrictedAdminPermission();
        Map<String, String> allConfiguration = this.getConfiguration();
        ArtifactHandlerModuleDescriptor descriptor = this.getArtifactHandlerModuleDescriptor(artifactHandlerKey);
        if (descriptor != null) {
            configurator = descriptor.getConfigurator();
            transformed = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : configuration.entrySet()) {
                if (entry.getKey().startsWith(descriptor.getConfigurationPrefix())) {
                    transformed.put(entry.getKey(), entry.getValue());
                    continue;
                }
                transformed.put(ArtifactHandlingUtils.getConfigKey(descriptor.getConfigurationPrefix(), entry.getKey()), entry.getValue());
            }
        } else {
            throw new IllegalArgumentException("Invalid artifact handler key: " + artifactHandlerKey);
        }
        HashMap<String, String> forValidation = new HashMap<String, String>(allConfiguration);
        forValidation.putAll(transformed);
        BambooValidationUtils.checkErrors(this.validateConfiguration(forValidation));
        Map artifactHandlerConfig = configurator.getArtifactHandlerConfiguration(transformed);
        allConfiguration.putAll(artifactHandlerConfig);
        this.saveConfiguration(allConfiguration);
    }

    @NotNull
    public List<ArtifactHandlerConfigurator> getArtifactHandlerConfigurators() {
        return (List)this.getArtifactHandlerModuleDescriptors().stream().map(ArtifactHandlerModuleDescriptor::getConfigurator).collect(CollectorsUtil.toImmutableList());
    }

    @NotNull
    public List<ArtifactHandlerModuleDescriptor> getArtifactHandlerModuleDescriptors() {
        return this.pluginAccessor.getModuleDescriptors(this.getArtifactHandlersPredicate()).stream().flatMap(OptionalNarrow.down(ArtifactHandlerModuleDescriptor.class)).collect(Collectors.toList());
    }

    private void failIfNoRestrictedAdminPermission() {
        if (!this.hasRestrictedAdminPermission()) {
            throw new UnauthorisedException("Restricted Admin Permission required");
        }
    }

    private Map<String, String> stripArtifactHandlerConfigurationPrefix(@NotNull ArtifactHandlerModuleDescriptor descriptor, @NotNull Map<String, String> artifactHandlerConfig) {
        HashMap<String, String> artifactHandlerConfigWithoutPrefix = new HashMap<String, String>();
        String prefix = descriptor.getConfigurationPrefix() + ":";
        for (Map.Entry<String, String> entry : artifactHandlerConfig.entrySet()) {
            String keyWithOutPrefix = entry.getKey().substring(prefix.length());
            artifactHandlerConfigWithoutPrefix.put(keyWithOutPrefix, entry.getValue());
        }
        return artifactHandlerConfigWithoutPrefix;
    }

    private boolean hasRestrictedAdminPermission() {
        return this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION);
    }

    private ArtifactHandlerModuleDescriptor getArtifactHandlerModuleDescriptor(@NotNull String artifactHandlerKey) {
        return this.getArtifactHandlerModuleDescriptors().stream().filter(input -> input.getKey().equals(artifactHandlerKey)).findFirst().orElse(null);
    }

    private Iterable<ArtifactHandlerModuleDescriptor> findEnabledArtifactHandler(@NotNull Map<String, String> artifactHandlerConfigurationToSave) {
        Set<String> enabledArtifactHandlerKeys = this.getEnabledArtifactHandlerKeys(artifactHandlerConfigurationToSave);
        return this.getArtifactHandlerModuleDescriptors().stream().filter(arg_0 -> ((Predicate)Predicates.compose(enabledArtifactHandlerKeys::contains, (Function)new TransformDescriptorToKey())).apply(arg_0)).collect(Collectors.toList());
    }

    @NotNull
    private ConjunctionModuleDescriptorPredicate<ArtifactHandler> getArtifactHandlersPredicate() {
        ConjunctionModuleDescriptorPredicate<ArtifactHandler> predicate = new ConjunctionModuleDescriptorPredicate<ArtifactHandler>();
        predicate.append((ModuleDescriptorPredicate<ArtifactHandler>)new ModuleOfClassPredicate(ArtifactHandler.class));
        predicate.append((ModuleDescriptorPredicate<ArtifactHandler>)new EnabledModulePredicate());
        return predicate;
    }
}

