/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.configuration;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.spring.container.ContainerManager;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class ConcurrentBuildConfigForPlan
implements Serializable {
    private static final Logger log = Logger.getLogger(ConcurrentBuildConfigForPlan.class);
    private boolean defaultOverridden;
    private int numberOfConcurrentBuilds;
    transient AdministrationConfigurationAccessor administrationConfigurationAccessor;

    public ConcurrentBuildConfigForPlan(boolean overrideDefault, int numberOfConcurrentBuilds) {
        this.defaultOverridden = overrideDefault;
        this.numberOfConcurrentBuilds = numberOfConcurrentBuilds;
    }

    private AdministrationConfigurationAccessor getAdministrationConfigurationAccessor() {
        if (this.administrationConfigurationAccessor == null) {
            this.administrationConfigurationAccessor = (AdministrationConfigurationAccessor)ContainerManager.getComponent((String)"administrationConfigurationAccessor");
        }
        return this.administrationConfigurationAccessor;
    }

    private boolean concurrentBuildsEnabled() {
        return this.getAdministrationConfigurationAccessor().getAdministrationConfiguration().getConcurrentBuildConfig().isEnabled();
    }

    private int getDefaultNumberOfConcurrentBuilds() {
        return this.getAdministrationConfigurationAccessor().getAdministrationConfiguration().getConcurrentBuildConfig().getNumberConcurrentBuilds();
    }

    public int getEffectiveNumberOfConcurrentBuilds() {
        if (!this.concurrentBuildsEnabled()) {
            return 1;
        }
        if (this.defaultOverridden) {
            return this.numberOfConcurrentBuilds;
        }
        return this.getDefaultNumberOfConcurrentBuilds();
    }

    public boolean isDefaultOverridden() {
        return this.defaultOverridden;
    }

    public void setDefaultOverridden(boolean defaultOverridden) {
        this.defaultOverridden = defaultOverridden;
    }

    public int getNumberOfConcurrentBuilds() {
        return this.numberOfConcurrentBuilds;
    }

    public void setNumberOfConcurrentBuilds(int numberOfConcurrentBuilds) {
        this.numberOfConcurrentBuilds = numberOfConcurrentBuilds;
    }
}

