/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.configuration;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.configuration.ConcurrentBuildConfigForPlan;
import com.atlassian.bamboo.plugin.module.ext.CustomBuildDefinitionTransformer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ConcurrentBuildsConfigurationTransformer
implements CustomBuildDefinitionTransformer {
    public void transformBuildDefinition(@NotNull Map<String, Object> configObjects, @NotNull Map<String, String> configParameters, @NotNull BuildDefinition buildDefinition) {
        if (configParameters.containsKey("custom.concurrentBuilds.numberOfConcurrentBuilds")) {
            boolean overrideDefault = Boolean.parseBoolean(configParameters.get("custom.concurrentBuilds.overrideNumberOfConcurrentBuilds"));
            int numberOfConcurrentBuilds = overrideDefault ? Integer.parseInt(configParameters.get("custom.concurrentBuilds.numberOfConcurrentBuilds")) : 1;
            configObjects.put("custom.concurrentBuilds.planLevelConfig", new ConcurrentBuildConfigForPlan(overrideDefault, numberOfConcurrentBuilds));
        } else {
            configObjects.put("custom.concurrentBuilds.planLevelConfig", new ConcurrentBuildConfigForPlan(false, 0));
        }
    }
}

