/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.configuration;

import com.atlassian.bamboo.build.configuration.ConcurrentBuildConfigForPlan;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.plan.configuration.MiscellaneousPlanConfigurationPlugin;
import com.atlassian.bamboo.specs.api.builders.plan.configuration.ConcurrentBuilds;
import com.atlassian.bamboo.specs.api.model.plan.configuration.ConcurrentBuildsProperties;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BaseBuildConfigurationAwarePlugin;
import com.atlassian.bamboo.v2.build.ImportExportAwarePlugin;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.collect.ImmutableSet;
import com.opensymphony.xwork2.TextProvider;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ConcurrentBuildsPlanConfigurationPlugin
extends BaseBuildConfigurationAwarePlugin
implements MiscellaneousPlanConfigurationPlugin,
ImportExportAwarePlugin<ConcurrentBuilds, ConcurrentBuildsProperties> {
    public static final String CONCURRENT_BUILD_OBJECT_KEY = "custom.concurrentBuilds.planLevelConfig";
    public static final String NUMBER_CONCURRENT_BUILDS_OVERRIDE = "custom.concurrentBuilds.overrideNumberOfConcurrentBuilds";
    public static final String NUMBER_CONCURRENT_BUILDS = "custom.concurrentBuilds.numberOfConcurrentBuilds";
    private static final Set<String> ALL_CONFIGURATION_FIELDS = ImmutableSet.of((Object)"custom.concurrentBuilds.overrideNumberOfConcurrentBuilds", (Object)"custom.concurrentBuilds.numberOfConcurrentBuilds");
    static final int DEFAULT_NUMBER_CONCURRENT_BUILDS = 1;
    private static final Logger log = Logger.getLogger(ConcurrentBuildsPlanConfigurationPlugin.class);
    private TextProvider textProvider;
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;

    private boolean concurrentBuildsEnabled() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration().getConcurrentBuildConfig().isEnabled();
    }

    private int getDefaultNumberOfConcurrentBuilds() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration().getConcurrentBuildConfig().getNumberConcurrentBuilds();
    }

    @Override
    protected void populateContextForView(@NotNull Map<String, Object> context, @NotNull Plan plan) {
        super.populateContextForView(context, plan);
        context.put("planLevelConcurrentBuildConfig", PlanHelper.getConfigObject((ImmutablePlan)plan, CONCURRENT_BUILD_OBJECT_KEY, ConcurrentBuildConfigForPlan.class));
    }

    @Override
    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (this.concurrentBuildsEnabled() && buildConfiguration.getBoolean(NUMBER_CONCURRENT_BUILDS_OVERRIDE)) {
            String ncbString = buildConfiguration.getString(NUMBER_CONCURRENT_BUILDS);
            try {
                int ncbInt = Integer.parseInt(ncbString);
                if (ncbInt <= 0) {
                    errorCollection.addError(NUMBER_CONCURRENT_BUILDS, this.textProvider.getText("build.concurrent.maxnumber.error"));
                }
            }
            catch (NumberFormatException e) {
                errorCollection.addError(NUMBER_CONCURRENT_BUILDS, this.textProvider.getText("build.concurrent.maxnumber.error"));
            }
        }
        return errorCollection;
    }

    public boolean isApplicableTo(@NotNull ImmutablePlan plan) {
        return plan instanceof ImmutableTopLevelPlan;
    }

    @NotNull
    public ConcurrentBuilds toSpecsEntity(@NotNull HierarchicalConfiguration buildConfiguration) {
        boolean overrideDefault = buildConfiguration.getBoolean(NUMBER_CONCURRENT_BUILDS_OVERRIDE);
        ConcurrentBuilds concurrent = new ConcurrentBuilds().useSystemWideDefault(!overrideDefault);
        if (overrideDefault) {
            concurrent.maximumNumberOfConcurrentBuilds(buildConfiguration.getInt(NUMBER_CONCURRENT_BUILDS, 1));
        }
        return concurrent;
    }

    public void addToBuildConfiguration(@NotNull ConcurrentBuildsProperties specsProperties, @NotNull HierarchicalConfiguration buildConfiguration) {
        buildConfiguration.setProperty(NUMBER_CONCURRENT_BUILDS_OVERRIDE, (Object)(!specsProperties.isUseSystemWideDefault() ? 1 : 0));
        int numberOfConcurrentBuilds = specsProperties.isUseSystemWideDefault() ? this.getDefaultNumberOfConcurrentBuilds() : specsProperties.getMaximumNumberOfConcurrentBuilds();
        buildConfiguration.setProperty(NUMBER_CONCURRENT_BUILDS, (Object)numberOfConcurrentBuilds);
    }

    @NotNull
    public Set<String> getConfigurationKeys() {
        return ALL_CONFIGURATION_FIELDS;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }
}

