/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.configuration;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.event.BuildConfigurationUpdatedEvent;
import com.atlassian.bamboo.event.PlanSuspensionRequestedEvent;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;

public class SuspendBuildEventListener {
    private final PlanManager planManager;
    private final AuditLogService auditLogService;
    private final EventPublisher eventPublisher;

    public SuspendBuildEventListener(PlanManager planManager, AuditLogService auditLogService, EventPublisher eventPublisher) {
        this.planManager = planManager;
        this.auditLogService = auditLogService;
        this.eventPublisher = eventPublisher;
    }

    @EventListener
    public void handleEvent(PlanSuspensionRequestedEvent event) {
        PlanKey planKey = event.getPlanKey();
        this.planManager.setPlanSuspendedState(planKey, true);
        this.auditLogService.log(event.getMessage(), (Key)planKey, AuditLogEntityType.PLAN);
        this.eventPublisher.publish((Object)new BuildConfigurationUpdatedEvent((Object)this, planKey));
    }
}

