/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.context;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.bandana.BambooBandanaContext;
import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.context.BuildContextBuilder;
import com.atlassian.bamboo.chains.ChainStorageTag;
import com.atlassian.bamboo.credentials.Credentials;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsConfigFunctions;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.CredentialsDependerFunctions;
import com.atlassian.bamboo.fileserver.StorageTagUtils;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.artifact.ArtifactContext;
import com.atlassian.bamboo.plan.artifact.ArtifactContextImpl;
import com.atlassian.bamboo.plan.branch.BranchIntegrationService;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.repository.RepositoryDefinitionImpl;
import com.atlassian.bamboo.security.SecureTokenService;
import com.atlassian.bamboo.storage.location.StorageTagService;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildChangesImpl;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildContextImpl;
import com.atlassian.bamboo.v2.build.BuildIdentifier;
import com.atlassian.bamboo.v2.build.BuildIdentifierImpl;
import com.atlassian.bamboo.v2.build.BuildKey;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildContextBuilderImpl
implements BuildContextBuilder {
    private final BranchIntegrationService branchIntegrationService;
    private final VariableDefinitionManager variableDefinitionManager;
    @NotNull
    private final CredentialsAccessor credentialsAccessor;
    private final VcsRepositoryManager vcsRepositoryManager;
    private final SecureTokenService secureTokenService;
    @NotNull
    private final StorageTagService storageTagService;
    private BuildIdentifier identifier;
    private TriggerReason triggerReason;
    private BuildDefinition buildDefinition;
    @Nullable
    private BuildChanges buildChanges;
    private BuildContext parentBuildContext;
    @Nullable
    private ArtifactContext artifactContext;
    @Nullable
    private VariableContext variableContext;
    @Nullable
    private Map<String, String> customBuildData;
    @Nullable
    private Map<Long, RepositoryDefinition> repositoryDefinitionMap;
    @Nullable
    private Map<Long, PlanRepositoryDefinition> planRepositoryDefinitionMap;
    private Set<Long> relevantRepositoryIds;
    private Map<Long, String> checkoutLocation;
    private boolean isBranch;
    private boolean isOnceOff;
    private boolean isCustomBuild;
    private BambooBandanaContext bandanaContext;
    private ImmutablePlan plan;
    private int buildNumber;

    public BuildContextBuilderImpl(@NotNull BranchIntegrationService branchIntegrationService, @NotNull VariableDefinitionManager variableDefinitionManager, @NotNull CredentialsAccessor credentialsAccessor, @NotNull StorageTagService storageTagService, @NotNull VcsRepositoryManager vcsRepositoryManager, @NotNull SecureTokenService secureTokenService) {
        this.branchIntegrationService = branchIntegrationService;
        this.variableDefinitionManager = variableDefinitionManager;
        this.credentialsAccessor = credentialsAccessor;
        this.storageTagService = storageTagService;
        this.vcsRepositoryManager = vcsRepositoryManager;
        this.secureTokenService = secureTokenService;
    }

    @NotNull
    public BuildContext build() {
        if (this.plan != null) {
            if (this.variableContext == null) {
                this.variableContext = this.variableDefinitionManager.createVariableContextBuilder().addGlobalVariables().addPlanVariables(this.plan).buildContext();
            }
            if (this.planRepositoryDefinitionMap == null) {
                if (this.repositoryDefinitionMap == null) {
                    this.planRepositoryDefinitionMap = this.branchIntegrationService.getPlanRepositoryDefinitionMap(this.plan);
                } else {
                    this.planRepositoryDefinitionMap = new HashMap<Long, PlanRepositoryDefinition>();
                    for (Map.Entry<Long, RepositoryDefinition> entry : this.repositoryDefinitionMap.entrySet()) {
                        RepositoryDefinitionImpl rdFromVcsData = (RepositoryDefinitionImpl)Narrow.downTo((Object)entry.getValue(), RepositoryDefinitionImpl.class);
                        Preconditions.checkState((rdFromVcsData != null ? 1 : 0) != 0, (Object)"Unexpected source of repository data.");
                        this.planRepositoryDefinitionMap.put(entry.getKey(), rdFromVcsData.getOriginalData());
                    }
                }
            }
            if (this.identifier == null) {
                this.identifier = new BuildIdentifierImpl(this.plan.getDatabaseId().orElse(null), this.plan.getMasterIdIfExists().orElse(null), this.plan.getKey(), this.plan.getProject().getName(), this.plan.getName(), this.plan.getBuildName(), this.buildNumber);
            }
            if (this.bandanaContext == null) {
                this.bandanaContext = PlanAwareBandanaContext.forPlan(this.plan);
            }
        }
        this.buildChanges = this.buildChanges != null ? this.buildChanges : new BuildChangesImpl();
        this.planRepositoryDefinitionMap = this.planRepositoryDefinitionMap != null ? this.planRepositoryDefinitionMap : new LinkedHashMap<Long, PlanRepositoryDefinition>();
        this.relevantRepositoryIds = this.relevantRepositoryIds != null ? this.relevantRepositoryIds : new HashSet<Long>();
        this.checkoutLocation = this.checkoutLocation != null ? this.checkoutLocation : new LinkedHashMap<Long, String>();
        BuildKey buildKey = this.parentBuildContext != null ? this.parentBuildContext.getBuildKey() : new BuildKey();
        this.artifactContext = this.artifactContext != null ? this.artifactContext : new ArtifactContextImpl(this.secureTokenService.generate((Key)buildKey), Collections.emptySet(), Collections.emptySet(), Optional.empty(), Collections.emptyMap());
        ImmutableSet necessarySharedCredentials = ImmutableSet.builder().addAll(Credentials.getAllSharedCredentials(this.planRepositoryDefinitionMap.values(), this.vcsRepositoryManager, this.credentialsAccessor)).addAll(Credentials.getAllSharedCredentials(this.buildDefinition.getTaskDefinitions(), this.credentialsAccessor, CredentialsDependerFunctions::taskDefinitionToCredentialsDepender, CredentialsConfigFunctions::taskDefinitionToConfigMap)).build();
        Map<PlanKey, ChainStorageTag> necessaryStorageTags = this.gatherStorageTags();
        return new BuildContextImpl(this.identifier, this.triggerReason, this.buildDefinition, this.buildChanges, this.parentBuildContext, this.artifactContext, this.variableContext, this.customBuildData, this.planRepositoryDefinitionMap, this.relevantRepositoryIds, this.checkoutLocation, this.isBranch, this.isOnceOff, this.isCustomBuild, this.bandanaContext, (Iterable<CredentialsData>)necessarySharedCredentials, necessaryStorageTags, buildKey);
    }

    private Map<PlanKey, ChainStorageTag> gatherStorageTags() {
        if (this.buildDefinition.getTaskDefinitions() != null && !this.buildDefinition.getTaskDefinitions().isEmpty()) {
            return StorageTagUtils.gatherNeededStorageTags(this.storageTagService, this.buildDefinition.getTaskDefinitions(), this.identifier);
        }
        return ImmutableMap.of();
    }

    @NotNull
    public BuildContextBuilder identifier(@NotNull BuildIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    @NotNull
    public BuildContextBuilder plan(@NotNull ImmutablePlan buildPlan) {
        this.plan = buildPlan;
        this.isBranch = buildPlan.hasMaster();
        return this;
    }

    @NotNull
    public BuildContextBuilder buildNumber(int buildNumber) {
        this.buildNumber = buildNumber;
        return this;
    }

    @NotNull
    public BuildContextBuilder parentBuildContext(@NotNull BuildContext parentContext) {
        this.parentBuildContext = parentContext;
        this.buildNumber = parentContext.getBuildNumber();
        this.isBranch = parentContext.isBranch();
        this.isOnceOff = parentContext.isOnceOff();
        this.isCustomBuild = parentContext.isCustomBuild();
        return this;
    }

    @NotNull
    public BuildContextBuilder triggerReason(TriggerReason triggerReason) {
        this.triggerReason = triggerReason;
        return this;
    }

    @NotNull
    public BuildContextBuilder buildDefinition(BuildDefinition buildDefinition) {
        this.buildDefinition = buildDefinition;
        return this;
    }

    @NotNull
    public BuildContextBuilder artifactContext(ArtifactContext artifactContext) {
        this.artifactContext = artifactContext;
        return this;
    }

    @NotNull
    public BuildContextBuilder variableContext(VariableContext variableContext) {
        this.variableContext = variableContext;
        return this;
    }

    @NotNull
    public BuildContextBuilder planRepositoryDefinitionMap(Map<Long, PlanRepositoryDefinition> planRepositoryDefinitionMap) {
        this.planRepositoryDefinitionMap = planRepositoryDefinitionMap;
        return this;
    }

    @NotNull
    public BuildContextBuilder relevantRepositoryIds(Set<Long> relevantRepositoryIds) {
        this.relevantRepositoryIds = relevantRepositoryIds;
        return this;
    }

    @NotNull
    public BuildContextBuilder relevantRepositories(@NotNull Set<PlanRepositoryDefinition> relevantRepositories) {
        this.relevantRepositoryIds = new HashSet<Long>();
        for (PlanRepositoryDefinition relevantRepository : relevantRepositories) {
            this.relevantRepositoryIds.add(relevantRepository.getId());
        }
        return this;
    }

    @NotNull
    public BuildContextBuilder checkoutLocation(Map<Long, String> checkoutLocation) {
        this.checkoutLocation = checkoutLocation;
        return this;
    }

    @NotNull
    public BuildContextBuilder customBuildData(Map<String, String> customBuildData) {
        this.customBuildData = customBuildData;
        return this;
    }

    @NotNull
    public BuildContextBuilder isBranch(boolean isBranch) {
        this.isBranch = isBranch;
        return this;
    }

    @NotNull
    public BuildContextBuilder isOnceOff(boolean isOnceOff) {
        this.isOnceOff = isOnceOff;
        return this;
    }

    @NotNull
    public BuildContextBuilder isCustomBuild(boolean isCustomBuild) {
        this.isCustomBuild = isCustomBuild;
        return this;
    }

    @NotNull
    public BuildContextBuilder bandanaContext(BambooBandanaContext bandanaContext) {
        this.bandanaContext = bandanaContext;
        return this;
    }

    @NotNull
    public BuildContextBuilder buildChanges(BuildChanges buildChanges) {
        this.buildChanges = buildChanges;
        return this;
    }

    @NotNull
    public BuildContextBuilder copyOf(@NotNull BuildContext other) {
        this.identifier = other;
        this.triggerReason = other.getTriggerReason();
        this.buildDefinition = other.getBuildDefinition();
        this.buildChanges = other.getBuildChanges();
        this.parentBuildContext = other.getParentBuildContext();
        this.artifactContext = other.getArtifactContext();
        this.variableContext = other.getVariableContext();
        this.customBuildData = other.getBuildResult().getCustomBuildData();
        this.repositoryDefinitionMap = other.getRepositoryDefinitionMap();
        this.planRepositoryDefinitionMap = other.getVcsRepositoryMap();
        this.relevantRepositoryIds = other.getRelevantRepositoryIds();
        this.checkoutLocation = other.getCheckoutLocation();
        this.isBranch = other.isBranch();
        this.isOnceOff = other.isOnceOff();
        this.isCustomBuild = other.isCustomBuild();
        this.bandanaContext = other.getBandanaContext();
        return this;
    }
}

