/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.creation;

import com.atlassian.bamboo.build.BuildTriggerCondition;
import com.atlassian.bamboo.build.creation.PlanConfigHelper;
import com.atlassian.bamboo.build.strategy.BuildStrategyManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.utils.ErrorCollectionUtils;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.opensymphony.xwork.ValidationAware;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuildTriggerConditionConfigHelper
implements PlanConfigHelper {
    private static final Logger log = Logger.getLogger(BuildTriggerConditionConfigHelper.class);
    private final BuildStrategyManager buildStrategyManager;

    public BuildTriggerConditionConfigHelper(BuildStrategyManager buildStrategyManager) {
        this.buildStrategyManager = buildStrategyManager;
    }

    public void addDefaultsToConfig(@NotNull BuildConfiguration buildConfiguration) {
        List conditions = this.buildStrategyManager.getBuildTriggerConditions();
        for (BuildTriggerCondition condition : conditions) {
            condition.addDefaultValues(buildConfiguration);
        }
    }

    public void validateConfig(@NotNull com.atlassian.struts.ValidationAware validationAware, @NotNull BuildConfiguration buildConfiguration) {
        List conditions = this.buildStrategyManager.getBuildTriggerConditions();
        for (BuildTriggerCondition condition : conditions) {
            ErrorCollectionUtils.addErrorCollection(validationAware, condition.validate(buildConfiguration));
        }
    }

    public void validateConfig(@NotNull ValidationAware validationAware, @NotNull BuildConfiguration buildConfiguration) {
        this.validateConfig((com.atlassian.struts.ValidationAware)validationAware, buildConfiguration);
    }

    public void cleanConfig(@NotNull BuildConfiguration buildConfiguration) {
    }

    public void performPostActionsOnConfig(@NotNull BuildConfiguration buildConfiguration, @NotNull ImmutablePlan plan) {
    }

    public void prepareConfig(@NotNull BuildConfiguration buildConfiguration) {
        List conditions = this.buildStrategyManager.getBuildTriggerConditions();
        for (BuildTriggerCondition condition : conditions) {
            condition.prepareConfigObject(buildConfiguration);
        }
    }
}

