/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.creation;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildNumberGeneratorService;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.PlanCreationDeniedException;
import com.atlassian.bamboo.build.PlanCreationException;
import com.atlassian.bamboo.build.creation.ChainBranchCreationService;
import com.atlassian.bamboo.build.creation.ChainParamMapHelper;
import com.atlassian.bamboo.build.creation.JobCreationService;
import com.atlassian.bamboo.build.creation.PlanCreationBean;
import com.atlassian.bamboo.build.creation.PlanCreationService;
import com.atlassian.bamboo.build.creation.PlanCreationTemplate;
import com.atlassian.bamboo.build.creation.PlanValidationService;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.branches.BranchNotificationStrategy;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.core.ScopedExclusionService;
import com.atlassian.bamboo.event.ChainCreatedEvent;
import com.atlassian.bamboo.fieldvalue.BuildDefinitionConverter;
import com.atlassian.bamboo.jira.issuelink.JiraBranchLinkingService;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.NotificationSetImpl;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.IncorrectPlanTypeException;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.branch.BambooVcsBranch;
import com.atlassian.bamboo.plan.branch.BambooVcsBranchImpl;
import com.atlassian.bamboo.plan.branch.BranchCommitInformationManager;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfiguration;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfigurationImpl;
import com.atlassian.bamboo.plan.branch.BranchMonitoringConfiguration;
import com.atlassian.bamboo.plan.branch.BranchTriggeringOption;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.branch.ChainBranchImpl;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.plan.branch.VcsBranchManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryService;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.repository.PlanRepositoryLink;
import com.atlassian.bamboo.repository.PlanRepositoryLinkImpl;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.resultsummary.tests.QuarantineStatistics;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseImpl;
import com.atlassian.bamboo.resultsummary.tests.TestClass;
import com.atlassian.bamboo.resultsummary.tests.TestClassImpl;
import com.atlassian.bamboo.resultsummary.tests.TestQuarantineManager;
import com.atlassian.bamboo.resultsummary.tests.TestsManager;
import com.atlassian.bamboo.schedule.PlanScheduler;
import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.task.TaskConfigurationService;
import com.atlassian.bamboo.trigger.TriggerConfigurationService;
import com.atlassian.bamboo.trigger.TriggerConfigurationUtils;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.struts.ValidationAware;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.atlassian.util.concurrent.Lazy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.acegisecurity.acls.MutableAcl;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainBranchCreationServiceImpl
extends PlanCreationTemplate
implements ChainBranchCreationService {
    private static final Logger log = Logger.getLogger(ChainBranchCreationServiceImpl.class);
    private final JobCreationService jobCreationService;
    private final ScopedExclusionService exclusionService;
    private final ChainBranchManager chainBranchManager;
    private final JiraBranchLinkingService jiraBranchLinkingService;
    private final TestQuarantineManager testQuarantineManager;
    private final TestsManager testsManager;
    private final PlanVcsRevisionHistoryService planVcsRevisionHistoryService;

    public ChainBranchCreationServiceImpl(PlanManager planManager, ProjectManager projectManager, BambooAclUpdateHelper aclUpdateHelper, BambooAuthenticationContext authenticationContext, BambooLicenseManager bambooLicenseManager, HibernateMutableAclService aclService, PlanScheduler planScheduler, EventPublisher eventPublisher, PlanValidationService planValidationService, AuditLogService auditLogService, BuildDefinitionConverter buildDefinitionConverter, NotificationManager notificationManager, JobCreationService jobCreationService, ArtifactDefinitionManager artifactDefinitionManager, ArtifactSubscriptionManager artifactSubscriptionManager, VariableDefinitionManager variableDefinitionManager, RepositoryDefinitionManager repositoryDefinitionManager, TaskConfigurationService taskConfigurationService, ScopedExclusionService exclusionService, ChainBranchManager chainBranchManager, BranchCommitInformationManager branchCommitInformationManager, VcsBranchManager vcsBranchManager, TriggerConfigurationService triggerConfigurationService, BuildNumberGeneratorService buildNumberGeneratorService, JiraBranchLinkingService jiraBranchLinkingService, TestQuarantineManager testQuarantineManager, TestsManager testsManager, PlanVcsRevisionHistoryService planVcsRevisionHistoryService) {
        super(planManager, projectManager, aclUpdateHelper, authenticationContext, bambooLicenseManager, aclService, planScheduler, eventPublisher, planValidationService, auditLogService, buildDefinitionConverter, artifactDefinitionManager, artifactSubscriptionManager, variableDefinitionManager, repositoryDefinitionManager, taskConfigurationService, notificationManager, branchCommitInformationManager, vcsBranchManager, triggerConfigurationService, buildNumberGeneratorService);
        this.jobCreationService = jobCreationService;
        this.exclusionService = exclusionService;
        this.chainBranchManager = chainBranchManager;
        this.jiraBranchLinkingService = jiraBranchLinkingService;
        this.testQuarantineManager = testQuarantineManager;
        this.testsManager = testsManager;
        this.planVcsRevisionHistoryService = planVcsRevisionHistoryService;
    }

    public void validatePlan(ValidationAware validationAware, BuildConfiguration buildConfiguration, ActionParametersMap params) {
        String branchName = ChainParamMapHelper.getBranchName(params);
        String branchDescription = params.getString("branchDescription", "").trim();
        this.planValidationService.validateName(validationAware, "branchName", "chain", branchName);
        this.planValidationService.validateDescription(validationAware, "branchDescription", branchDescription);
        if (!validationAware.hasErrors()) {
            String planKeyToClone = ChainParamMapHelper.getPlanKeyToClone(params);
            if (StringUtils.isBlank((CharSequence)planKeyToClone)) {
                validationAware.addActionMessage("Can not create branch, no Master Plan Specified");
                return;
            }
            Plan planToClone = this.planManager.getPlanByKey(planKeyToClone);
            if (planToClone == null) {
                validationAware.addFieldError("planKeyToClone", "Can not create branch, could not find Master plan with key " + planKeyToClone);
                return;
            }
            Chain chainToClone = (Chain)Narrow.to((Object)planToClone, Chain.class);
            if (chainToClone == null) {
                validationAware.addFieldError("planKeyToClone", "You cannot clone a plan of type " + planToClone.getPlanType() + " to plan");
                return;
            }
            this.planValidationService.validateNewPlanBranchForMaster(validationAware, (ImmutableChain)chainToClone, branchName);
        }
    }

    public ChainBranch getNewInstance() {
        ChainBranchImpl branchBeingCreated = new ChainBranchImpl();
        ContainerManager.autowireComponent((Object)branchBeingCreated);
        return branchBeingCreated;
    }

    @Override
    protected MutableAcl getDefaultPermissionsForPlan(boolean accessForAllUsers) {
        return null;
    }

    public BuildConfiguration getBuildConfigurationWithDefaults() {
        return new BuildConfiguration();
    }

    @Override
    protected boolean performCloneIfRequired(@NotNull BuildConfiguration buildConfiguration, @NotNull PlanCreationBean planCreationBean, @NotNull ActionParametersMap params) throws PlanCreationDeniedException {
        String planKeyToClone = ChainParamMapHelper.getPlanKeyToClone(params);
        String planOwner = this.authenticationContext.getUserName();
        Plan newPlan = planCreationBean.getPlanBeingCreated();
        Plan planToClone = this.planManager.getPlanByKey(planKeyToClone);
        this.validateThrowingPlanCreationException(newPlan != null, "An internal error occurred, the plan you are creating went missing");
        this.validateThrowingPlanCreationException(planToClone != null && planOwner != null, "Unable to find plan to clone (" + planKeyToClone + ")");
        ChainBranchImpl newBranch = (ChainBranchImpl)Narrow.to((Object)newPlan, ChainBranchImpl.class);
        this.validateThrowingPlanCreationException(newBranch != null, "An internal error occurred, cloning is not available for plan type: " + newPlan.getPlanType() + ".");
        Chain chainToClone = (Chain)Narrow.to((Object)planToClone, Chain.class);
        this.validateThrowingPlanCreationException(chainToClone != null, "An internal error occurred, can only create branches of : " + newPlan.getPlanType() + ".");
        this.prepareRepositoriesForClone(planCreationBean, params, newPlan, planToClone);
        newBranch.setMaster((Plan)chainToClone);
        planCreationBean.setConfigurationBeingEdited(buildConfiguration);
        NotificationSetImpl notificationSet = new NotificationSetImpl();
        newBranch.setNotificationSet(notificationSet);
        NotificationRule committerNotificationRule = this.notificationManager.createNotificationRule("com.atlassian.bamboo.plugin.system.notifications:chainCompleted.failedChains", "", "", "com.atlassian.bamboo.plugin.system.notifications:recipient.committer");
        notificationSet.addNotification(committerNotificationRule);
        NotificationRule watcherNotificationRule = this.notificationManager.createNotificationRule("com.atlassian.bamboo.plugin.system.notifications:chainCompleted.failedChains", "", "", "com.atlassian.bamboo.plugin.system.notifications:recipient.watcher");
        notificationSet.addNotification(watcherNotificationRule);
        BranchMonitoringConfiguration bmc = chainToClone.getBuildDefinition().getBranchMonitoringConfiguration();
        BranchNotificationStrategy bns = bmc.getDefaultBranchNotificationStrategy();
        buildConfiguration.addProperty("branchConfiguration.notificationStrategy", (Object)bns.getKey());
        if (params.getBoolean("EXPIRY_OFF")) {
            buildConfiguration.addProperty("branchConfiguration.cleanup.disabled", (Object)true);
        }
        buildConfiguration.addProperty("branchConfiguration.workflow", (Object)params.getString("planBranchWorkflow", PlanBranchWorkflow.defaultValue().getKey()));
        BranchTriggeringOption branchTriggeringOption = bmc.getBranchTriggeringOption();
        if (branchTriggeringOption == BranchTriggeringOption.MANUAL_ONLY) {
            this.setBranchTriggerToManual(buildConfiguration);
        } else if (branchTriggeringOption == BranchTriggeringOption.CUSTOM) {
            TriggerDefinition triggerDefinition = bmc.getDefaultTrigger();
            if (triggerDefinition != null) {
                TriggerConfigurationUtils.addTriggerDefinitionsToConfig(Collections.singletonList(triggerDefinition), (HierarchicalConfiguration)buildConfiguration);
            } else {
                log.warn((Object)"Custom trigger selected for new branch but none defined, setting trigger to manual");
                this.setBranchTriggerToManual(buildConfiguration);
            }
        }
        if (!BranchIntegrationConfigurationImpl.hasConfiguration(buildConfiguration)) {
            BranchIntegrationConfiguration bic = chainToClone.getBuildDefinition().getBranchMonitoringConfiguration().getDefaultBranchIntegrationConfiguration();
            buildConfiguration.addConfiguration((AbstractConfiguration)new BranchIntegrationConfigurationImpl(bic, false).toConfiguration());
        }
        return true;
    }

    private void setBranchTriggerToManual(@NotNull BuildConfiguration buildConfiguration) {
        TriggerConfigurationUtils.addTriggerDefinitionsToConfig(Collections.emptyList(), (HierarchicalConfiguration)buildConfiguration);
    }

    private void prepareRepositoriesForClone(PlanCreationBean planCreationBean, ActionParametersMap params, Plan newPlan, Plan planToClone) {
        RepositoryDataEntity overridingRepository = (RepositoryDataEntity)params.get((Object)"overridingRepositoryEntity");
        if (overridingRepository != null) {
            PlanRepositoryDefinition defaultRepository = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)planToClone);
            this.validateThrowingPlanCreationException(defaultRepository != null, "No repository could be found on the master definition to override, but yet we have an overriding repository definition on the branch");
            this.validateThrowingPlanCreationException(defaultRepository.getPluginKey().equals(overridingRepository.getPluginKey()), "Overriding repository definition must be the same type as the master's default repository");
            PlanRepositoryLinkImpl repositoryLink = new PlanRepositoryLinkImpl(newPlan, overridingRepository, defaultRepository.getPosition());
            planCreationBean.setPlanRepositoriesBeingCreated((List)Lists.newArrayList((Object[])new PlanRepositoryLink[]{repositoryLink}));
            planCreationBean.setRepositoriesBeingCreated((Map)ImmutableMap.of((Object)-1L, (Object)overridingRepository));
            PartialVcsRepositoryData branchRepository = (PartialVcsRepositoryData)params.get((Object)"overridingRepository");
            if (branchRepository.getCompleteData().getBranch() != null) {
                planCreationBean.setVcsBranchesBeingCreated((List)Lists.newArrayList((Object[])new BambooVcsBranch[]{new BambooVcsBranchImpl((Chain)planToClone, branchRepository.getBranch().getVcsBranch())}));
            }
        }
    }

    @Override
    protected void prepareBuildConfiguration(@NotNull BuildConfiguration buildConfiguration, @NotNull Plan plan, @NotNull PlanCreationBean planCreationBean) {
    }

    @Override
    public void cleanBuildConfiguration(@NotNull BuildConfiguration buildConfiguration, @NotNull Plan plan) {
        buildConfiguration.clearTree("builder");
        buildConfiguration.clearTree("artifacts");
        buildConfiguration.clearTree("branches");
        ChainBranchCreationServiceImpl.cleanBuildConfiguration(buildConfiguration);
        ChainBranch chain = (ChainBranch)Narrow.to((Object)plan, ChainBranch.class);
        if (chain == null) {
            throw new IllegalStateException("Trying to perform build related methods on a " + plan.getClass());
        }
    }

    @Override
    protected void setFullPlanKey(@NotNull Plan plan) {
        plan.setPlanKey(PlanKeys.getPlanKey((String)plan.getProject().getKey(), (String)plan.getBuildKey()));
    }

    @Override
    protected void saveAndUpdateParents(@NotNull PlanCreationBean planCreationBean) {
    }

    @Override
    protected void performPostCreateAction(@NotNull Plan plan) {
        this.planVcsRevisionHistoryService.clearRevisionHistoryForPlan(plan.getPlanKey());
    }

    private void cloneQuarantinedTestsFromMaster(PlanKey planKey) {
        ChainBranch newBranch = (ChainBranch)Preconditions.checkNotNull((Object)this.planManager.getPlanByKey(planKey, ChainBranch.class), (String)"Can't clone quarantined tests for new branch '%s' as it doesn't exist.", (Object[])new Object[]{planKey});
        Chain master = (Chain)Preconditions.checkNotNull((Object)this.planManager.getPlanById(newBranch.getMasterId(), Chain.class), (String)"Can't clone quarantined tests for new branch '%s' as it has no master.", (Object[])new Object[]{newBranch.getKey()});
        HashMap<String, TestClass> clonedTestClasses = new HashMap<String, TestClass>();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Quarantined tests on master (" + master.getPlanKey() + ") plan count: " + this.testQuarantineManager.getCurrentlyQuarantinedTests((ImmutableChain)master).size()));
        }
        for (TestCase quarantinedTest : this.testQuarantineManager.getCurrentlyQuarantinedTests((ImmutableChain)master)) {
            log.debug((Object)("quarantinedTest = " + quarantinedTest.getTestClass().getName() + "::" + quarantinedTest.getName()));
            QuarantineStatistics quarantineStatistics = quarantinedTest.getQuarantineStatistics();
            if (quarantineStatistics == null) {
                log.debug((Object)("warning: QuarantineStatistics are null for '" + master.getKey() + "'->" + quarantinedTest.getName()));
                continue;
            }
            TestClass quarantinedTestClass = quarantinedTest.getTestClass();
            PlanKey masterChainKey = quarantinedTestClass.getPlan().getPlanKey();
            Chain masterChain = (Chain)this.planManager.getPlanByKey(masterChainKey, Chain.class);
            Preconditions.checkNotNull((Object)masterChain, (String)"Can't clone quarantined test '%s' for a new branch '%s' - chain with key '%s' not found", (Object[])new Object[]{quarantinedTestClass.getName(), newBranch, masterChainKey.getKey()});
            Job masterJob = masterChain.getAllJobs().stream().filter(job -> job.getId() == quarantinedTestClass.getMasterJobId()).findFirst().orElseThrow(IllegalStateException::new);
            String className = quarantinedTestClass.getName();
            TestClass clonedTestClass = clonedTestClasses.computeIfAbsent(masterJob.getKey() + ":" + className, n -> new TestClassImpl(className, (Plan)newBranch, masterJob.getId()));
            TestCaseImpl clonedTestCase = new TestCaseImpl(quarantinedTest.getName());
            clonedTestCase.setQuarantineStatistics(quarantineStatistics.getQuarantiningUsername(), quarantineStatistics.getQuarantineDate(), quarantineStatistics.getQuarantineExpiryDate());
            clonedTestClass.addTest((TestCase)clonedTestCase);
        }
        for (TestClass testClass : clonedTestClasses.values()) {
            this.testsManager.saveTestClass(testClass);
            log.debug((Object)String.format("Saved cloned TestClass %s with %d TestCases", testClass, testClass.getTestCases().size()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Quarantined tests on branch (" + newBranch.getPlanKey() + ") count: " + this.testQuarantineManager.getCurrentlyQuarantinedTests((ImmutableChain)newBranch).size()));
            for (TestCase quarantinedTest : this.testQuarantineManager.getCurrentlyQuarantinedTests((ImmutableChain)newBranch)) {
                log.debug((Object)("quarantinedTest = " + quarantinedTest.getTestClass().getName() + "::" + quarantinedTest.getName()));
            }
        }
    }

    @Override
    public void triggerCreationCompleteEvents(PlanKey planKey) {
        this.jiraBranchLinkingService.linkBranchToIssueIfRequiredAsync(planKey, this.authenticationContext.getUserName());
        this.cloneQuarantinedTestsFromMaster(planKey);
        this.eventPublisher.publish((Object)new ChainCreatedEvent(this, planKey));
        this.auditLogService.log("Plan branch has been created.", (Key)planKey, AuditLogEntityType.PLAN);
        this.auditLogService.log("New Plan branch created", null, planKey.toString(), null);
    }

    public String createPlan(@NotNull BuildConfiguration buildConfiguration, @NotNull ActionParametersMap actionParametersMap, @NotNull PlanCreationService.EnablePlan enabled) throws PlanCreationDeniedException, PlanCreationException {
        String masterChainKey = ChainParamMapHelper.getPlanKeyToClone(actionParametersMap);
        ImmutableChain chain = (ImmutableChain)Preconditions.checkNotNull((Object)this.planManager.getPlanByKey(masterChainKey, Chain.class), (Object)(masterChainKey + " should be a master chain key, but it does not exist"));
        String branchName = ChainParamMapHelper.getBranchName(actionParametersMap);
        return (String)this.exclusionService.withNewLockedObject((Enum)ScopedExclusionService.ExclusionScopeType.CHAIN_KEY, (Object)chain.getProject().getKey(), null, this.uniquePlanKeyGenerator((ImmutablePlan)chain), this.withUniquePlanKey(chain, branchName, buildConfiguration, actionParametersMap, enabled));
    }

    private ScopedExclusionService.ExclusiveFunction<String, String, PlanCreationDeniedException> withUniquePlanKey(final ImmutableChain masterChain, final String branchName, final BuildConfiguration buildConfiguration, final ActionParametersMap actionParametersMap, final PlanCreationService.EnablePlan enabled) {
        return new ScopedExclusionService.ExclusiveFunction<String, String, PlanCreationDeniedException>(){

            public String apply(@Nullable String uniquePlanKey) throws PlanCreationDeniedException {
                return (String)ChainBranchCreationServiceImpl.this.exclusionService.withNewLockedObject((Enum)ScopedExclusionService.ExclusionScopeType.CHAIN_BRANCH_NAME, (Object)masterChain.getPlanKey().toString(), null, ChainBranchCreationServiceImpl.this.uniqueChainBranchNameGenerator(branchName, (PlanIdentifier)masterChain), ChainBranchCreationServiceImpl.this.withUniqueChainBranchName(buildConfiguration, actionParametersMap, uniquePlanKey, enabled));
            }
        };
    }

    private ScopedExclusionService.ExclusiveFunction<String, String, PlanCreationDeniedException> withUniqueChainBranchName(final BuildConfiguration buildConfiguration, final ActionParametersMap actionParametersMap, final String uniquePlanKey, final PlanCreationService.EnablePlan enabled) {
        return new ScopedExclusionService.ExclusiveFunction<String, String, PlanCreationDeniedException>(){

            public String apply(@Nullable String uniqueBranchName) throws PlanCreationDeniedException {
                return ChainBranchCreationServiceImpl.this.createPlan(buildConfiguration, actionParametersMap, enabled, ChainBranchCreationServiceImpl.this.preparePlanDetails(uniquePlanKey, uniqueBranchName));
            }
        };
    }

    private BiConsumer<Plan, ActionParametersMap> preparePlanDetails(String uniquePlanKey, String uniqueBranchName) {
        return (planBranch, params) -> {
            Plan planToClone = this.planManager.getPlanByKey(ChainParamMapHelper.getPlanKeyToClone(params));
            this.validateThrowingPlanCreationException(planToClone != null, "Plan to create branch from doesn't exist anymore, but it passed validation. What has happened here???");
            planBranch.setProject(planToClone.getProject());
            planBranch.setBuildName(uniqueBranchName);
            planBranch.setDescription(params.getString("branchDescription", "").trim());
            planBranch.setBuildKey(uniquePlanKey);
        };
    }

    private ScopedExclusionService.GeneratorCallable<String, IncorrectPlanTypeException> uniquePlanKeyGenerator(final ImmutablePlan chain) {
        return new ScopedExclusionService.GeneratorCallable<String, IncorrectPlanTypeException>(){

            public String call() throws IncorrectPlanTypeException {
                long i = ChainBranchCreationServiceImpl.this.chainBranchManager.getNextBranchKeyNumber(chain);
                while (true) {
                    String candidateKey = chain.getBuildKey() + i;
                    if (!ChainBranchCreationServiceImpl.this.planManager.isPlanKeyConflicting(PlanKeys.getPlanKey((String)chain.getProject().getKey(), (String)candidateKey))) {
                        ChainBranchCreationServiceImpl.this.chainBranchManager.updateNextBranchKeyNumber(chain, i + 1L);
                        return candidateKey;
                    }
                    ++i;
                }
            }
        };
    }

    private ScopedExclusionService.GeneratorCallable<String, RuntimeException> uniqueChainBranchNameGenerator(final String chainBranchNameStem, PlanIdentifier chain) {
        final Supplier existingPlanNamesRef = Lazy.supplier(() -> {
            Set existingPlanNames = this.chainBranchManager.getBranchIdentifiersForChain(chain).stream().map(PlanIdentifier::getBuildName).collect(Collectors.toCollection(HashSet::new));
            existingPlanNames.add(chain.getBuildName());
            return existingPlanNames;
        });
        return new ScopedExclusionService.GeneratorCallable<String, RuntimeException>(){

            public String call() {
                String name = chainBranchNameStem;
                int i = 1;
                while (((Set)existingPlanNamesRef.get()).contains(name)) {
                    name = chainBranchNameStem + " " + i++;
                }
                return name;
            }
        };
    }
}

