/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.creation;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildDefinitionForBuild;
import com.atlassian.bamboo.build.BuildNumberGeneratorService;
import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.build.DefaultBuildDefinitionForBuild;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.PartialBuildDefinition;
import com.atlassian.bamboo.build.PlanCreationDeniedException;
import com.atlassian.bamboo.build.PlanCreationException;
import com.atlassian.bamboo.build.creation.ChainCreationService;
import com.atlassian.bamboo.build.creation.ChainParamMapHelper;
import com.atlassian.bamboo.build.creation.JobCreationService;
import com.atlassian.bamboo.build.creation.PlanCreationBean;
import com.atlassian.bamboo.build.creation.PlanCreationService;
import com.atlassian.bamboo.build.creation.PlanCreationTemplate;
import com.atlassian.bamboo.build.creation.PlanValidationService;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.ChainStageImpl;
import com.atlassian.bamboo.chains.DefaultChain;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.core.ScopedExclusionService;
import com.atlassian.bamboo.event.ChainCreatedEvent;
import com.atlassian.bamboo.event.analytics.GenericAnalyticsEvent;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.fieldvalue.BuildDefinitionConverter;
import com.atlassian.bamboo.key.KeyGenerator;
import com.atlassian.bamboo.labels.LabelManager;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.notification.NotificationSet;
import com.atlassian.bamboo.notification.NotificationSetImpl;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.IncorrectPlanTypeException;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscription;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.branch.BranchCommitInformationManager;
import com.atlassian.bamboo.plan.branch.BranchDetectionService;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfigurationImpl;
import com.atlassian.bamboo.plan.branch.BranchIntegrationPointImpl;
import com.atlassian.bamboo.plan.branch.BranchMonitoringConfiguration;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.plan.branch.VcsBranchManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryService;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectConfigurationService;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.repository.PlanRepositoryLink;
import com.atlassian.bamboo.repository.PlanRepositoryLinkImpl;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDataEntityImpl;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.schedule.PlanScheduler;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.task.TaskConfigurationService;
import com.atlassian.bamboo.trigger.TriggerConfigurationService;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.v2.build.trigger.DependencyBlockingStrategy;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionImpl;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverter;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.struts.TextProvider;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.opensymphony.xwork.ValidationAware;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.Permission;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainCreationServiceImpl
extends PlanCreationTemplate
implements ChainCreationService {
    private static final Logger log = Logger.getLogger(ChainCreationService.class);
    static final String CLONE_PLAN = "clonePlan";
    private static final String REPOSITORY_ROOT = "repository";
    private final JobCreationService jobCreationService;
    private final ScopedExclusionService scopedExclusionService;
    private final BranchDetectionService branchDetectionService;
    private final PlanVcsRevisionHistoryService planVcsRevisionHistoryService;
    private final LabelManager labelManager;
    @Inject
    private RawRepositoryConfigurationXmlConverter rawRepositoryConfigurationXmlConverter;
    @Inject
    private ProjectConfigurationService projectConfigurationService;
    @Inject
    private BambooPermissionManager bambooPermissionManager;
    @Inject
    private TextProvider textProvider;

    public ChainCreationServiceImpl(PlanManager planManager, ProjectManager projectManager, BambooAclUpdateHelper aclUpdateHelper, BambooAuthenticationContext authenticationContext, BambooLicenseManager bambooLicenseManager, HibernateMutableAclService aclService, PlanScheduler planScheduler, EventPublisher eventPublisher, PlanValidationService planValidationService, AuditLogService auditLogService, BuildDefinitionConverter buildDefinitionConverter, NotificationManager notificationManager, JobCreationService jobCreationService, ArtifactDefinitionManager artifactDefinitionManager, ArtifactSubscriptionManager artifactSubscriptionManager, VariableDefinitionManager variableDefinitionManager, RepositoryDefinitionManager repositoryDefinitionManager, TaskConfigurationService taskConfigurationService, ScopedExclusionService scopedExclusionService, BranchCommitInformationManager branchCommitInformationManager, VcsBranchManager vcsBranchManager, BranchDetectionService branchDetectionService, TriggerConfigurationService triggerConfigurationService, PlanVcsRevisionHistoryService planVcsRevisionHistoryService, BuildNumberGeneratorService buildNumberGeneratorService, LabelManager labelManager) {
        super(planManager, projectManager, aclUpdateHelper, authenticationContext, bambooLicenseManager, aclService, planScheduler, eventPublisher, planValidationService, auditLogService, buildDefinitionConverter, artifactDefinitionManager, artifactSubscriptionManager, variableDefinitionManager, repositoryDefinitionManager, taskConfigurationService, notificationManager, branchCommitInformationManager, vcsBranchManager, triggerConfigurationService, buildNumberGeneratorService);
        this.jobCreationService = jobCreationService;
        this.scopedExclusionService = scopedExclusionService;
        this.branchDetectionService = branchDetectionService;
        this.planVcsRevisionHistoryService = planVcsRevisionHistoryService;
        this.labelManager = labelManager;
    }

    public void validatePlan(com.atlassian.struts.ValidationAware validationAware, BuildConfiguration buildConfiguration, ActionParametersMap params) {
        this.validateChainDetails(validationAware, params);
        if (validationAware.hasErrors()) {
            return;
        }
        boolean clonePlan = params.getBoolean(CLONE_PLAN);
        if (clonePlan) {
            this.validateCloneDetails(validationAware, params);
        }
    }

    public void validateChainDetails(com.atlassian.struts.ValidationAware validationAware, ActionParametersMap params) {
        String projectKey = ChainParamMapHelper.getProjectKey(params);
        String chainKey = ChainParamMapHelper.getPartialChainKey(params);
        String projectName = ChainParamMapHelper.getProjectName(params);
        String projectDescription = ChainParamMapHelper.getProjectDescription(params);
        String chainName = ChainParamMapHelper.getChainName(params);
        String existingProjectKey = ChainParamMapHelper.getExistingProjectKey(params);
        String chainDescription = params.getString("chainDescription", "").trim();
        this.planValidationService.validateKey(validationAware, "chainKey", "plan", chainKey);
        this.planValidationService.validateName(validationAware, "chainName", "chain", chainName);
        this.planValidationService.validateDescription(validationAware, "chainDescription", chainDescription);
        if (ChainParamMapHelper.isNewProject(params)) {
            this.planValidationService.validateNewProjectDetails(validationAware, projectName, projectKey, projectDescription);
        } else if (!validationAware.hasErrors()) {
            this.planValidationService.validateNewChainForExistingProject(validationAware, existingProjectKey, chainKey, chainName);
        }
    }

    public void validateCloneDetails(com.atlassian.struts.ValidationAware validationAware, ActionParametersMap params) {
        String planKeyToClone = ChainParamMapHelper.getPlanKeyToClone(params);
        if (StringUtils.isBlank((CharSequence)planKeyToClone)) {
            validationAware.addFieldError(CLONE_PLAN, "Please select a plan to clone");
        } else {
            Plan planToClone = this.planManager.getPlanByKey(planKeyToClone);
            if (planToClone == null) {
                validationAware.addFieldError("planKeyToClone", "Could not find plan to clone with key " + planKeyToClone);
            } else {
                TopLevelPlan topLevelPlanToClone = (TopLevelPlan)Narrow.to((Object)planToClone, TopLevelPlan.class);
                if (topLevelPlanToClone == null) {
                    validationAware.addFieldError("planKeyToClone", "You cannot clone a plan of type " + planToClone.getPlanType() + " to plan");
                } else {
                    int planLimit;
                    Chain chainToClone = (Chain)Narrow.to((Object)planToClone, Chain.class);
                    if (chainToClone != null && -1 != (planLimit = this.bambooLicenseManager.getAllowedNumberOfPlans())) {
                        int currentPlans = this.planManager.getPlanCount(Buildable.class);
                        int jobCount = chainToClone.getJobCount();
                        if (jobCount + currentPlans > planLimit) {
                            validationAware.addFieldError("planKeyToClone", "You can not clone this plan, it has " + jobCount + " jobs but your license only allows " + (planLimit - currentPlans) + " more jobs");
                        }
                    }
                }
                this.validateClonePermissions(planToClone, validationAware);
            }
        }
    }

    private void validateClonePermissions(@NotNull Plan planToClone, @NotNull com.atlassian.struts.ValidationAware validationAware) {
        if (!this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.CLONE, (ImmutablePlan)planToClone)) {
            validationAware.addFieldError("planKeyToClone", this.textProvider.getText("plan.clone.insufficient.permissions", Collections.singletonList(planToClone.getPlanKey().getKey())));
        } else {
            for (VcsRepositoryData vcsRepositoryData : this.repositoryDefinitionManager.getPlanRepositoryDefinitions((PlanIdentifier)planToClone)) {
                VcsRepositoryData linkedRepository;
                if (vcsRepositoryData.isMarkedForDeletion() || !vcsRepositoryData.isRootVcsLinked() || this.bambooPermissionManager.hasPermission((Permission)BambooPermission.READ, (Object)(linkedRepository = this.repositoryDefinitionManager.getVcsRepositoryData(vcsRepositoryData.getRootVcsRepositoryId())), null)) continue;
                validationAware.addFieldError("planKeyToClone", this.textProvider.getText("plan.clone.insufficient.repository.permissions", (List)ImmutableList.of((Object)linkedRepository.getName(), (Object)planToClone.getPlanKey().getKey())));
            }
        }
    }

    public Chain getNewInstance() {
        DefaultChain chainBeingCreated = new DefaultChain();
        chainBeingCreated.setNotificationSet(new NotificationSetImpl());
        ContainerManager.autowireComponent((Object)chainBeingCreated);
        return chainBeingCreated;
    }

    @Override
    protected MutableAcl getDefaultPermissionsForPlan(boolean accessForAllUsers) {
        User user = this.authenticationContext.getUser();
        this.validateThrowingPlanCreationException(user != null, "Failed to create new plan.  No user was found in the context");
        return this.aclUpdateHelper.createNewDefaultAcl(user, Chain.class, accessForAllUsers);
    }

    public BuildConfiguration getBuildConfigurationWithDefaults() {
        return new BuildConfiguration();
    }

    @Nullable
    private Project getOrCreateProject(@NotNull ActionParametersMap params) {
        Project project;
        String existingProjectKey = ChainParamMapHelper.getExistingProjectKey(params);
        String projectKey = ChainParamMapHelper.getProjectKey(params);
        String projectName = ChainParamMapHelper.getProjectName(params);
        String projectDescription = ChainParamMapHelper.getProjectDescription(params);
        if (ChainParamMapHelper.isNewProject(params)) {
            log.info((Object)("Creating project " + projectKey));
            project = this.projectManager.createProject(projectKey, projectName, projectDescription);
        } else {
            project = this.projectManager.getProjectByKey(existingProjectKey);
        }
        return project;
    }

    @Override
    protected boolean performCloneIfRequired(@NotNull BuildConfiguration buildConfiguration, @NotNull PlanCreationBean planCreationBean, @NotNull ActionParametersMap params) throws PlanCreationDeniedException {
        boolean isCloneRequested = ChainParamMapHelper.isCloneRequested(params);
        String chainKeyToClone = ChainParamMapHelper.getPlanKeyToClone(params);
        if (!isCloneRequested || StringUtils.isBlank((CharSequence)chainKeyToClone)) {
            return false;
        }
        PlanKey chainCloneSource = PlanKeys.getPlanKey((String)chainKeyToClone);
        Plan newPlan = planCreationBean.getPlanBeingCreated();
        Plan planToClone = this.planManager.getPlanByKey(chainCloneSource);
        this.validateThrowingPlanCreationException(newPlan != null, "An internal error occurred, the plan you are creating went missing");
        String planOwner = this.authenticationContext.getUserName();
        this.validateThrowingPlanCreationException(planToClone != null && planOwner != null, "Unable to find plan to clone (" + chainCloneSource + ")");
        Chain newChain = (Chain)Narrow.to((Object)newPlan, Chain.class);
        this.validateThrowingPlanCreationException(newChain != null, "An internal error occurred, cloning is not available for plan type: " + newPlan.getPlanType() + ".");
        TopLevelPlan topLevelPlanToClone = (TopLevelPlan)Narrow.to((Object)planToClone, TopLevelPlan.class);
        this.validateThrowingPlanCreationException(topLevelPlanToClone != null, "Cannot clone plan " + planToClone.getKey() + " it is the wrong plan type: " + planToClone.getClass());
        Chain chainToClone = (Chain)Narrow.to((Object)planToClone, Chain.class);
        if (chainToClone != null) {
            this.validateLicense(chainToClone);
        }
        XMLConfiguration configuration = this.buildDefinitionConverter.fromObject((PartialBuildDefinition)topLevelPlanToClone.getBuildDefinition());
        buildConfiguration = new BuildConfiguration((HierarchicalConfiguration)configuration);
        planCreationBean.setConfigurationBeingEdited(buildConfiguration);
        BranchIntegrationConfigurationImpl bic = new BranchIntegrationConfigurationImpl(topLevelPlanToClone.getBuildDefinition().getBranchMonitoringConfiguration().getDefaultBranchIntegrationConfiguration(), true);
        bic.setBranchIntegrationPoint(BranchIntegrationPointImpl.forPlanBranch(ChainParamMapHelper.getChainKey(params)));
        bic.toConfiguration((HierarchicalConfiguration)configuration);
        this.clonePlanPermissionsToSession((Plan)topLevelPlanToClone, planCreationBean, planOwner);
        LinkedHashMap<ArtifactDefinition, ArtifactDefinition> definitions = new LinkedHashMap<ArtifactDefinition, ArtifactDefinition>();
        HashMap<Plan, Job> jobMapping = new HashMap<Plan, Job>();
        HashMap<Long, RepositoryDataEntityImpl> repositories = new HashMap<Long, RepositoryDataEntityImpl>();
        ArrayList<PlanRepositoryLinkImpl> planRepositories = new ArrayList<PlanRepositoryLinkImpl>();
        if (chainToClone != null) {
            NotificationSet nSet = this.notificationManager.cloneNotificationSet(chainToClone.getNotificationSet());
            newChain.setNotificationSet(nSet);
            for (PlanRepositoryLink planRepository : this.repositoryDefinitionManager.getPlanRepositoryLinks((ImmutablePlan)chainToClone)) {
                RepositoryDataEntity repositoryDataEntity = planRepository.getRepositoryDataEntity();
                if (repositoryDataEntity.isMarkedForDeletion()) continue;
                RepositoryDataEntityImpl newRepositoryDefinition = new RepositoryDataEntityImpl(repositoryDataEntity);
                if (repositoryDataEntity.isGlobal()) {
                    newRepositoryDefinition.setXmlData(this.rawRepositoryConfigurationXmlConverter.emptyXml());
                    newRepositoryDefinition.setParent(repositoryDataEntity);
                    newRepositoryDefinition.setGlobal(false);
                }
                repositories.put(repositoryDataEntity.getId(), newRepositoryDefinition);
                planRepositories.add(new PlanRepositoryLinkImpl((Plan)newChain, newRepositoryDefinition, planRepository.getPosition()));
            }
            for (ChainStage stageToClone : chainToClone.getStages()) {
                ChainStageImpl newStage = new ChainStageImpl(newChain, stageToClone.getName(), stageToClone.getDescription(), stageToClone.isManual(), stageToClone.isFinal());
                stageToClone.getJobs().forEach(this.cloneJob(definitions, jobMapping, newChain, newStage));
                newChain.addStage((ChainStage)newStage);
            }
        }
        ArrayList<ArtifactDefinition> clonedArtifactDefinitions = new ArrayList<ArtifactDefinition>();
        for (Map.Entry artifactDefinitionArtifactDefinitionEntry : definitions.entrySet()) {
            ArtifactDefinition cloned = (ArtifactDefinition)artifactDefinitionArtifactDefinitionEntry.getValue();
            ArrayList<ArtifactSubscriptionImpl> subscriptions = new ArrayList<ArtifactSubscriptionImpl>();
            for (ArtifactSubscription subscription : ((ArtifactDefinition)artifactDefinitionArtifactDefinitionEntry.getKey()).getSubscriptions()) {
                Job newConsumer = (Job)jobMapping.get(subscription.getConsumerJob());
                subscriptions.add(new ArtifactSubscriptionImpl(cloned, newConsumer, subscription.getDestinationDirectory()));
            }
            cloned.setSubscriptions(subscriptions);
            clonedArtifactDefinitions.add(cloned);
        }
        planCreationBean.setArtifactDefinitionsBeingCreated(clonedArtifactDefinitions);
        this.cloneVariableDefinitions(planCreationBean, planToClone, (Plan)newChain);
        planCreationBean.setRepositoriesBeingCreated(repositories);
        planCreationBean.setPlanRepositoriesBeingCreated(planRepositories);
        this.validateThrowingPlanCreationException(planCreationBean.getConfigurationBeingEdited() != null, "Unable to clone plan " + chainCloneSource + ". Unknown exception has occurred");
        return true;
    }

    private Consumer<Job> cloneJob(Map<ArtifactDefinition, ArtifactDefinition> definitions, Map<Plan, Job> jobMapping, Chain newChain, ChainStage newStage) {
        return job -> {
            Job newJob = this.jobCreationService.getNewInstance();
            newJob.setBuildKey(job.getBuildKey());
            newJob.setBuildName(job.getBuildName());
            newJob.setDescription(job.getDescription());
            newJob.setProject(newChain.getProject());
            newJob.setSuspendedFromBuilding(job.isSuspendedFromBuilding());
            BuildConfiguration jobConfiguration = new BuildConfiguration((HierarchicalConfiguration)this.buildDefinitionConverter.fromObject((PartialBuildDefinition)job.getBuildDefinition()));
            DefaultBuildDefinitionForBuild buildDefinitionForBuild = new DefaultBuildDefinitionForBuild(jobConfiguration.isMerged());
            buildDefinitionForBuild.setXmlData(jobConfiguration.asXml());
            newJob.setBuildDefinitionXml((BuildDefinitionForBuild)buildDefinitionForBuild);
            RequirementSet requirementSetToClone = job.getRequirementSet();
            for (Requirement requirement : requirementSetToClone.getRequirements()) {
                RequirementImpl newRequirement = new RequirementImpl(requirement);
                newJob.getRequirementSet().addRequirement((Requirement)newRequirement);
            }
            newJob.setPlanKey(PlanKeys.getJobKey((PlanKey)newChain.getPlanKey(), (String)newJob.getBuildKey()));
            definitions.putAll(this.artifactDefinitionManager.cloneArtifactDefinitions(job, newJob));
            jobMapping.put((Plan)job, newJob);
            newJob.setStage(newStage);
            newStage.addJob(newJob);
        };
    }

    private void cloneVariableDefinitions(PlanCreationBean planCreationBean, Plan planToClone, Plan newChain) {
        ArrayList<VariableDefinitionImpl> clonedVariableDefinitions = new ArrayList<VariableDefinitionImpl>();
        for (VariableDefinition variableDefinition : this.variableDefinitionManager.getPlanVariables((PlanIdentifier)planToClone)) {
            VariableDefinitionImpl clonedVariableDefinition = new VariableDefinitionImpl(variableDefinition);
            clonedVariableDefinition.setPlan(newChain);
            clonedVariableDefinitions.add(clonedVariableDefinition);
        }
        planCreationBean.setVariableDefinitionsBeingCreated(clonedVariableDefinitions);
    }

    private void validateLicense(Chain chainToClone) throws PlanCreationDeniedException {
        int planLimit = this.bambooLicenseManager.getAllowedNumberOfPlans();
        if (-1 != planLimit) {
            int currentPlans = this.planManager.getPlanCount(Buildable.class);
            int jobCount = chainToClone.getJobCount();
            if (jobCount + currentPlans > planLimit) {
                throw new PlanCreationDeniedException("You can not clone this plan, it has " + jobCount + " jobs but your license only allows " + (planLimit - currentPlans) + " more plans");
            }
        }
    }

    private List<PlanRepositoryLink> extractRepositoriesFromConfiguration(@NotNull BuildConfiguration buildConfiguration, @NotNull Plan plan) {
        long selectedRepositoryId;
        RepositoryDataEntity globalRepositoryEntity;
        ArrayList<PlanRepositoryLink> createdRepositories = new ArrayList<PlanRepositoryLink>();
        if (NumberUtils.isCreatable((String)buildConfiguration.getString("selectedRepository")) && (globalRepositoryEntity = this.repositoryDefinitionManager.getRepositoryDataEntity(selectedRepositoryId = buildConfiguration.getLong("selectedRepository"))) != null) {
            RepositoryDataEntityImpl childEntity = new RepositoryDataEntityImpl(globalRepositoryEntity);
            childEntity.setGlobal(false);
            childEntity.setParent(globalRepositoryEntity);
            childEntity.setXmlData(this.rawRepositoryConfigurationXmlConverter.emptyXml());
            PlanRepositoryLinkImpl planRepository = new PlanRepositoryLinkImpl();
            planRepository.setPlan(plan);
            planRepository.setRepositoryDataEntity(childEntity);
            createdRepositories.add(planRepository);
        }
        buildConfiguration.clearTree(REPOSITORY_ROOT);
        buildConfiguration.clearProperty("selectedRepository");
        buildConfiguration.clearProperty("filter.pattern.option");
        buildConfiguration.clearProperty("filter.pattern.regex");
        buildConfiguration.clearProperty("commit.isolation.option");
        return createdRepositories;
    }

    @Override
    protected void prepareBuildConfiguration(@NotNull BuildConfiguration buildConfiguration, @NotNull Plan plan, @NotNull PlanCreationBean planCreationBean) {
        buildConfiguration.setProperty("custom.dependencies.triggerForBranches", (Object)"true");
        buildConfiguration.setProperty("custom.dependencies.trigger.remote.strategy", (Object)DependencyBlockingStrategy.None);
        planCreationBean.setPlanRepositoriesBeingCreated(this.extractRepositoriesFromConfiguration(buildConfiguration, plan));
        HashMap<Long, RepositoryDataEntity> repositoriesBeingCreated = new HashMap<Long, RepositoryDataEntity>();
        for (PlanRepositoryLink planRepository : planCreationBean.getPlanRepositoriesBeingCreated()) {
            repositoriesBeingCreated.put(-1L, planRepository.getRepositoryDataEntity());
        }
        planCreationBean.setRepositoriesBeingCreated(repositoriesBeingCreated);
    }

    @Override
    public void cleanBuildConfiguration(@NotNull BuildConfiguration buildConfiguration, @NotNull Plan plan) {
        buildConfiguration.clearTree("builder");
        buildConfiguration.clearTree("artifacts");
        ChainCreationServiceImpl.cleanBuildConfiguration(buildConfiguration);
        Chain chain = (Chain)Narrow.to((Object)plan, Chain.class);
        if (chain == null) {
            throw new IllegalStateException("Trying to perform build related methods on a " + plan.getClass());
        }
    }

    public String createPlan(@NotNull BuildConfiguration buildConfiguration, @NotNull ActionParametersMap params, @NotNull PlanCreationService.EnablePlan enabled) throws PlanCreationDeniedException, PlanCreationException {
        if (ChainParamMapHelper.isNewProject(params)) {
            this.eventPublisher.publish((Object)new GenericAnalyticsEvent("bamboo.admin.project.created.withPlan"));
            String projectKey = ChainParamMapHelper.getProjectKey(params);
            return (String)this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.PROJECT_DATA, (Object)projectKey, this.withLockedProjectKey(buildConfiguration, params, enabled));
        }
        return this.createPlanAndKey(buildConfiguration, params, enabled);
    }

    private String createPlanAndKey(@NotNull BuildConfiguration buildConfiguration, @NotNull ActionParametersMap params, @NotNull PlanCreationService.EnablePlan enabled) throws PlanCreationDeniedException, PlanCreationException {
        String chainKey = ChainParamMapHelper.getPartialChainKey(params);
        if (StringUtils.isEmpty((CharSequence)chainKey)) {
            String projectKey = ChainParamMapHelper.isNewProject(params) ? ChainParamMapHelper.getProjectKey(params) : ChainParamMapHelper.getExistingProjectKey(params);
            String chainName = ChainParamMapHelper.getChainName(params);
            int desiredKeyLength = 4;
            int maxKeyLength = 200;
            return (String)this.scopedExclusionService.withNewLockedObject((Enum)ScopedExclusionService.ExclusionScopeType.CHAIN_KEY, (Object)projectKey, null, this.uniquePlanKeyGenerator(projectKey, KeyGenerator.generateKey(chainName, 4, 200)), this.withUniquePlanKey(buildConfiguration, params, enabled));
        }
        return this.superCreatePlan(buildConfiguration, params, chainKey, enabled);
    }

    private ScopedExclusionService.ExclusiveFunction<String, String, PlanCreationDeniedException> withLockedProjectKey(BuildConfiguration buildConfiguration, ActionParametersMap params, PlanCreationService.EnablePlan enabled) {
        return lockedProjectKey -> {
            this.validateThrowingPlanCreationException(this.projectManager.getProjectByKey(lockedProjectKey) == null, "Project " + lockedProjectKey + " already exists");
            String projectName = ChainParamMapHelper.getProjectName(params);
            return (String)this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.PROJECT_DATA, (Object)projectName, this.createProjectAndPlan(buildConfiguration, params, enabled));
        };
    }

    private ScopedExclusionService.ExclusiveFunction<String, String, PlanCreationDeniedException> withUniquePlanKey(@NotNull BuildConfiguration buildConfiguration, @NotNull ActionParametersMap actionParametersMap, @NotNull PlanCreationService.EnablePlan enabled) {
        return uniquePlanKey -> this.superCreatePlan(buildConfiguration, actionParametersMap, (String)uniquePlanKey, enabled);
    }

    @NotNull
    private String superCreatePlan(@NotNull BuildConfiguration buildConfiguration, @NotNull ActionParametersMap actionParametersMap, @NotNull String uniquePlanKey, @NotNull PlanCreationService.EnablePlan enabled) throws PlanCreationDeniedException {
        boolean cloneRequest = ChainParamMapHelper.isCloneRequested(actionParametersMap);
        String planKey = this.createPlan(buildConfiguration, actionParametersMap, enabled, this.preparePlanDetails(uniquePlanKey));
        if (cloneRequest) {
            this.copyLabels(ChainParamMapHelper.getPlanKeyToClone(actionParametersMap), PlanKeys.getPlanKey((String)planKey));
        }
        return planKey;
    }

    private BiConsumer<Plan, ActionParametersMap> preparePlanDetails(String uniquePlanKey) {
        return (plan, params) -> {
            plan.setProject((Project)Preconditions.checkNotNull((Object)this.getOrCreateProject((ActionParametersMap)params)));
            String chainName = ChainParamMapHelper.getChainName(params);
            String chainDescription = params.getString("chainDescription", "").trim();
            plan.setBuildName(chainName);
            plan.setBuildKey(uniquePlanKey);
            plan.setDescription(chainDescription);
        };
    }

    private void copyLabels(String planKeyToClone, @Nullable PlanKey planKey) {
        try {
            PlanKey chainKeyToClone;
            Plan chainToClone;
            if (StringUtils.isNotBlank((CharSequence)planKeyToClone) && (chainToClone = this.planManager.getPlanByKey(chainKeyToClone = PlanKeys.getPlanKey((String)planKeyToClone))) != null && !chainToClone.hasMaster() && planKey != null) {
                Set planLabels = this.labelManager.getPlanLabels((ImmutablePlan)chainToClone);
                planLabels.forEach(planLabel -> this.labelManager.addLabel(planLabel.getName(), planKey, this.authenticationContext.getUser()));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private ScopedExclusionService.ExclusiveFunction<String, String, PlanCreationDeniedException> createProjectAndPlan(BuildConfiguration buildConfiguration, ActionParametersMap params, PlanCreationService.EnablePlan enabled) {
        return lockedProjectName -> {
            this.validateThrowingPlanCreationException(this.projectManager.getProjectByName(lockedProjectName) == null, "Project " + lockedProjectName + " already exists");
            return this.createPlanAndKey(buildConfiguration, params, enabled);
        };
    }

    private ScopedExclusionService.GeneratorCallable<String, IncorrectPlanTypeException> uniquePlanKeyGenerator(@NotNull String projectKey, @NotNull String seed) {
        return () -> {
            if (!this.planManager.isPlanKeyConflicting(PlanKeys.getPlanKey((String)projectKey, (String)seed))) {
                return seed;
            }
            int i = 0;
            String candidateKey;
            while (this.planManager.isPlanKeyConflicting(PlanKeys.getPlanKey((String)projectKey, (String)(candidateKey = seed + i)))) {
                ++i;
            }
            return candidateKey;
        };
    }

    @Override
    protected void setFullPlanKey(@NotNull Plan plan) {
        plan.setPlanKey(PlanKeys.getPlanKey((String)plan.getProject().getKey(), (String)plan.getBuildKey()));
    }

    @Override
    protected void saveAndUpdateParents(@NotNull PlanCreationBean planCreationBean) {
        Plan plan = planCreationBean.getPlanBeingCreated();
        Preconditions.checkNotNull((Object)plan, (Object)"Plan to be created should be not null");
        if (plan.getProject().getId() == -1L) {
            Project persistedProject;
            Project project = plan.getProject();
            try {
                persistedProject = this.projectConfigurationService.createProject(project.getKey(), project.getName(), project.getDescription(), planCreationBean.getPublicAccessForNewProject());
            }
            catch (WebValidationException e) {
                throw Throwables.propagate((Throwable)e);
            }
            plan.setProject(persistedProject);
            if (plan instanceof TopLevelPlan) {
                ((TopLevelPlan)plan).getAllJobs().forEach(job -> job.setProject(persistedProject));
            }
        }
    }

    @Override
    protected void performPostCreateAction(@NotNull Plan plan) {
        this.planVcsRevisionHistoryService.clearRevisionHistoryForPlan(plan.getPlanKey());
        BranchMonitoringConfiguration monitoringConfiguration = plan.getBuildDefinition().getBranchMonitoringConfiguration();
        if (PlanBranchWorkflow.BRANCH_WORKFLOW == monitoringConfiguration.getPlanBranchWorkflow()) {
            this.branchDetectionService.scheduleBranchListInitialisation((Chain)plan);
        }
    }

    @Override
    public void triggerCreationCompleteEvents(PlanKey planKey) {
        this.eventPublisher.publish((Object)new ChainCreatedEvent(this, planKey));
        this.auditLogService.log("Plan has been created.", (Key)planKey, AuditLogEntityType.PLAN);
        this.auditLogService.log("New Plan created", null, planKey.toString(), null);
    }

    public void validateChainDetails(ValidationAware validationAware, ActionParametersMap params) {
        this.validateChainDetails((com.atlassian.struts.ValidationAware)validationAware, params);
    }

    public void validateCloneDetails(ValidationAware validationAware, ActionParametersMap params) {
        this.validateCloneDetails((com.atlassian.struts.ValidationAware)validationAware, params);
    }
}

