/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.creation;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ChainParamMapHelper {
    private ChainParamMapHelper() {
    }

    public static String getExistingProjectKey(ActionParametersMap params) {
        return ChainParamMapHelper.getTrimmedString(params, "existingProjectKey");
    }

    public static String getProjectKey(ActionParametersMap params) {
        return ChainParamMapHelper.getKey(params, "projectKey");
    }

    public static boolean isNewProject(ActionParametersMap params) {
        String existingProjectKey = ChainParamMapHelper.getExistingProjectKey(params);
        return "newProject".equals(existingProjectKey) || StringUtils.isEmpty((CharSequence)existingProjectKey);
    }

    public static String getProjectName(ActionParametersMap params) {
        return ChainParamMapHelper.getTrimmedString(params, "projectName");
    }

    public static String getProjectDescription(ActionParametersMap params) {
        return ChainParamMapHelper.getTrimmedString(params, "projectDescription");
    }

    @NotNull
    public static String getPlanKeyToClone(ActionParametersMap params) {
        return ChainParamMapHelper.getKey(params, "planKeyToClone");
    }

    public static String getBranchName(ActionParametersMap params) {
        return ChainParamMapHelper.getTrimmedString(params, "branchName");
    }

    public static String getBranchDescription(ActionParametersMap params) {
        return ChainParamMapHelper.getTrimmedString(params, "branchDescription");
    }

    @NotNull
    public static PlanKey getChainKey(@NotNull ActionParametersMap params) {
        String projectKey = ChainParamMapHelper.isNewProject(params) ? ChainParamMapHelper.getProjectKey(params) : ChainParamMapHelper.getExistingProjectKey(params);
        return PlanKeys.getPlanKey((String)projectKey, (String)ChainParamMapHelper.getPartialChainKey(params));
    }

    public static String getPartialChainKey(@NotNull ActionParametersMap params) {
        return ChainParamMapHelper.getKey(params, "chainKey");
    }

    public static String getChainName(@NotNull ActionParametersMap params) {
        return ChainParamMapHelper.getTrimmedString(params, "chainName");
    }

    public static boolean getPublicPlanAccess(@NotNull ActionParametersMap params) {
        return params.getBoolean("publicPlanAccess");
    }

    @NotNull
    private static String getKey(ActionParametersMap params, String key) {
        return StringUtils.upperCase((String)ChainParamMapHelper.getTrimmedString(params, key));
    }

    @NotNull
    private static String getTrimmedString(ActionParametersMap params, String key) {
        return params.getString(key, "").trim();
    }

    public static boolean isCloneRequested(ActionParametersMap params) {
        return params.getBoolean("clonePlan");
    }
}

